/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.util.Log;
import com.mousebird.maply.AttrDictionary;
import com.mousebird.maply.ComponentObject;
import com.mousebird.maply.CoordSystem;
import com.mousebird.maply.LayerThread;
import com.mousebird.maply.MBTiles;
import com.mousebird.maply.MapboxVectorTileParser;
import com.mousebird.maply.MaplyTileID;
import com.mousebird.maply.Mbr;
import com.mousebird.maply.Point2d;
import com.mousebird.maply.QuadPagingLayer;
import com.mousebird.maply.RemoteTileInfo;
import com.mousebird.maply.SphericalMercatorCoordSystem;
import com.mousebird.maply.VectorObject;
import com.mousebird.maply.VectorStyle;
import com.mousebird.maply.VectorStyleInterface;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.FileUtils;

public class MapboxVectorTileSource
implements QuadPagingLayer.PagingInterface {
    OkHttpClient client = new OkHttpClient();
    MBTiles mbTiles = null;
    RemoteTileInfo tileInfo = null;
    public boolean debugOutput = false;
    MapboxVectorTileParser tileParser = null;
    VectorStyleInterface vecStyleFactory = null;
    public CoordSystem coordSys = null;
    static double MAX_EXTENT = 2.0037508342789244E7;
    HashMap<MaplyTileID, ConnectionTask> tasks = new HashMap();
    File cacheDir = null;

    public MapboxVectorTileSource(MBTiles dataSource, VectorStyleInterface inVecStyleFactor) {
        this.mbTiles = dataSource;
        this.coordSys = this.mbTiles.coordSys;
        this.tileParser = new MapboxVectorTileParser();
        this.vecStyleFactory = inVecStyleFactor;
    }

    public MapboxVectorTileSource(RemoteTileInfo inTileInfo, VectorStyleInterface inVecStyleFactor) {
        this.tileInfo = inTileInfo;
        this.tileParser = new MapboxVectorTileParser();
        this.vecStyleFactory = inVecStyleFactor;
        this.coordSys = new SphericalMercatorCoordSystem();
    }

    @Override
    public int minZoom() {
        if (this.mbTiles != null) {
            return this.mbTiles.minZoom();
        }
        return this.tileInfo.minZoom;
    }

    @Override
    public int maxZoom() {
        if (this.mbTiles != null) {
            return this.mbTiles.maxZoom();
        }
        return this.tileInfo.maxZoom;
    }

    Point2d toMerc(Point2d pt) {
        Point2d newPt = new Point2d();
        newPt.setValue(Math.toDegrees(pt.getX()) * MAX_EXTENT / 180.0, 3189068.5 * Math.log((1.0 + Math.sin(pt.getY())) / (1.0 - Math.sin(pt.getY()))));
        return newPt;
    }

    boolean processData(QuadPagingLayer layer, MaplyTileID tileID, byte[] tileData) {
        ArrayList<ComponentObject> tileCompObjs = new ArrayList<ComponentObject>();
        if (tileData != null) {
            try {
                int count;
                ByteArrayInputStream bin = new ByteArrayInputStream(tileData);
                GZIPInputStream in = new GZIPInputStream(bin);
                ByteArrayOutputStream bout = new ByteArrayOutputStream(tileData.length * 2);
                byte[] buffer = new byte[1024];
                while ((count = in.read(buffer)) != -1) {
                    bout.write(buffer, 0, count);
                }
                tileData = bout.toByteArray();
            }
            catch (Exception ex) {
                // empty catch block
            }
            Mbr mbr = layer.geoBoundsForTile(tileID);
            mbr.ll = this.toMerc(mbr.ll);
            mbr.ur = this.toMerc(mbr.ur);
            MapboxVectorTileParser.DataReturn dataObjs = this.tileParser.parseData(tileData, mbr);
            if (dataObjs == null) {
                return false;
            }
            if (this.vecStyleFactory != null) {
                HashMap<String, ArrayList<VectorObject>> vecObjsPerStyle = new HashMap<String, ArrayList<VectorObject>>();
                if (dataObjs != null && dataObjs.vectorObjects != null) {
                    for (VectorObject vecObj : dataObjs.vectorObjects) {
                        VectorStyle[] styles;
                        AttrDictionary attrs = vecObj.getAttributes();
                        for (VectorStyle style : styles = this.vecStyleFactory.stylesForFeature(attrs, tileID, attrs.getString("layer_name"), layer.maplyControl)) {
                            ArrayList<VectorObject> vecObjsForStyle = (ArrayList<VectorObject>)vecObjsPerStyle.get(style.getUuid());
                            if (vecObjsForStyle == null) {
                                vecObjsForStyle = new ArrayList<VectorObject>();
                                vecObjsPerStyle.put(style.getUuid(), vecObjsForStyle);
                            }
                            vecObjsForStyle.add(vecObj);
                        }
                    }
                }
                for (String uuid : vecObjsPerStyle.keySet()) {
                    ComponentObject[] compObjs;
                    ArrayList vecObjs = (ArrayList)vecObjsPerStyle.get(uuid);
                    VectorStyle style = this.vecStyleFactory.styleForUUID(uuid, layer.maplyControl);
                    if (style == null || (compObjs = style.buildObjects(vecObjs, tileID, layer.maplyControl)) == null) continue;
                    for (int ii = 0; ii < compObjs.length; ++ii) {
                        tileCompObjs.add(compObjs[ii]);
                    }
                }
            }
            if (tileCompObjs.size() > 0) {
                layer.addData(tileCompObjs, tileID);
            }
            layer.tileDidLoad(tileID);
        } else {
            layer.tileDidLoad(tileID);
        }
        return true;
    }

    @Override
    public void startFetchForTile(final QuadPagingLayer layer, final MaplyTileID tileID) {
        if (this.mbTiles != null) {
            LayerThread thread = layer.maplyControl.getWorkingThread();
            thread.addTask(new Runnable(){

                @Override
                public void run() {
                    byte[] tileData = MapboxVectorTileSource.this.mbTiles.getDataTile(tileID);
                    MapboxVectorTileSource.this.processData(layer, tileID, tileData);
                }
            });
        } else {
            if (this.debugOutput) {
                Log.d((String)"Maply", (String)("Starting fetch for tile " + tileID.level + ": (" + tileID.x + "," + tileID.y + ")"));
            }
            int maxY = 1 << tileID.level;
            int remoteY = maxY - tileID.y - 1;
            URL tileURL = this.tileInfo.buildURL(tileID.x, remoteY, tileID.level);
            String cacheFile = null;
            if (this.cacheDir != null) {
                cacheFile = this.cacheDir.getAbsolutePath() + this.tileInfo.buildCacheName(tileID.x, tileID.y, tileID.level);
            }
            ConnectionTask task = new ConnectionTask(layer, this, tileID, tileURL, cacheFile);
            task.fetchTile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tileDidUnload(MaplyTileID tileID) {
        HashMap<MaplyTileID, ConnectionTask> hashMap = this.tasks;
        synchronized (hashMap) {
            ConnectionTask task = this.tasks.get(tileID);
            if (task != null) {
                this.tasks.remove(tileID);
                task.isCanceled = true;
                task.call.cancel();
            }
        }
    }

    public void setCacheDir(File inCacheDir) {
        this.cacheDir = inCacheDir;
    }

    private class ConnectionTask
    implements Callback {
        MapboxVectorTileSource tileSource = null;
        QuadPagingLayer layer = null;
        MaplyTileID tileID = null;
        URL url = null;
        String locFile = null;
        public Call call;
        byte[] tileData = null;
        File cacheFile = null;
        boolean isCanceled = false;

        ConnectionTask(QuadPagingLayer inLayer, MapboxVectorTileSource inTileSource, MaplyTileID inTileID, URL inURL, String inFile) {
            this.layer = inLayer;
            this.tileSource = inTileSource;
            this.tileID = inTileID;
            this.locFile = inFile;
            this.url = inURL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fetchTile() {
            block11: {
                try {
                    if (this.locFile != null) {
                        this.cacheFile = new File(this.locFile);
                        if (this.cacheFile.exists()) {
                            this.tileData = FileUtils.readFileToByteArray((File)this.cacheFile);
                            if (MapboxVectorTileSource.this.debugOutput) {
                                if (this.tileData != null) {
                                    Log.d((String)"Maply", (String)("Read cached file for tile " + this.tileID.level + ": (" + this.tileID.x + "," + this.tileID.y + ")"));
                                } else {
                                    Log.d((String)"Maply", (String)("Read cached file for tile " + this.tileID.level + ": (" + this.tileID.x + "," + this.tileID.y + ")"));
                                }
                            }
                        }
                    }
                    if (this.tileData != null) {
                        this.reportTile();
                        return;
                    }
                    Request request = new Request.Builder().url(this.url).build();
                    this.call = MapboxVectorTileSource.this.client.newCall(request);
                    HashMap<MaplyTileID, ConnectionTask> hashMap = MapboxVectorTileSource.this.tasks;
                    synchronized (hashMap) {
                        MapboxVectorTileSource.this.tasks.put(this.tileID, this);
                    }
                    this.call.enqueue((Callback)this);
                }
                catch (Exception e) {
                    if (!MapboxVectorTileSource.this.debugOutput) break block11;
                    Log.e((String)"Maply", (String)("Exception while trying to fetch the tile: " + e.toString()));
                }
            }
        }

        public void onFailure(Request request, IOException e) {
            if (!this.isCanceled) {
                Log.e((String)"Maply", (String)("Failed to fetch remote tile " + this.tileID.level + ": (" + this.tileID.x + "," + this.tileID.y + ")"));
            }
        }

        public void onResponse(Response response) {
            if (this.isCanceled) {
                return;
            }
            try {
                this.tileData = response.body().bytes();
                if (MapboxVectorTileSource.this.processData(this.layer, this.tileID, this.tileData) && this.cacheFile != null && this.tileData != null) {
                    FileOutputStream fOut = new FileOutputStream(this.cacheFile);
                    ((OutputStream)fOut).write(this.tileData);
                    ((OutputStream)fOut).close();
                }
                if (MapboxVectorTileSource.this.debugOutput) {
                    if (this.tileData != null) {
                        Log.d((String)"Maply", (String)("Fetched remote file for tile " + this.tileID.level + ": (" + this.tileID.x + "," + this.tileID.y + ")"));
                    } else {
                        Log.d((String)"Maply", (String)("Fetched remote tile " + this.tileID.level + ": (" + this.tileID.x + "," + this.tileID.y + ")" + " but did not decode."));
                        Log.e((String)"Maply", (String)("Response for failed image decode: " + response.toString()));
                    }
                }
            }
            catch (Exception e) {
                Log.e((String)"Maply", (String)("Fetched remote file for tile " + this.tileID.level + ": (" + this.tileID.x + "," + this.tileID.y + ")" + " because: " + e.toString()));
            }
            this.reportTile();
        }

        protected void reportTile() {
            if (this.tileData == null) {
                this.layer.tileFailedToLoad(this.tileID);
            } else {
                this.layer.tileDidLoad(this.tileID);
            }
        }

        protected void cancel() {
            this.isCanceled = true;
            if (this.call != null) {
                this.call.cancel();
            }
        }
    }
}

