/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import com.mousebird.maply.CoordSystemDisplayAdapter;
import com.mousebird.maply.MapController;
import com.mousebird.maply.MapViewState;
import com.mousebird.maply.MaplyRenderer;
import com.mousebird.maply.Matrix4d;
import com.mousebird.maply.Point2d;
import com.mousebird.maply.Point3d;
import com.mousebird.maply.View;
import com.mousebird.maply.ViewState;

public class MapView
extends View {
    MapController control = null;
    double lastUpdated = 0.0;
    AnimationDelegate animationDelegate = null;

    private MapView() {
    }

    MapView(MapController inControl, CoordSystemDisplayAdapter inCoordAdapter) {
        this.control = inControl;
        this.coordAdapter = inCoordAdapter;
        this.initialise(this.coordAdapter);
    }

    @Override
    protected MapView clone() {
        MapView that = new MapView(this.control, this.coordAdapter);
        this.nativeClone(that);
        return that;
    }

    public void finalize() {
        this.dispose();
    }

    @Override
    public ViewState makeViewState(MaplyRenderer renderer) {
        return new MapViewState(this, renderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAnimationDelegate(AnimationDelegate delegate) {
        MapView mapView = this;
        synchronized (mapView) {
            this.animationDelegate = delegate;
            this.control.handleStartMoving(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAnimation() {
        MapView mapView = this;
        synchronized (mapView) {
            this.animationDelegate = null;
        }
        this.control.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                MapView.this.control.handleStopMoving(false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void animate() {
        boolean doRunViewUpdates = false;
        MapView mapView = this;
        synchronized (mapView) {
            if (this.animationDelegate != null) {
                this.animationDelegate.updateView(this);
                doRunViewUpdates = true;
            }
        }
        if (doRunViewUpdates) {
            this.runViewUpdates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAnimating() {
        MapView mapView = this;
        synchronized (mapView) {
            if (this.animationDelegate != null) {
                return true;
            }
        }
        return false;
    }

    void setLoc(Point3d loc) {
        double z = loc.getZ();
        z = Math.min(this.maxHeightAboveSurface(), z);
        z = Math.max(this.minHeightAboveSurface(), z);
        this.setLoc(loc.getX(), loc.getY(), z);
        this.runViewUpdates();
    }

    native Point3d pointOnPlaneFromScreen(Point2d var1, Matrix4d var2, Point2d var3, boolean var4);

    native Point2d pointOnScreenFromPlane(Point3d var1, Matrix4d var2, Point2d var3);

    native double minHeightAboveSurface();

    native double maxHeightAboveSurface();

    private native void setLoc(double var1, double var3, double var5);

    public native Point3d getLoc();

    native void setRot(double var1);

    native double getRot();

    private static native void nativeInit();

    native void initialise(CoordSystemDisplayAdapter var1);

    protected native void nativeClone(MapView var1);

    native void dispose();

    static {
        MapView.nativeInit();
    }

    static interface AnimationDelegate {
        public void updateView(MapView var1);
    }
}

