/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import com.mousebird.maply.LabelInfo;
import com.mousebird.maply.Point2d;
import com.mousebird.maply.ScreenLabel;

class InternalLabel {
    private long nativeHandle;

    InternalLabel() {
        this.initialise();
    }

    InternalLabel(ScreenLabel label, LabelInfo info) {
        this.initialise();
        this.setLoc(label.loc);
        this.setRotation(label.rotation);
        if (label.text != null && !label.text.isEmpty()) {
            int codePoint;
            int len = label.text.length();
            int[] codePoints = new int[len];
            int which = 0;
            for (int offset = 0; offset < len; offset += Character.charCount(codePoint)) {
                codePoint = label.text.codePointAt(offset);
                codePoints[which++] = codePoint;
            }
            this.setText(codePoints, which);
        }
        if (label.offset != null) {
            this.setOffset(label.offset);
        }
        this.setLayoutImportance(label.layoutImportance);
        if (label.selectable) {
            this.setSelectable(true);
            this.setSelectID(label.ident);
        }
    }

    public native void setSelectID(long var1);

    public native void setLoc(Point2d var1);

    public native void setRotation(double var1);

    public native void setText(int[] var1, int var2);

    public native void setOffset(Point2d var1);

    public native void setSelectable(boolean var1);

    public native void setLayoutImportance(float var1);

    private static native void nativeInit();

    native void initialise();

    native void dispose();

    static {
        InternalLabel.nativeInit();
    }
}

