/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import com.mousebird.maply.GlobeView;
import com.mousebird.maply.MaplyRenderer;
import com.mousebird.maply.Quaternion;

public class GlobeAnimateRotation
implements GlobeView.AnimationDelegate {
    GlobeView globeView = null;
    MaplyRenderer renderer = null;
    Quaternion startQuat = null;
    Quaternion endQuat = null;
    double startHeight;
    double endHeight;
    double startTime;
    double animTime;

    public GlobeAnimateRotation(GlobeView inGlobeView, MaplyRenderer inRender, Quaternion newQuat, double newHeight, double animLen) {
        this.globeView = inGlobeView;
        this.renderer = inRender;
        this.startTime = (double)System.currentTimeMillis() / 1000.0;
        this.animTime = animLen;
        this.startQuat = this.globeView.getRotQuat();
        this.startHeight = this.globeView.getHeight();
        this.endHeight = newHeight;
        this.endQuat = newQuat;
    }

    @Override
    public void updateView(GlobeView view) {
        if (this.startTime == 0.0) {
            return;
        }
        double sinceStart = (double)System.currentTimeMillis() / 1000.0 - this.startTime;
        if (sinceStart > this.animTime) {
            sinceStart = this.animTime;
            this.startTime = 0.0;
            view.cancelAnimation();
        }
        double t = sinceStart / this.animTime;
        Quaternion newQuat = this.startQuat.slerp(this.endQuat, t);
        double height = (this.endHeight - this.startHeight) * t + this.startHeight;
        this.globeView.setRotQuat(newQuat);
        this.globeView.setHeight(height);
    }
}

