/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import com.mousebird.maply.AngleAxis;
import com.mousebird.maply.GlobeView;
import com.mousebird.maply.MaplyRenderer;
import com.mousebird.maply.Point3d;
import com.mousebird.maply.Quaternion;

public class GlobeAnimateMomentum
implements GlobeView.AnimationDelegate {
    GlobeView globeView = null;
    MaplyRenderer renderer = null;
    Point3d axis = null;
    boolean northUp;
    Quaternion startQuat = null;
    double velocity;
    double acceleration;
    double startTime;
    double maxTime;

    public GlobeAnimateMomentum(GlobeView inGlobeView, MaplyRenderer inRender, double inVelocity, double inAcceleration, Point3d inAxis, boolean inNorthUp) {
        this.globeView = inGlobeView;
        this.renderer = inRender;
        this.velocity = inVelocity;
        this.acceleration = inAcceleration;
        this.axis = inAxis;
        this.northUp = inNorthUp;
        this.startTime = (double)System.currentTimeMillis() / 1000.0;
        this.startQuat = this.globeView.getRotQuat();
        if (this.acceleration != 0.0) {
            this.maxTime = -this.velocity / this.acceleration;
            if (this.maxTime < 0.0) {
                this.maxTime = 0.0;
            }
            if (this.maxTime == 0.0) {
                this.startTime = 0.0;
            }
        } else {
            this.maxTime = Double.MAX_VALUE;
        }
    }

    Quaternion rotForTime(double sinceStart) {
        Point3d northPole;
        double totalAng = (this.velocity + 0.5 * this.acceleration * sinceStart) * sinceStart;
        AngleAxis angAxis = new AngleAxis(totalAng, this.axis);
        Quaternion newRotQuat = this.startQuat.multiply(angAxis);
        if (this.northUp && (northPole = newRotQuat.multiply(new Point3d(0.0, 0.0, 1.0)).normalized()).getY() != 0.0) {
            Point3d newUp = this.globeView.prospectiveUp(newRotQuat);
            double ang = Math.atan(northPole.getX() / northPole.getY());
            if (northPole.getY() < 0.0) {
                ang += Math.PI;
            }
            AngleAxis upRot = new AngleAxis(ang, newUp);
            newRotQuat = newRotQuat.multiply(upRot);
        }
        return newRotQuat;
    }

    @Override
    public void updateView(GlobeView view) {
        if (this.startTime == 0.0) {
            return;
        }
        double sinceStart = (double)System.currentTimeMillis() / 1000.0 - this.startTime;
        if (sinceStart > this.maxTime) {
            sinceStart = this.maxTime;
            this.startTime = 0.0;
            view.cancelAnimation();
        }
        Quaternion newQuat = this.rotForTime(sinceStart);
        this.globeView.setRotQuat(newQuat);
    }
}

