/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.graphics.Bitmap;
import com.mousebird.maply.ChangeSet;
import com.mousebird.maply.MaplyBaseController;
import com.mousebird.maply.Scene;
import com.mousebird.maply.Texture;
import java.util.TreeSet;

class TextureManager {
    TreeSet<TextureWrapper> textures = new TreeSet();

    TextureManager() {
    }

    long addTexture(Bitmap theBitmap, Scene scene, ChangeSet changes) {
        TextureWrapper testWrapper = new TextureWrapper(theBitmap);
        if (this.textures.contains(testWrapper)) {
            TextureWrapper existingBitmap = this.textures.floor(testWrapper);
            ++existingBitmap.refs;
            return existingBitmap.texID;
        }
        Texture texture = new Texture();
        if (!texture.setBitmap(theBitmap)) {
            return MaplyBaseController.EmptyIdentity;
        }
        testWrapper.refs = 1;
        testWrapper.texID = texture.getID();
        changes.addTexture(texture, scene);
        this.textures.add(testWrapper);
        return testWrapper.texID;
    }

    void removeTexture(long texID, ChangeSet changes) {
        for (TextureWrapper texWrap : this.textures) {
            if (texWrap.texID != texID) continue;
            --texWrap.refs;
            if (texWrap.refs <= 0) {
                changes.removeTexture(texWrap.texID);
                this.textures.remove(texWrap);
            }
            return;
        }
    }

    class TextureWrapper
    implements Comparable<TextureWrapper> {
        Bitmap bitmap = null;
        long texID = 0L;
        int refs = 0;

        TextureWrapper(Bitmap inBitmap) {
            this.bitmap = inBitmap;
        }

        @Override
        public int compareTo(TextureWrapper that) {
            int hash2;
            int hash1 = this.bitmap.hashCode();
            if (hash1 == (hash2 = that.bitmap.hashCode())) {
                return 0;
            }
            if (hash1 < hash2) {
                return -1;
            }
            return 1;
        }
    }
}

