/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.mousebird.maply.MaplyImageTile;
import com.mousebird.maply.MaplyTileID;
import com.mousebird.maply.QuadImageTileLayer;
import com.mousebird.maply.QuadImageTileLayerInterface;

public class TestImageSource
implements QuadImageTileLayer.TileSource {
    int minZoom = 0;
    int maxZoom = 16;
    int pixelsPerSide = 256;
    public int alpha = 255;
    Looper mainLooper = null;
    static int MaxDebugColors = 10;
    static int[] debugColors = new int[]{8814893, 6207945, 2784830, 5186927, 14195934, 7813928, 0x333D99, 8793426, 12764755, 12081213};

    public TestImageSource(Looper inMainLooper, int inMinZoom, int inMaxZoom) {
        this.mainLooper = inMainLooper;
        this.minZoom = inMinZoom;
        this.maxZoom = inMaxZoom;
    }

    @Override
    public int minZoom() {
        return this.minZoom;
    }

    @Override
    public int maxZoom() {
        return this.maxZoom;
    }

    @Override
    public int pixelsPerSide() {
        return this.pixelsPerSide;
    }

    @Override
    public void startFetchForTile(final QuadImageTileLayerInterface layer, final MaplyTileID tileID, final int frame) {
        Handler handler = new Handler(this.mainLooper);
        handler.post(new Runnable(){

            @Override
            public void run() {
                String text = null;
                text = frame == -1 ? tileID.toString() : tileID.toString() + " " + frame;
                Paint p = new Paint();
                p.setTextSize(24.0f);
                p.setColor(-1);
                Rect bounds = new Rect();
                p.getTextBounds(text, 0, text.length(), bounds);
                int textLen = bounds.right;
                int sizeX = TestImageSource.this.pixelsPerSide;
                int sizeY = TestImageSource.this.pixelsPerSide;
                Bitmap bitmap = Bitmap.createBitmap((int)sizeX, (int)sizeY, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas c = new Canvas(bitmap);
                Paint p2 = new Paint();
                p2.setStyle(Paint.Style.FILL);
                int hexColor = debugColors[tileID.level % MaxDebugColors];
                int red = hexColor >> 16 & 0xFF;
                int green = hexColor >> 8 & 0xFF;
                int blue = hexColor >> 0 & 0xFF;
                p2.setARGB(TestImageSource.this.alpha, red, green, blue);
                c.drawRect(0.0f, 0.0f, (float)sizeX, (float)sizeY, p2);
                Paint p3 = new Paint();
                p3.setStyle(Paint.Style.STROKE);
                p3.setColor(-1);
                c.drawRect(2.0f, 2.0f, (float)(sizeX - 2), (float)(sizeY - 2), p3);
                c.drawText(text, (float)(sizeX - textLen) / 2.0f, (float)sizeY / 2.0f, p);
                Log.d((String)"Maply", (String)("Loaded fake tile " + tileID.level + ": (" + tileID.x + "," + tileID.y + ")" + " " + frame));
                layer.loadedTile(tileID, frame, new MaplyImageTile(bitmap));
            }
        });
    }
}

