/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.opengl.GLSurfaceView;
import com.mousebird.maply.GLTextureView;
import com.mousebird.maply.MaplyBaseController;
import com.mousebird.maply.MaplyRenderer;
import com.mousebird.maply.Scene;
import com.mousebird.maply.View;
import java.util.concurrent.Semaphore;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

class RendererWrapper
implements GLSurfaceView.Renderer,
GLTextureView.Renderer {
    boolean valid = true;
    public MaplyRenderer maplyRender = null;
    public Scene scene = null;
    public View view = null;
    public MaplyBaseController maplyControl = null;
    public Thread renderThread = null;
    int frameCount = 0;
    Semaphore renderLock = new Semaphore(1, true);
    boolean firstFrame = true;

    public RendererWrapper(MaplyBaseController inMapControl) {
        this.maplyControl = inMapControl;
    }

    public void finalize() {
    }

    public MaplyRenderer getMaplyRender() {
        return this.maplyRender;
    }

    @Override
    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        this.maplyRender = new MaplyRenderer();
        this.maplyRender.setScene(this.scene);
        this.maplyRender.setView(this.view);
        this.maplyRender.setConfig(config);
        this.renderThread = Thread.currentThread();
        this.maplyControl.surfaceCreated(this);
    }

    public void shutdown() {
        this.maplyRender.dispose();
        this.maplyRender = null;
        this.scene = null;
        this.view = null;
        this.maplyControl = null;
        this.renderThread = null;
    }

    @Override
    public void onSurfaceChanged(GL10 gl, int width, int height) {
        try {
            this.renderLock.acquire();
        }
        catch (Exception e) {
            return;
        }
        if (this.valid) {
            this.maplyRender.surfaceChanged(width, height);
            this.maplyRender.doRender();
        }
        this.renderLock.release();
    }

    @Override
    public void onDrawFrame(GL10 gl) {
        if (this.firstFrame) {
            this.firstFrame = false;
            this.maplyControl.getContentView().post(new Runnable(){

                @Override
                public void run() {
                    if (RendererWrapper.this.maplyControl != null) {
                        RendererWrapper.this.maplyControl.getContentView().setBackground(null);
                    }
                }
            });
        }
        try {
            this.renderLock.acquire();
        }
        catch (Exception e) {
            return;
        }
        if (this.valid) {
            this.maplyRender.doRender();
        }
        this.renderLock.release();
    }

    public void stopRendering() {
        try {
            this.renderLock.acquire();
        }
        catch (Exception e) {
            return;
        }
        this.valid = false;
        this.renderLock.release();
    }
}

