/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Handler;
import android.os.Looper;
import com.mousebird.maply.ActiveObject;
import com.mousebird.maply.ChangeSet;
import com.mousebird.maply.CoordSystem;
import com.mousebird.maply.Layer;
import com.mousebird.maply.LayerThread;
import com.mousebird.maply.MaplyBaseController;
import com.mousebird.maply.MaplyImageTile;
import com.mousebird.maply.MaplyRenderer;
import com.mousebird.maply.MaplyTileID;
import com.mousebird.maply.Point2d;
import com.mousebird.maply.QuadImageTileLayerInterface;
import com.mousebird.maply.Scene;
import com.mousebird.maply.ViewState;

public class QuadImageTileLayer
extends Layer
implements LayerThread.ViewWatcherInterface,
QuadImageTileLayerInterface {
    boolean valid = false;
    public MaplyBaseController maplyControl = null;
    public CoordSystem coordSys = null;
    TileSource tileSource = null;
    boolean flipY = true;
    boolean currentImageSetBeforeStart = false;
    float currentImageValue;
    int[] currentPriorities = null;
    Handler evalStepHandle = null;
    Runnable evalStepRun = null;
    boolean startEnable = true;
    int lastPriority = -1;
    ImageUpdater imageUpdater = null;
    boolean animationWrap = false;
    private long nativeHandle;

    private QuadImageTileLayer() {
    }

    public QuadImageTileLayer(MaplyBaseController inMaplyControl, CoordSystem inCoordSys, TileSource inTileSource) {
        this.maplyControl = inMaplyControl;
        this.coordSys = inCoordSys;
        this.tileSource = inTileSource;
        ChangeSet changes = new ChangeSet();
        this.initialise(this.coordSys, changes);
        LayerThread layerThread = this.maplyControl.getLayerThread();
        if (layerThread != null) {
            layerThread.addChanges(changes);
        }
        this.setSimultaneousFetches(8);
        this.setDrawPriority(100);
    }

    public void finalize() {
        this.dispose();
    }

    @Override
    public float getMinTime() {
        return 0.1f;
    }

    @Override
    public float getMaxLagTime() {
        return 4.0f;
    }

    @Override
    public void startLayer(LayerThread layerThread) {
        super.startLayer(layerThread);
        layerThread.addWatcher(this);
        Point2d ll = new Point2d(this.coordSys.ll.getX(), this.coordSys.ll.getY());
        Point2d ur = new Point2d(this.coordSys.ur.getX(), this.coordSys.ur.getY());
        this.nativeStartLayer(layerThread.scene, layerThread.renderer, ll, ur, this.tileSource.minZoom(), this.tileSource.maxZoom(), this.tileSource.pixelsPerSide());
        if (this.currentImageSetBeforeStart) {
            ChangeSet changes = new ChangeSet();
            this.setCurrentImage(this.currentImageValue, changes);
            this.setFrameLoadingPriority(this.currentPriorities, changes);
            if (layerThread.scene != null) {
                changes.process(layerThread.scene);
            }
        }
        this.scheduleEvalStep();
        this.valid = true;
        if (!this.startEnable) {
            this.setEnable(this.startEnable);
        }
    }

    @Override
    public void shutdown() {
        this.valid = false;
        if (this.layerThread != null) {
            this.layerThread.removeWatcher(this);
        }
        this.cancelEvalStep();
        ChangeSet changes = new ChangeSet();
        this.nativeShutdown(changes);
        if (this.layerThread != null && this.layerThread.scene != null) {
            changes.process(this.layerThread.scene);
        }
        super.shutdown();
        this.dispose();
    }

    @Override
    public void viewUpdated(ViewState viewState) {
        if (!this.valid) {
            return;
        }
        this.nativeViewUpdate(viewState);
        this.scheduleEvalStep();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelEvalStep() {
        if (!this.valid) {
            return;
        }
        QuadImageTileLayer quadImageTileLayer = this;
        synchronized (quadImageTileLayer) {
            if (this.evalStepHandle != null) {
                this.evalStepHandle.removeCallbacks(this.evalStepRun);
                this.evalStepHandle = null;
                this.evalStepRun = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleEvalStep() {
        if (!this.valid) {
            return;
        }
        QuadImageTileLayer quadImageTileLayer = this;
        synchronized (quadImageTileLayer) {
            if (this.evalStepHandle == null) {
                this.evalStepRun = new Runnable(){

                    @Override
                    public void run() {
                        if (QuadImageTileLayer.this.valid) {
                            QuadImageTileLayer.this.evalStep();
                        }
                    }
                };
                this.evalStepHandle = this.layerThread.addTask(this.evalStepRun, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void evalStep() {
        if (!this.valid) {
            return;
        }
        QuadImageTileLayer quadImageTileLayer = this;
        synchronized (quadImageTileLayer) {
            this.evalStepHandle = null;
            this.evalStepRun = null;
        }
        ChangeSet changes = new ChangeSet();
        boolean didSomething = this.nativeEvalStep(changes);
        this.layerThread.addChanges(changes);
        if (didSomething) {
            this.scheduleEvalStep();
        }
    }

    public void refresh() {
        if (!this.valid) {
            return;
        }
        if (Looper.myLooper() != this.layerThread.getLooper()) {
            Handler handle = new Handler();
            handle.post(new Runnable(){

                @Override
                public void run() {
                    QuadImageTileLayer.this.refresh();
                }
            });
            return;
        }
        ChangeSet changes = new ChangeSet();
        boolean doEvalStep = this.nativeRefresh(changes);
        this.layerThread.addChanges(changes);
        if (doEvalStep) {
            this.scheduleEvalStep();
        }
    }

    void startFetch(int level, int x, int y, final int frame) {
        if (!this.valid) {
            return;
        }
        if (!this.flipY) {
            y = (1 << level) - y - 1;
        }
        final MaplyTileID tileID = new MaplyTileID(x, y, level);
        if (level < this.tileSource.minZoom()) {
            this.layerThread.addTask(new Runnable(){

                @Override
                public void run() {
                    QuadImageTileLayer.this.loadedTile(tileID, frame, null);
                }
            }, true);
        } else {
            this.tileSource.startFetchForTile(this, tileID, frame);
        }
    }

    @Override
    public void loadedTile(final MaplyTileID tileID, final int frame, final MaplyImageTile imageTile) {
        if (!this.valid) {
            return;
        }
        int y = tileID.y;
        if (!this.flipY) {
            y = (1 << tileID.level) - tileID.y - 1;
        }
        if (Looper.myLooper() != this.layerThread.getLooper()) {
            this.layerThread.addTask(new Runnable(){

                @Override
                public void run() {
                    QuadImageTileLayer.this.loadedTile(tileID, frame, imageTile);
                }
            });
            return;
        }
        ChangeSet changes = new ChangeSet();
        if (imageTile != null) {
            if (imageTile.bitmaps != null) {
                this.nativeTileDidLoad(tileID.x, y, tileID.level, -1, imageTile.bitmaps, changes);
            } else {
                this.nativeTileDidLoad(tileID.x, y, tileID.level, frame, imageTile.bitmap, changes);
            }
        } else {
            this.nativeTileDidNotLoad(tileID.x, y, tileID.level, frame, changes);
        }
        this.layerThread.addChanges(changes);
    }

    @Override
    public LayerThread getLayerThread() {
        return this.layerThread;
    }

    public void setEnable(boolean enable) {
        if (this.layerThread == null) {
            return;
        }
        ChangeSet changes = new ChangeSet();
        this.setEnable(enable, changes);
        this.layerThread.addChanges(changes);
        this.startEnable = enable;
    }

    native void setEnable(boolean var1, ChangeSet var2);

    public native void setDrawPriority(int var1);

    public native void setImageDepth(int var1);

    public native int getImageDepth();

    public native float getCurrentImage();

    public void setCurrentImage(float current, boolean updatePriorities) {
        int curPriority;
        int[] prior = null;
        if (updatePriorities && (curPriority = (int)current) != this.lastPriority) {
            int start;
            prior = new int[this.getImageDepth()];
            prior[0] = start = curPriority;
            int where = 1;
            for (int ii = 1; ii < prior.length; ++ii) {
                int up = start + ii;
                int down = start - ii;
                if (up < prior.length) {
                    prior[where++] = up;
                }
                if (down < 0) continue;
                prior[where++] = down;
            }
            this.lastPriority = curPriority;
        }
        if (this.layerThread != null) {
            if (prior != null) {
                final int[] priorFinal = prior;
                this.layerThread.addTask(new Runnable(){

                    @Override
                    public void run() {
                        ChangeSet changes = new ChangeSet();
                        QuadImageTileLayer.this.setFrameLoadingPriority(priorFinal, changes);
                        QuadImageTileLayer.this.layerThread.addChanges(changes);
                    }
                });
            }
            ChangeSet changes = new ChangeSet();
            this.setCurrentImage(current, changes);
            if (this.layerThread.scene != null) {
                changes.process(this.layerThread.scene);
            }
        } else {
            this.currentImageSetBeforeStart = true;
            this.currentImageValue = current;
            this.currentPriorities = prior;
        }
        this.maplyControl.requestRender();
    }

    native void setCurrentImage(float var1, ChangeSet var2);

    public native void setMaxCurrentImage(float var1);

    public void setAnimationPeriod(float period) {
        if (this.maplyControl == null) {
            return;
        }
        if (this.imageUpdater != null) {
            this.maplyControl.removeActiveObject(this.imageUpdater);
            this.imageUpdater = null;
        }
        if ((double)period > 0.0) {
            this.imageUpdater = new ImageUpdater(this, period);
            this.maplyControl.addActiveObject(this.imageUpdater);
        }
    }

    public void setAnimationWrap(boolean wrap) {
        this.animationWrap = wrap;
    }

    public native void setAllowFrameLoading(boolean var1);

    public FrameStatus getFrameStatus() {
        if (this.getImageDepth() <= 1) {
            return null;
        }
        FrameStatus status = new FrameStatus(this.getImageDepth());
        status.currentFrame = this.getFrameStatusNative(status.complete, status.tilesLoaded);
        if (status.currentFrame == -1) {
            return null;
        }
        return status;
    }

    private native int getFrameStatusNative(boolean[] var1, int[] var2);

    public void setFrameLoadingPriority(int[] priorites) {
        ChangeSet changes = new ChangeSet();
        this.setFrameLoadingPriority(priorites, changes);
        this.layerThread.addChanges(changes);
        this.scheduleEvalStep();
    }

    native void setFrameLoadingPriority(int[] var1, ChangeSet var2);

    public void setColor(int color) {
        this.setColor((float)Color.red((int)color) / 255.0f, (float)Color.green((int)color) / 255.0f, (float)Color.blue((int)color) / 255.0f, (float)Color.alpha((int)color) / 255.0f);
    }

    public void setColor(float r, float g, float b, float a) {
        ChangeSet changes = new ChangeSet();
        this.setColor(r, g, b, a, changes);
        if (this.layerThread != null) {
            this.layerThread.addChanges(changes);
        }
    }

    native void setColor(float var1, float var2, float var3, float var4, ChangeSet var5);

    public native void setMaxTiles(int var1);

    public native void setImportanceScale(float var1);

    public native void setTextureAtlasSize(int var1);

    public void setImageFormat(ImageFormat format) {
        this.setImageFormat(format.ordinal());
    }

    native void setImageFormat(int var1);

    public native int getBorderTexel();

    public native void setBorderTexel(int var1);

    public void setFlipY(boolean inFlipY) {
        this.flipY = inFlipY;
    }

    public native void setMultiLevelLoads(int[] var1);

    public native int getTargetZoomLevel();

    public native void setShaderName(String var1);

    public void reload() {
        ChangeSet changes = new ChangeSet();
        this.reload(changes);
        this.layerThread.addChanges(changes);
    }

    native void reload(ChangeSet var1);

    public native void setSimultaneousFetches(int var1);

    public native void setUseTargetZoomLevel(boolean var1);

    public native void setSingleLevelLoading(boolean var1);

    public native void setHandleEdges(boolean var1);

    public native void setCoverPoles(boolean var1);

    public native void setVisibility(double var1, double var3);

    native void nativeShutdown(ChangeSet var1);

    private static native void nativeInit();

    native void initialise(CoordSystem var1, ChangeSet var2);

    native void dispose();

    native void nativeStartLayer(Scene var1, MaplyRenderer var2, Point2d var3, Point2d var4, int var5, int var6, int var7);

    native void nativeViewUpdate(ViewState var1);

    native boolean nativeEvalStep(ChangeSet var1);

    native boolean nativeRefresh(ChangeSet var1);

    native void nativeTileDidLoad(int var1, int var2, int var3, int var4, Bitmap var5, ChangeSet var6);

    native void nativeTileDidLoad(int var1, int var2, int var3, int var4, Bitmap[] var5, ChangeSet var6);

    native void nativeTileDidNotLoad(int var1, int var2, int var3, int var4, ChangeSet var5);

    static {
        QuadImageTileLayer.nativeInit();
    }

    public static enum ImageFormat {
        MaplyImageIntRGBA,
        MaplyImageUShort565,
        MaplyImageUShort4444,
        MaplyImageUShort5551,
        MaplyImageUByteRed,
        MaplyImageUByteGreen,
        MaplyImageUByteBlue,
        MaplyImageUByteAlpha,
        MaplyImageUByteRGB,
        MaplyImageETC2RGB8,
        MaplyImageETC2RGBA8,
        MaplyImageETC2RGBPA8,
        MaplyImageEACR11,
        MaplyImageEACR11S,
        MaplyImageEACRG11,
        MaplyImageEACRG11S,
        MaplyImage4Layer8Bit;

    }

    public static class FrameStatus {
        public int currentFrame;
        public boolean[] complete;
        public int[] tilesLoaded;

        FrameStatus(int depth) {
            this.complete = new boolean[depth];
            this.tilesLoaded = new int[depth];
        }

        public boolean equals(Object thatObj) {
            int ii;
            if (thatObj == null) {
                return false;
            }
            FrameStatus that = (FrameStatus)thatObj;
            if (this.currentFrame != that.currentFrame) {
                return false;
            }
            if (this.complete.length != that.complete.length) {
                return false;
            }
            for (ii = 0; ii < this.complete.length; ++ii) {
                if (this.complete[ii] == that.complete[ii]) continue;
                return false;
            }
            if (this.tilesLoaded.length != that.tilesLoaded.length) {
                return false;
            }
            for (ii = 0; ii < this.tilesLoaded.length; ++ii) {
                if (this.tilesLoaded[ii] == that.tilesLoaded[ii]) continue;
                return false;
            }
            return true;
        }
    }

    class ImageUpdater
    implements ActiveObject {
        QuadImageTileLayer imageLayer = null;
        int imageDepth = 0;
        double startTime;
        double period;

        ImageUpdater(QuadImageTileLayer inImageLayer, double inPeriod) {
            this.imageLayer = inImageLayer;
            this.imageDepth = this.imageLayer.getImageDepth();
            this.period = inPeriod;
            this.startTime = (double)System.currentTimeMillis() / 1000.0;
            if (this.imageLayer.getImageDepth() > 1) {
                this.startTime -= (double)(this.imageLayer.getCurrentImage() / (float)this.imageLayer.getImageDepth()) * this.period;
            }
        }

        @Override
        public void activeUpdate() {
            double now = (double)System.currentTimeMillis() / 1000.0;
            double where = (now - this.startTime) % this.period / this.period * (double)(this.imageLayer.getImageDepth() - 1);
            ChangeSet changes = new ChangeSet();
            QuadImageTileLayer.this.setCurrentImage((float)where, changes);
            QuadImageTileLayer.this.maplyControl.scene.addChanges(changes);
        }

        @Override
        public boolean hasChanges() {
            return this.period != 0.0 && this.imageDepth != 0;
        }
    }

    public static interface TileSource {
        public int minZoom();

        public int maxZoom();

        public int pixelsPerSide();

        public void startFetchForTile(QuadImageTileLayerInterface var1, MaplyTileID var2, int var3);
    }
}

