/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.opengl.GLSurfaceView;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Choreographer;
import com.mousebird.maply.GLTextureView;
import com.mousebird.maply.MaplyBaseController;
import com.mousebird.maply.MaplyRenderer;

public class MetroThread
extends HandlerThread
implements Choreographer.FrameCallback {
    Choreographer ch;
    MaplyBaseController control;
    int frameInterval;
    MaplyRenderer renderer = null;
    int frameCount = 0;
    public boolean requestRender = true;

    public MetroThread(String name, MaplyBaseController inControl, int inFrameInterval) {
        super(name);
        this.control = inControl;
        this.frameInterval = inFrameInterval;
        this.start();
        final MetroThread metThread = this;
        Handler handler = new Handler(this.getLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)metThread);
            }
        });
    }

    public void shutdown() {
        try {
            this.quit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setFrameRate(int newRate) {
        this.frameInterval = newRate;
    }

    public void setRenderer(MaplyRenderer inRenderer) {
        this.renderer = inRenderer;
    }

    public void requestRender() {
        this.requestRender = true;
    }

    public void doFrame(long frameTimeNanos) {
        if (this.control.baseView != null && this.frameCount % this.frameInterval == 0) {
            if (this.requestRender || this.renderer != null && (this.renderer.hasChanges() || this.renderer.activeObjectsHaveChanges() || this.renderer.view.isAnimating())) {
                if (this.control.baseView instanceof GLSurfaceView) {
                    GLSurfaceView glSurfaceView = (GLSurfaceView)this.control.baseView;
                    glSurfaceView.requestRender();
                } else {
                    GLTextureView glTextureView = (GLTextureView)this.control.baseView;
                    glTextureView.requestRender();
                }
            }
            this.requestRender = false;
        }
        Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
        ++this.frameCount;
    }
}

