/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import com.mousebird.maply.Point2d;
import java.util.ArrayList;
import java.util.List;

public class Mbr {
    public Point2d ll = null;
    public Point2d ur = null;

    public Mbr() {
    }

    public Mbr(Point2d inLL, Point2d inUR) {
        this.ll = new Point2d(inLL);
        this.ur = new Point2d(inUR);
    }

    public String toString() {
        return "ll: " + this.ll + " ur: " + this.ur;
    }

    public boolean equals(Object thatObj) {
        Mbr that = (Mbr)thatObj;
        if (this.ll == null || this.ur == null || that.ll == null || that.ur == null) {
            return false;
        }
        boolean testA = this.ll.getX() == that.ll.getX() && this.ll.getY() == that.ll.getY();
        boolean testB = this.ur.getX() == that.ur.getX() && this.ur.getY() == that.ur.getY();
        return testA && testB;
    }

    public void addPoint(Point2d pt) {
        if (this.ll == null) {
            this.ll = new Point2d(pt);
        } else {
            double ll_x = Math.min(pt.getX(), this.ll.getX());
            double ll_y = Math.min(pt.getY(), this.ll.getY());
            this.ll.setValue(ll_x, ll_y);
        }
        if (this.ur == null) {
            this.ur = new Point2d(pt);
        } else {
            double ur_x = Math.max(pt.getX(), this.ur.getX());
            double ur_y = Math.max(pt.getY(), this.ur.getY());
            this.ur.setValue(ur_x, ur_y);
        }
    }

    public Point2d span() {
        return new Point2d(this.ur.getX() - this.ll.getX(), this.ur.getY() - this.ll.getY());
    }

    public Point2d middle() {
        return new Point2d((this.ur.getX() + this.ll.getX()) / 2.0, (this.ur.getY() + this.ll.getY()) / 2.0);
    }

    public void expandByFraction(double bufferZone) {
        Point2d spanViewMbr = this.span();
        this.ll.setValue(this.ll.getX() - spanViewMbr.getX() * bufferZone, this.ll.getY() - spanViewMbr.getY() * bufferZone);
        this.ur.setValue(this.ur.getX() + spanViewMbr.getX() * bufferZone, this.ur.getY() + spanViewMbr.getY() * bufferZone);
    }

    public boolean insideOrOnEdge(Point2d pt) {
        return this.ll.getX() <= pt.getX() && this.ll.getY() <= pt.getY() && pt.getX() <= this.ur.getX() && pt.getY() <= this.ur.getY();
    }

    public boolean overlaps(Mbr that) {
        if (that.insideOrOnEdge(this.ll) || that.insideOrOnEdge(this.ur) || that.insideOrOnEdge(new Point2d(this.ll.getX(), this.ur.getY())) || that.insideOrOnEdge(new Point2d(this.ur.getX(), this.ll.getY())) || this.insideOrOnEdge(that.ll) || this.insideOrOnEdge(that.ur) || this.insideOrOnEdge(new Point2d(that.ll.getX(), that.ur.getY())) || this.insideOrOnEdge(new Point2d(that.ur.getX(), that.ll.getY()))) {
            return true;
        }
        if (that.ll.getX() <= this.ll.getX() && this.ur.getX() <= that.ur.getX() && this.ll.getY() <= that.ll.getY() && that.ur.getY() <= this.ur.getY() || this.ll.getX() <= that.ll.getX() && that.ur.getX() <= this.ur.getX() && that.ll.getY() <= this.ll.getY() && this.ur.getY() <= that.ur.getY()) {
            return true;
        }
        return this.ll.getX() <= that.ll.getX() && that.ur.getX() <= this.ur.getX() && that.ll.getY() <= this.ll.getY() && this.ur.getY() <= that.ur.getY() || that.ll.getX() <= this.ll.getX() && this.ur.getX() <= that.ur.getX() && this.ll.getY() <= that.ll.getY() && that.ur.getY() <= this.ur.getY();
    }

    public List<Point2d> asPoints() {
        ArrayList<Point2d> pts = new ArrayList<Point2d>();
        pts.add(this.ll);
        pts.add(new Point2d(this.ur.getX(), this.ll.getY()));
        pts.add(this.ur);
        pts.add(new Point2d(this.ll.getX(), this.ur.getY()));
        return pts;
    }

    public boolean isValid() {
        return this.ll != null && this.ur != null;
    }
}

