/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import com.mousebird.maply.AttrDictionary;
import com.mousebird.maply.ComponentObject;
import com.mousebird.maply.CoordSystem;
import com.mousebird.maply.LayerThread;
import com.mousebird.maply.MBTiles;
import com.mousebird.maply.MapboxVectorTileParser;
import com.mousebird.maply.MaplyTileID;
import com.mousebird.maply.Mbr;
import com.mousebird.maply.Point2d;
import com.mousebird.maply.QuadPagingLayer;
import com.mousebird.maply.VectorObject;
import com.mousebird.maply.VectorStyle;
import com.mousebird.maply.VectorStyleInterface;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;

public class MapboxVectorTileSource
implements QuadPagingLayer.PagingInterface {
    MBTiles mbTiles = null;
    MapboxVectorTileParser tileParser = null;
    VectorStyleInterface vecStyleFactory = null;
    public CoordSystem coordSys = null;
    static double MAX_EXTENT = 2.0037508342789244E7;

    public MapboxVectorTileSource(MBTiles dataSource, VectorStyleInterface inVecStyleFactor) {
        this.mbTiles = dataSource;
        this.coordSys = this.mbTiles.coordSys;
        this.tileParser = new MapboxVectorTileParser();
        this.vecStyleFactory = inVecStyleFactor;
    }

    @Override
    public int minZoom() {
        return this.mbTiles.minZoom();
    }

    @Override
    public int maxZoom() {
        return this.mbTiles.maxZoom();
    }

    Point2d toMerc(Point2d pt) {
        Point2d newPt = new Point2d();
        newPt.setValue(Math.toDegrees(pt.getX()) * MAX_EXTENT / 180.0, 3189068.5 * Math.log((1.0 + Math.sin(pt.getY())) / (1.0 - Math.sin(pt.getY()))));
        return newPt;
    }

    @Override
    public void startFetchForTile(final QuadPagingLayer layer, final MaplyTileID tileID) {
        LayerThread thread = layer.maplyControl.getWorkingThread();
        thread.addTask(new Runnable(){

            @Override
            public void run() {
                byte[] tileData = MapboxVectorTileSource.this.mbTiles.getDataTile(tileID);
                ArrayList<ComponentObject> tileCompObjs = new ArrayList<ComponentObject>();
                if (tileData != null) {
                    try {
                        int count;
                        ByteArrayInputStream bin = new ByteArrayInputStream(tileData);
                        GZIPInputStream in = new GZIPInputStream(bin);
                        ByteArrayOutputStream bout = new ByteArrayOutputStream(tileData.length * 2);
                        byte[] buffer = new byte[1024];
                        while ((count = in.read(buffer)) != -1) {
                            bout.write(buffer, 0, count);
                        }
                        tileData = bout.toByteArray();
                    }
                    catch (Exception bin) {
                        // empty catch block
                    }
                    Mbr mbr = layer.geoBoundsForTile(tileID);
                    mbr.ll = MapboxVectorTileSource.this.toMerc(mbr.ll);
                    mbr.ur = MapboxVectorTileSource.this.toMerc(mbr.ur);
                    MapboxVectorTileParser.DataReturn dataObjs = MapboxVectorTileSource.this.tileParser.parseData(tileData, mbr);
                    if (MapboxVectorTileSource.this.vecStyleFactory != null) {
                        HashMap<String, ArrayList<VectorObject>> vecObjsPerStyle = new HashMap<String, ArrayList<VectorObject>>();
                        if (dataObjs != null && dataObjs.vectorObjects != null) {
                            for (VectorObject vecObj : dataObjs.vectorObjects) {
                                VectorStyle[] styles;
                                AttrDictionary attrs = vecObj.getAttributes();
                                for (VectorStyle style : styles = MapboxVectorTileSource.this.vecStyleFactory.stylesForFeature(attrs, tileID, attrs.getString("layer_name"), layer.maplyControl)) {
                                    ArrayList<VectorObject> vecObjsForStyle = (ArrayList<VectorObject>)vecObjsPerStyle.get(style.getUuid());
                                    if (vecObjsForStyle == null) {
                                        vecObjsForStyle = new ArrayList<VectorObject>();
                                        vecObjsPerStyle.put(style.getUuid(), vecObjsForStyle);
                                    }
                                    vecObjsForStyle.add(vecObj);
                                }
                            }
                        }
                        for (String uuid : vecObjsPerStyle.keySet()) {
                            ArrayList vecObjs = (ArrayList)vecObjsPerStyle.get(uuid);
                            VectorStyle style = MapboxVectorTileSource.this.vecStyleFactory.styleForUUID(uuid, layer.maplyControl);
                            ComponentObject[] compObjs = style.buildObjects(vecObjs, tileID, layer.maplyControl);
                            if (compObjs == null) continue;
                            for (int ii = 0; ii < compObjs.length; ++ii) {
                                tileCompObjs.add(compObjs[ii]);
                            }
                        }
                    }
                    if (tileCompObjs.size() > 0) {
                        layer.addData(tileCompObjs, tileID);
                    }
                    layer.tileDidLoad(tileID);
                } else {
                    layer.tileDidLoad(tileID);
                }
            }
        });
    }

    @Override
    public void tileDidUnload(MaplyTileID tileID) {
    }
}

