/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.app.Activity;
import android.opengl.GLSurfaceView;
import android.view.Choreographer;
import android.view.MotionEvent;
import android.view.View;
import com.mousebird.maply.CoordSystem;
import com.mousebird.maply.CoordSystemDisplayAdapter;
import com.mousebird.maply.GLTextureView;
import com.mousebird.maply.GeneralDisplayAdapter;
import com.mousebird.maply.MapAnimateTranslate;
import com.mousebird.maply.MapGestureHandler;
import com.mousebird.maply.MapScene;
import com.mousebird.maply.MapView;
import com.mousebird.maply.MaplyBaseController;
import com.mousebird.maply.Matrix4d;
import com.mousebird.maply.Mbr;
import com.mousebird.maply.Point2d;
import com.mousebird.maply.Point3d;
import com.mousebird.maply.SelectedObject;
import com.mousebird.maply.SphericalMercatorCoordSystem;
import java.util.List;

public class MapController
extends MaplyBaseController
implements View.OnTouchListener,
Choreographer.FrameCallback {
    MapView mapView = null;
    MapScene mapScene = null;
    MapGestureHandler gestureHandler = null;
    public GestureDelegate gestureDelegate = null;
    boolean isPanning = false;
    boolean isZooming = false;
    boolean isRotating = false;
    boolean isAnimating = false;
    double lastViewUpdate = 0.0;

    public MapController(Activity mainActivity, Settings settings) {
        super(mainActivity, settings);
        if (settings.coordSys != null) {
            this.InitCoordSys(mainActivity, settings.coordSys, settings.displayCenter, settings.clearColor);
        } else {
            this.Init(mainActivity, settings.clearColor);
        }
    }

    protected void InitCoordSys(Activity mainActivity, CoordSystem coordSys, Point3d displayCenter, int clearColor) {
        Mbr mbr = coordSys.getBounds();
        double scaleFactor = 1.0;
        if (mbr != null && (Math.abs(mbr.ur.getX() - mbr.ll.getX()) > 10.0 || Math.abs(mbr.ur.getY() - mbr.ll.getY()) > 10.0)) {
            scaleFactor = 4.0 / Math.max(mbr.ur.getX() - mbr.ll.getX(), mbr.ur.getY() - mbr.ll.getY());
        }
        Point3d center = displayCenter != null ? displayCenter : new Point3d(0.0, 0.0, 0.0);
        GeneralDisplayAdapter genCoordAdapter = new GeneralDisplayAdapter(coordSys, coordSys.ll, coordSys.ur, center, new Point3d(scaleFactor, scaleFactor, 1.0));
        this.setupTheRest(genCoordAdapter);
        Point3d ll = new Point3d();
        Point3d ur = new Point3d();
        this.coordAdapter.getBounds(ll, ur);
        this.setViewExtents(new Point2d(ll.getX(), ll.getY()), new Point2d(ur.getX(), ur.getY()));
    }

    public MapController(Activity mainActivity) {
        super(mainActivity, null);
        this.Init(mainActivity, 0);
    }

    protected void Init(Activity mainActivity, int clearColor) {
        this.setupTheRest(new CoordSystemDisplayAdapter(new SphericalMercatorCoordSystem()));
        Point3d ll = new Point3d();
        Point3d ur = new Point3d();
        this.coordAdapter.getBounds(ll, ur);
        ll.setValue(3.4028234663852886E38, ll.getY(), ll.getZ());
        ur.setValue(-3.4028234663852886E38, ur.getY(), ur.getZ());
        this.setViewExtents(new Point2d(ll.getX(), ll.getY()), new Point2d(ur.getX(), ur.getY()));
    }

    protected void setupTheRest(CoordSystemDisplayAdapter inCoordAdapter) {
        this.coordAdapter = inCoordAdapter;
        this.mapScene = new MapScene(this.coordAdapter);
        this.scene = this.mapScene;
        this.mapView = new MapView(this, this.coordAdapter);
        this.view = this.mapView;
        super.Init();
        if (this.baseView != null) {
            if (this.baseView instanceof GLSurfaceView) {
                GLSurfaceView glSurfaceView = (GLSurfaceView)this.baseView;
                glSurfaceView.setOnTouchListener((View.OnTouchListener)this);
            } else {
                GLTextureView glTextureView = (GLTextureView)this.baseView;
                glTextureView.setOnTouchListener(this);
            }
            this.gestureHandler = new MapGestureHandler(this, this.baseView);
        }
        this.addPostSurfaceRunnable(new Runnable(){

            @Override
            public void run() {
                MapController.this.clearLights();
            }
        });
    }

    @Override
    public void shutdown() {
        Choreographer c = Choreographer.getInstance();
        if (c != null) {
            c.removeFrameCallback((Choreographer.FrameCallback)this);
        }
        this.mapView.cancelAnimation();
        super.shutdown();
        this.mapView = null;
        this.mapScene = null;
        if (this.gestureHandler != null) {
            this.gestureHandler.shutdown();
        }
        this.gestureDelegate = null;
        this.gestureHandler = null;
    }

    @Override
    public Point2d screenPointFromGeo(Point2d geoCoord) {
        if (!this.running || this.mapView == null) {
            return null;
        }
        return this.screenPointFromGeo(this.mapView, geoCoord);
    }

    @Override
    public Point2d geoPointFromScreen(Point2d screenPt) {
        if (!this.running || this.mapView == null) {
            return null;
        }
        CoordSystemDisplayAdapter coordAdapter = this.mapView.getCoordAdapter();
        CoordSystem coordSys = coordAdapter.getCoordSystem();
        Matrix4d modelMat = this.mapView.calcModelViewMatrix();
        Point3d dispPt = this.mapView.pointOnPlaneFromScreen(screenPt, modelMat, this.renderWrapper.maplyRender.frameSize, false);
        if (dispPt == null) {
            return null;
        }
        Point3d localPt = coordAdapter.displayToLocal(dispPt);
        if (localPt == null) {
            return null;
        }
        Point3d geoCoord = coordSys.localToGeographic(localPt);
        if (geoCoord == null) {
            return null;
        }
        return new Point2d(geoCoord.getX(), geoCoord.getY());
    }

    public Mbr getCurrentViewGeo() {
        if (!this.running || this.mapView == null) {
            return null;
        }
        Mbr geoMbr = new Mbr();
        Point2d frameSize = this.renderWrapper.maplyRender.frameSize;
        geoMbr.addPoint(this.geoPointFromScreen(new Point2d(0.0, 0.0)));
        geoMbr.addPoint(this.geoPointFromScreen(new Point2d(frameSize.getX(), 0.0)));
        geoMbr.addPoint(this.geoPointFromScreen(new Point2d(frameSize.getX(), frameSize.getY())));
        geoMbr.addPoint(this.geoPointFromScreen(new Point2d(0.0, frameSize.getY())));
        return geoMbr;
    }

    private Point2d screenPointFromGeo(MapView theMapView, Point2d geoCoord) {
        CoordSystemDisplayAdapter coordAdapter = theMapView.getCoordAdapter();
        CoordSystem coordSys = coordAdapter.getCoordSystem();
        Point3d localPt = coordSys.geographicToLocal(new Point3d(geoCoord.getX(), geoCoord.getY(), 0.0));
        Point3d dispPt = coordAdapter.localToDisplay(localPt);
        Matrix4d modelMat = theMapView.calcModelViewMatrix();
        return theMapView.pointOnScreenFromPlane(dispPt, modelMat, this.renderWrapper.maplyRender.frameSize);
    }

    boolean checkCoverage(Mbr mbr, MapView theMapView, double height) {
        if (!this.running || this.mapView == null) {
            return false;
        }
        Point2d centerLoc = mbr.middle();
        Point3d localCoord = theMapView.coordAdapter.coordSys.geographicToLocal(new Point3d(centerLoc.getX(), centerLoc.getY(), 0.0));
        theMapView.setLoc(new Point3d(localCoord.getX(), localCoord.getY(), height));
        List<Point2d> pts = mbr.asPoints();
        Point2d frameSize = this.renderWrapper.maplyRender.frameSize;
        for (Point2d pt : pts) {
            Point2d screenPt = this.screenPointFromGeo(theMapView, pt);
            if (!(screenPt.getX() < 0.0 || screenPt.getY() < 0.0 || screenPt.getX() > frameSize.getX()) && !(screenPt.getY() > frameSize.getY())) continue;
            return false;
        }
        return true;
    }

    public void setZoomLimits(double inMin, double inMax) {
        if (this.gestureHandler != null) {
            this.gestureHandler.setZoomLimits(inMin, inMax);
        }
    }

    public double findHeightToViewBounds(Mbr mbr, Point2d pos) {
        if (!this.running || this.mapView == null) {
            return 0.0;
        }
        MapView newMapView = this.mapView.clone();
        newMapView.setLoc(new Point3d(pos.getX(), pos.getY(), 2.0));
        double minHeight = newMapView.minHeightAboveSurface();
        double maxHeight = newMapView.maxHeightAboveSurface();
        boolean minOnScreen = this.checkCoverage(mbr, newMapView, minHeight);
        boolean maxOnScreen = this.checkCoverage(mbr, newMapView, maxHeight);
        if (!minOnScreen && !maxOnScreen) {
            return this.mapView.getLoc().getZ();
        }
        if (minOnScreen) {
            return minHeight;
        }
        double minRange = 1.0E-5;
        do {
            double midHeight = (minHeight + maxHeight) / 2.0;
            boolean midOnScreen = this.checkCoverage(mbr, newMapView, midHeight);
            if (!minOnScreen && midOnScreen) {
                maxHeight = midHeight;
                maxOnScreen = midOnScreen;
                continue;
            }
            if (midOnScreen || !maxOnScreen) break;
            this.checkCoverage(mbr, newMapView, midHeight);
            minHeight = midHeight;
            minOnScreen = midOnScreen;
        } while (!(maxHeight - minHeight < minRange));
        return maxHeight;
    }

    public void setPositionGeo(final double x, final double y, final double z) {
        if (!this.running) {
            return;
        }
        if (!this.rendererAttached) {
            this.addPostSurfaceRunnable(new Runnable(){

                @Override
                public void run() {
                    MapController.this.setPositionGeo(x, y, z);
                }
            });
            return;
        }
        this.mapView.cancelAnimation();
        Point3d geoCoord = this.mapView.coordAdapter.coordSys.geographicToLocal(new Point3d(x, y, 0.0));
        this.mapView.setLoc(new Point3d(geoCoord.getX(), geoCoord.getY(), z));
    }

    public Point3d getPositionGeo() {
        if (!this.running || this.mapView == null) {
            return null;
        }
        Point3d loc = this.mapView.getLoc();
        if (loc == null) {
            return null;
        }
        Point3d geoLoc = this.mapView.coordAdapter.coordSys.localToGeographic(loc);
        return new Point3d(geoLoc.getX(), geoLoc.getY(), loc.getZ());
    }

    public void animatePositionGeo(final double x, final double y, final double z, final double howLong) {
        if (!this.running) {
            return;
        }
        if (!this.rendererAttached) {
            this.addPostSurfaceRunnable(new Runnable(){

                @Override
                public void run() {
                    MapController.this.animatePositionGeo(x, y, z, howLong);
                }
            });
            return;
        }
        this.mapView.cancelAnimation();
        Point3d geoCoord = this.mapView.coordAdapter.coordSys.geographicToLocal(new Point3d(x, y, 0.0));
        this.mapView.setAnimationDelegate(new MapAnimateTranslate(this.mapView, this.renderWrapper.maplyRender, new Point3d(geoCoord.getX(), geoCoord.getY(), z), (float)howLong, this.viewBounds));
    }

    public void setHeading(final double heading) {
        if (!this.running) {
            return;
        }
        if (!this.rendererAttached) {
            this.addPostSurfaceRunnable(new Runnable(){

                @Override
                public void run() {
                    MapController.this.setHeading(heading);
                }
            });
            return;
        }
        this.mapView.cancelAnimation();
        this.mapView.setRot(heading);
    }

    public double getHeading() {
        if (!this.running) {
            return 0.0;
        }
        return this.mapView.getRot();
    }

    public void setAllowRotateGesture(boolean allowRotate) {
        if (!this.running) {
            return;
        }
        this.gestureHandler.allowRotate = allowRotate;
    }

    public void processTap(Point2d screenLoc) {
        if (this.gestureDelegate != null) {
            SelectedObject[] selObjs;
            Matrix4d mapTransform = this.mapView.calcModelViewMatrix();
            Point3d loc = this.mapView.pointOnPlaneFromScreen(screenLoc, mapTransform, this.getViewSize(), false);
            Point3d localPt = this.mapView.getCoordAdapter().displayToLocal(loc);
            Point3d geoPt = null;
            if (localPt != null) {
                geoPt = this.mapView.getCoordAdapter().getCoordSystem().localToGeographic(localPt);
            }
            if ((selObjs = this.getObjectsAtScreenLoc(screenLoc)) != null) {
                if (geoPt != null) {
                    this.gestureDelegate.userDidSelect(this, selObjs, geoPt.toPoint2d(), screenLoc);
                }
            } else if (geoPt != null) {
                this.gestureDelegate.userDidTap(this, geoPt.toPoint2d(), screenLoc);
            }
        }
    }

    public void processLongPress(Point2d screenLoc) {
        Matrix4d mapTransform = this.mapView.calcModelViewMatrix();
        Point3d loc = this.mapView.pointOnPlaneFromScreen(screenLoc, mapTransform, this.renderWrapper.maplyRender.frameSize, false);
        if (this.gestureDelegate != null) {
            Point3d localPt = this.mapView.getCoordAdapter().displayToLocal(loc);
            Point3d geoPt = null;
            if (localPt != null) {
                geoPt = this.mapView.getCoordAdapter().getCoordSystem().localToGeographic(localPt);
            }
            SelectedObject[] selObjs = this.getObjectsAtScreenLoc(screenLoc);
            this.gestureDelegate.userDidLongPress(this, selObjs, geoPt.toPoint2d(), screenLoc);
        }
    }

    public boolean onTouch(View view, MotionEvent e) {
        if (this.running & this.gestureHandler != null) {
            return this.gestureHandler.onTouch(view, e);
        }
        return false;
    }

    public void panDidStart(boolean userMotion) {
        this.handleStartMoving(userMotion);
        this.isPanning = true;
    }

    public void panDidEnd(boolean userMotion) {
        this.isPanning = false;
        this.handleStopMoving(userMotion);
    }

    public void zoomDidStart(boolean userMotion) {
        this.handleStartMoving(userMotion);
        this.isZooming = true;
    }

    public void zoomDidEnd(boolean userMotion) {
        this.isZooming = false;
        this.handleStopMoving(userMotion);
    }

    public void rotateDidStart(boolean userMotion) {
        this.handleStartMoving(userMotion);
        this.isRotating = true;
    }

    public void rotateDidEnd(boolean userMotion) {
        this.isRotating = false;
        this.handleStopMoving(userMotion);
    }

    public void handleStartMoving(boolean userMotion) {
        if (this.renderWrapper == null || this.renderWrapper.maplyRender == null) {
            return;
        }
        if (!(this.isPanning || this.isRotating || this.isZooming || this.isAnimating || this.gestureDelegate == null)) {
            this.gestureDelegate.mapDidStartMoving(this, userMotion);
            Choreographer c = Choreographer.getInstance();
            if (c != null) {
                c.postFrameCallback((Choreographer.FrameCallback)this);
            }
        }
    }

    public void handleStopMoving(boolean userMotion) {
        if (this.renderWrapper == null || this.renderWrapper.maplyRender == null) {
            return;
        }
        if (this.isPanning || this.isRotating || this.isZooming || this.isAnimating) {
            return;
        }
        if (this.gestureDelegate != null) {
            Point3d[] corners = this.getVisibleCorners();
            this.gestureDelegate.mapDidStopMoving(this, corners, userMotion);
        }
    }

    public void doFrame(long frameTimeNanos) {
        Choreographer c;
        if (this.mapView != null) {
            double newUpdateTime = this.mapView.getLastUpdatedTime();
            if (this.gestureDelegate != null && this.lastViewUpdate < newUpdateTime) {
                Point3d[] corners = this.getVisibleCorners();
                this.gestureDelegate.mapDidMove(this, corners, false);
                this.lastViewUpdate = newUpdateTime;
            }
        }
        if ((c = Choreographer.getInstance()) != null) {
            c.removeFrameCallback((Choreographer.FrameCallback)this);
            c.postFrameCallback((Choreographer.FrameCallback)this);
        }
    }

    public Point3d[] getVisibleCorners() {
        if (!this.running || this.mapView == null) {
            return null;
        }
        Point2d[] screenCorners = new Point2d[4];
        Point2d frameSize = this.renderWrapper.maplyRender.frameSize;
        screenCorners[0] = new Point2d(0.0, 0.0);
        screenCorners[1] = new Point2d(frameSize.getX(), 0.0);
        screenCorners[2] = new Point2d(frameSize.getX(), frameSize.getY());
        screenCorners[3] = new Point2d(0.0, frameSize.getY());
        Matrix4d modelMat = this.mapView.calcModelViewMatrix();
        Point3d[] retCorners = new Point3d[4];
        CoordSystemDisplayAdapter coordAdapter = this.mapView.getCoordAdapter();
        if (coordAdapter == null || this.renderWrapper == null || this.renderWrapper.maplyRender == null || this.renderWrapper.maplyRender.frameSize == null) {
            return retCorners;
        }
        CoordSystem coordSys = coordAdapter.getCoordSystem();
        if (coordSys == null) {
            return retCorners;
        }
        for (int ii = 0; ii < 4; ++ii) {
            Point3d planePt = this.mapView.pointOnPlaneFromScreen(screenCorners[ii], modelMat, frameSize, false);
            if (planePt == null) continue;
            retCorners[ii] = coordSys.localToGeographic(coordAdapter.displayToLocal(planePt));
        }
        return retCorners;
    }

    public static interface GestureDelegate {
        public void userDidSelect(MapController var1, SelectedObject[] var2, Point2d var3, Point2d var4);

        public void userDidTap(MapController var1, Point2d var2, Point2d var3);

        public void userDidLongPress(MapController var1, SelectedObject[] var2, Point2d var3, Point2d var4);

        public void mapDidStartMoving(MapController var1, boolean var2);

        public void mapDidStopMoving(MapController var1, Point3d[] var2, boolean var3);

        public void mapDidMove(MapController var1, Point3d[] var2, boolean var3);
    }

    public static class Settings
    extends MaplyBaseController.Settings {
        public CoordSystem coordSys = null;
        public Point3d displayCenter = null;
        public int clearColor = -16777216;
    }
}

