/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import com.mousebird.maply.ChangeSet;
import com.mousebird.maply.Layer;
import com.mousebird.maply.MaplyRenderer;
import com.mousebird.maply.Scene;
import com.mousebird.maply.View;
import com.mousebird.maply.ViewState;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.ReentrantLock;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLSurface;

public class LayerThread
extends HandlerThread
implements View.ViewWatcher {
    boolean valid = true;
    View view = null;
    Scene scene = null;
    MaplyRenderer renderer = null;
    ReentrantLock startLock = new ReentrantLock();
    ArrayList<Layer> layers = new ArrayList();
    EGLContext context = null;
    EGLSurface surface = null;
    protected boolean viewUpdates = true;
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    ChangeSet changes = new ChangeSet();
    Handler changeHandler = null;
    ArrayList<ViewWatcher> watchers = new ArrayList();
    ViewState currentViewState = null;
    boolean viewUpdateScheduled = false;
    long viewUpdateLastCalled = 0L;
    Handler trailingHandle = null;
    Runnable trailingRun = null;
    static long UpdatePeriod = 100L;

    LayerThread(String name, View inView, Scene inScene, boolean inViewUpdates) {
        super(name);
        this.view = inView;
        this.scene = inScene;
        this.viewUpdates = inViewUpdates;
        if (this.viewUpdates) {
            this.view.addViewWatcher(this);
            this.startLock.lock();
            this.start();
            this.addTask(new Runnable(){

                @Override
                public void run() {
                    LayerThread.this.startLock.lock();
                    LayerThread.this.startLock.unlock();
                    try {
                        EGL10 egl = (EGL10)EGLContext.getEGL();
                        if (LayerThread.this.context != null && LayerThread.this.surface != null && !egl.eglMakeCurrent(LayerThread.this.renderer.display, LayerThread.this.surface, LayerThread.this.surface, LayerThread.this.context)) {
                            Log.d((String)"Maply", (String)"Failed to make current context in layer thread.");
                        }
                    }
                    catch (Exception e) {
                        Log.i((String)"Maply", (String)"Failed to make current context in layer thread.");
                    }
                }
            });
        } else {
            this.start();
        }
    }

    void setRenderer(MaplyRenderer inRenderer) {
        this.renderer = inRenderer;
        EGL10 egl = (EGL10)EGLContext.getEGL();
        int[] attrib_list = new int[]{12440, 2, 12344};
        this.context = egl.eglCreateContext(this.renderer.display, this.renderer.config, this.renderer.context, attrib_list);
        int[] surface_attrs = new int[]{12375, 32, 12374, 32, 12344};
        this.surface = egl.eglCreatePbufferSurface(this.renderer.display, this.renderer.config, surface_attrs);
        if (this.viewUpdates) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    LayerThread.this.startLock.unlock();
                    LayerThread.this.viewUpdated(LayerThread.this.view);
                }
            });
        } else {
            this.addTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        EGL10 egl = (EGL10)EGLContext.getEGL();
                        if (LayerThread.this.context != null && LayerThread.this.surface != null && !egl.eglMakeCurrent(LayerThread.this.renderer.display, LayerThread.this.surface, LayerThread.this.surface, LayerThread.this.context)) {
                            Log.d((String)"Maply", (String)"Failed to make current context in layer thread.");
                        }
                    }
                    catch (Exception e) {
                        Log.i((String)"Maply", (String)"Failed to make current context in layer thread.");
                    }
                }
            });
        }
    }

    void shutdown() {
        final Semaphore endLock = new Semaphore(0, true);
        this.addTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                EGL10 egl = (EGL10)EGLContext.getEGL();
                egl.eglMakeCurrent(LayerThread.this.renderer.display, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                LayerThread.this.valid = false;
                ArrayList<Layer> layersToRemove = null;
                ArrayList<Layer> arrayList = LayerThread.this.layers;
                synchronized (arrayList) {
                    layersToRemove = new ArrayList<Layer>(LayerThread.this.layers);
                }
                for (Layer layer : layersToRemove) {
                    layer.shutdown();
                }
                LayerThread.this.layers.clear();
                endLock.release();
                try {
                    LayerThread.this.quit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, true);
        try {
            endLock.acquire();
        }
        catch (Exception exception) {
            // empty catch block
        }
        EGL10 egl = (EGL10)EGLContext.getEGL();
        if (this.surface != null) {
            egl.eglDestroySurface(this.renderer.display, this.surface);
            this.surface = null;
        }
        if (this.context != null) {
            egl.eglDestroyContext(this.renderer.display, this.context);
            this.context = null;
        }
        this.layers = null;
        this.view = null;
        this.scene = null;
        this.renderer = null;
        this.context = null;
        this.surface = null;
        this.watchers = null;
    }

    public void addLayer(final Layer layer) {
        final LayerThread theLayerThread = this;
        this.addTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList<Layer> arrayList = LayerThread.this.layers;
                synchronized (arrayList) {
                    LayerThread.this.layers.add(layer);
                }
                layer.startLayer(theLayerThread);
            }
        });
    }

    public void removeLayer(final Layer layer) {
        this.addTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                layer.shutdown();
                ArrayList<Layer> arrayList = LayerThread.this.layers;
                synchronized (arrayList) {
                    LayerThread.this.layers.remove(layer);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChanges(ChangeSet newChanges) {
        if (this.changes == null || newChanges == null) {
            return;
        }
        ChangeSet changeSet = this.changes;
        synchronized (changeSet) {
            this.changes.merge(newChanges);
            if (this.changeHandler == null) {
                this.changeHandler = this.addTask(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ChangeSet changeSet = LayerThread.this.changes;
                        synchronized (changeSet) {
                            LayerThread.this.changeHandler = null;
                            if (LayerThread.this.scene != null) {
                                LayerThread.this.changes.process(LayerThread.this.scene);
                            }
                        }
                    }
                }, true);
            }
        }
    }

    public Handler addTask(Runnable run) {
        return this.addTask(run, false);
    }

    public Handler addDelayedTask(Runnable run, long time) {
        Handler handler = new Handler(this.getLooper());
        handler.postDelayed(run, time);
        return handler;
    }

    public Handler addTask(Runnable run, boolean wait) {
        if (!this.valid) {
            return null;
        }
        if (wait || Looper.myLooper() != this.getLooper()) {
            Handler handler = new Handler(this.getLooper());
            handler.post(run);
            return handler;
        }
        run.run();
        return null;
    }

    public void addWatcher(final ViewWatcherInterface watcher) {
        this.addTask(new Runnable(){

            @Override
            public void run() {
                LayerThread.this.watchers.add(new ViewWatcher(watcher));
                LayerThread.this.addTask(new Runnable(){

                    @Override
                    public void run() {
                        if (LayerThread.this.currentViewState != null) {
                            LayerThread.this.updateWatchers(LayerThread.this.currentViewState, System.currentTimeMillis());
                        }
                    }
                }, true);
            }
        });
    }

    public void removeWatcher(final ViewWatcherInterface watcher) {
        this.addTask(new Runnable(){

            @Override
            public void run() {
                ViewWatcher found = null;
                for (ViewWatcher theWatcher : LayerThread.this.watchers) {
                    if (theWatcher.watcher != watcher) continue;
                    found = theWatcher;
                    break;
                }
                if (found != null) {
                    LayerThread.this.watchers.remove(found);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateWatchers(final ViewState viewState, long now) {
        this.viewUpdateLastCalled = now;
        final LayerThread theLayerThread = this;
        LayerThread layerThread = this;
        synchronized (layerThread) {
            if (!this.viewUpdateScheduled) {
                this.viewUpdateScheduled = true;
                this.addTask(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        LayerThread layerThread = theLayerThread;
                        synchronized (layerThread) {
                            LayerThread.this.viewUpdateScheduled = false;
                        }
                        LayerThread.this.currentViewState = viewState;
                        for (ViewWatcher watcher : LayerThread.this.watchers) {
                            watcher.watcher.viewUpdated(LayerThread.this.currentViewState);
                        }
                    }
                }, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleLateUpdate(long delay) {
        LayerThread layerThread = this;
        synchronized (layerThread) {
            if (this.trailingHandle != null) {
                this.trailingHandle.removeCallbacks(this.trailingRun);
                this.trailingHandle = null;
                this.trailingRun = null;
            }
            this.trailingRun = new Runnable(){

                @Override
                public void run() {
                    ViewState viewState = LayerThread.this.view.makeViewState(LayerThread.this.renderer);
                    long now = System.currentTimeMillis();
                    LayerThread.this.updateWatchers(viewState, now);
                    LayerThread.this.trailingHandle = null;
                    LayerThread.this.trailingRun = null;
                }
            };
            this.trailingHandle = this.addDelayedTask(this.trailingRun, delay);
        }
    }

    @Override
    public void viewUpdated(View view) {
        if (view == null || this.renderer == null) {
            return;
        }
        ViewState viewState = view.makeViewState(this.renderer);
        long now = System.currentTimeMillis();
        long timeUntil = now - this.viewUpdateLastCalled;
        if (timeUntil > UpdatePeriod) {
            this.updateWatchers(viewState, now);
        } else {
            this.scheduleLateUpdate(UpdatePeriod);
        }
    }

    class ViewWatcher {
        public ViewWatcherInterface watcher = null;
        public float minTime = 0.1f;
        public float maxLagTime = 10.0f;

        ViewWatcher(ViewWatcherInterface inWatcher) {
            this.watcher = inWatcher;
            this.minTime = this.watcher.getMinTime();
            this.maxLagTime = this.watcher.getMaxLagTime();
        }
    }

    static interface ViewWatcherInterface {
        public void viewUpdated(ViewState var1);

        public float getMinTime();

        public float getMaxLagTime();
    }
}

