/*
 * Decompiled with CFR 0.152.
 */
package com.mousebird.maply;

import com.mousebird.maply.CoordSystemDisplayAdapter;
import com.mousebird.maply.GlobeController;
import com.mousebird.maply.GlobeViewState;
import com.mousebird.maply.MaplyRenderer;
import com.mousebird.maply.Matrix4d;
import com.mousebird.maply.Point2d;
import com.mousebird.maply.Point3d;
import com.mousebird.maply.Point4d;
import com.mousebird.maply.Quaternion;
import com.mousebird.maply.View;
import com.mousebird.maply.ViewState;

public class GlobeView
extends View {
    GlobeController control = null;
    double lastUpdated = 0.0;
    AnimationDelegate animationDelegate = null;
    public boolean northUp = true;

    private GlobeView() {
    }

    GlobeView(GlobeController inControl, CoordSystemDisplayAdapter inCoordAdapter) {
        this.control = inControl;
        this.coordAdapter = inCoordAdapter;
        this.initialise(this.coordAdapter);
    }

    @Override
    protected GlobeView clone() {
        GlobeView that = new GlobeView(this.control, this.coordAdapter);
        this.nativeClone(that);
        return that;
    }

    public void finalize() {
        this.dispose();
    }

    @Override
    public ViewState makeViewState(MaplyRenderer renderer) {
        return new GlobeViewState(this, renderer);
    }

    void setAnimationDelegate(AnimationDelegate delegate) {
        this.animationDelegate = delegate;
    }

    @Override
    public void cancelAnimation() {
        this.animationDelegate = null;
        this.control.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                GlobeView.this.control.handleStopMoving(false);
            }
        });
    }

    @Override
    public void animate() {
        if (this.animationDelegate != null) {
            this.animationDelegate.updateView(this);
            this.runViewUpdates();
        }
    }

    @Override
    public boolean isAnimating() {
        return this.animationDelegate != null;
    }

    void setLoc(Point3d loc) {
        double z = loc.getZ();
        z = Math.min(this.maxHeightAboveSurface(), z);
        z = Math.max(this.minHeightAboveSurface(), z);
        Quaternion newRot = this.makeRotationToGeoCoord(loc.getX(), loc.getY(), this.northUp);
        this.setRotQuatNative(newRot);
        this.setHeight(z);
        this.runViewUpdates();
    }

    void setRotQuat(Quaternion quat) {
        this.setRotQuatNative(quat);
        this.runViewUpdates();
    }

    Point3d getEyePosition() {
        Matrix4d mat = this.calcModelViewMatrix();
        Point4d pos = mat.inverse().multiply(new Point4d(0.0, 0.0, 0.0, 1.0));
        return new Point3d(pos.getX(), pos.getY(), pos.getZ());
    }

    native Point3d pointOnSphereFromScreen(Point2d var1, Matrix4d var2, Point2d var3, boolean var4);

    native Point2d pointOnScreenFromSphere(Point3d var1, Matrix4d var2, Point2d var3);

    native double minHeightAboveSurface();

    native double maxHeightAboveSurface();

    native Quaternion getRotQuat();

    native void setRotQuatNative(Quaternion var1);

    public native Point3d getLoc();

    public native double getHeight();

    public native void setHeight(double var1);

    public native Quaternion makeRotationToGeoCoord(double var1, double var3, boolean var5);

    public native Point3d prospectiveUp(Quaternion var1);

    public native Point3d pointUnproject(Point2d var1, Point2d var2, boolean var3);

    private static native void nativeInit();

    native void initialise(CoordSystemDisplayAdapter var1);

    protected native void nativeClone(GlobeView var1);

    native void dispose();

    static {
        GlobeView.nativeInit();
    }

    static interface AnimationDelegate {
        public void updateView(GlobeView var1);
    }
}

