/*
 * Decompiled with CFR 0.152.
 */
package com.mottimotti.android.sample;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import com.actionbarsherlock.app.SherlockActivity;
import com.mottimotti.android.widget.CalendarTable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class CalendarActivity
extends SherlockActivity
implements CalendarTable.OnMonthSelectedListener,
CalendarTable.CellClickListener {
    private CalendarTable calendarTableLayout;
    private TextView monthPreview;
    private Toast toast;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2130903066);
        this.toast = Toast.makeText((Context)this, (CharSequence)"", (int)0);
        this.monthPreview = (TextView)this.findViewById(2131034190);
        this.calendarTableLayout = (CalendarTable)this.findViewById(2131034191);
        this.calendarTableLayout.setOnMonthSelectedListener(this);
        this.calendarTableLayout.setCellClickListener(this);
        this.populateActiveDates();
        this.updateMonthPreview();
    }

    private void populateActiveDates() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.getTimeInMillis();
        ArrayList<Date> activeDates = new ArrayList<Date>();
        for (int i = 0; i < 5; ++i) {
            calendar.add(5, -1);
            activeDates.add(calendar.getTime());
        }
        this.calendarTableLayout.setActiveDates(activeDates);
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        Parcelable parcelable = this.calendarTableLayout.onSaveInstanceState();
        outState.putParcelable("table", parcelable);
        super.onSaveInstanceState(outState);
    }

    @Override
    public void onRestoreInstanceState(Bundle savedState) {
        super.onRestoreInstanceState(savedState);
        Parcelable parcelable = savedState.getParcelable("table");
        this.calendarTableLayout.onRestoreInstanceState(parcelable);
        this.updateMonthPreview();
    }

    public void previousMonth(View view) {
        this.calendarTableLayout.previousMonth();
    }

    public void nextMonth(View view) {
        this.calendarTableLayout.nextMonth();
    }

    @Override
    public void onPreviousMonthSelected(Calendar startCalendar, Calendar endCalendar) {
        this.updateMonthPreview();
    }

    @Override
    public void onNextMonthSelected(Calendar startCalendar, Calendar endCalendar) {
        this.updateMonthPreview();
    }

    private void updateMonthPreview() {
        Calendar calendar = this.calendarTableLayout.getHelperCalendar();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy - MMMM");
        this.monthPreview.setText((CharSequence)sdf.format(calendar.getTime()));
    }

    @Override
    public void onClick(Calendar selectedCalendar) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy - MMMM - dd");
        String stringDate = sdf.format(selectedCalendar.getTime());
        this.toast.setText((CharSequence)stringDate);
        this.toast.show();
    }
}

