/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import com.actionbarsherlock.internal.nineoldandroids.widget.NineLinearLayout;

public class IcsLinearLayout
extends NineLinearLayout {
    private static final int[] R_styleable_LinearLayout = new int[]{16843049, 16843476, 16843561, 16843562};
    private static final int LinearLayout_divider = 0;
    private static final int LinearLayout_measureWithLargestChild = 1;
    private static final int LinearLayout_showDividers = 2;
    private static final int LinearLayout_dividerPadding = 3;
    public static final int SHOW_DIVIDER_NONE = 0;
    public static final int SHOW_DIVIDER_BEGINNING = 1;
    public static final int SHOW_DIVIDER_MIDDLE = 2;
    public static final int SHOW_DIVIDER_END = 4;
    private Drawable mDivider;
    private int mDividerWidth;
    private int mDividerHeight;
    private int mShowDividers;
    private int mDividerPadding;
    private boolean mUseLargestChild;

    public IcsLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R_styleable_LinearLayout);
        this.setDividerDrawable(a.getDrawable(0));
        this.mShowDividers = a.getInt(2, 0);
        this.mDividerPadding = a.getDimensionPixelSize(3, 0);
        this.mUseLargestChild = a.getBoolean(1, false);
        a.recycle();
    }

    public void setShowDividers(int showDividers) {
        if (showDividers != this.mShowDividers) {
            this.requestLayout();
            this.invalidate();
        }
        this.mShowDividers = showDividers;
    }

    public int getShowDividers() {
        return this.mShowDividers;
    }

    public void setDividerDrawable(Drawable divider) {
        if (divider == this.mDivider) {
            return;
        }
        this.mDivider = divider;
        if (divider != null) {
            this.mDividerWidth = divider.getIntrinsicWidth();
            this.mDividerHeight = divider.getIntrinsicHeight();
        } else {
            this.mDividerWidth = 0;
            this.mDividerHeight = 0;
        }
        this.setWillNotDraw(divider == null);
        this.requestLayout();
    }

    public void setDividerPadding(int padding) {
        this.mDividerPadding = padding;
    }

    public int getDividerPadding() {
        return this.mDividerPadding;
    }

    public int getDividerWidth() {
        return this.mDividerWidth;
    }

    protected void measureChildWithMargins(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        int count;
        int index = this.indexOfChild(child);
        int orientation = this.getOrientation();
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)child.getLayoutParams();
        if (this.hasDividerBeforeChildAt(index)) {
            if (orientation == 1) {
                params.topMargin = this.mDividerHeight;
            } else {
                params.leftMargin = this.mDividerWidth;
            }
        }
        if (index == (count = this.getChildCount()) - 1 && this.hasDividerBeforeChildAt(count)) {
            if (orientation == 1) {
                params.bottomMargin = this.mDividerHeight;
            } else {
                params.rightMargin = this.mDividerWidth;
            }
        }
        super.measureChildWithMargins(child, parentWidthMeasureSpec, widthUsed, parentHeightMeasureSpec, heightUsed);
    }

    protected void onDraw(Canvas canvas) {
        if (this.mDivider != null) {
            if (this.getOrientation() == 1) {
                this.drawDividersVertical(canvas);
            } else {
                this.drawDividersHorizontal(canvas);
            }
        }
        super.onDraw(canvas);
    }

    void drawDividersVertical(Canvas canvas) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8 || !this.hasDividerBeforeChildAt(i)) continue;
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)child.getLayoutParams();
            int top = child.getTop() - lp.topMargin;
            this.drawHorizontalDivider(canvas, top);
        }
        if (this.hasDividerBeforeChildAt(count)) {
            View child = this.getChildAt(count - 1);
            int bottom = 0;
            bottom = child == null ? this.getHeight() - this.getPaddingBottom() - this.mDividerHeight : child.getBottom();
            this.drawHorizontalDivider(canvas, bottom);
        }
    }

    void drawDividersHorizontal(Canvas canvas) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8 || !this.hasDividerBeforeChildAt(i)) continue;
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)child.getLayoutParams();
            int left = child.getLeft() - lp.leftMargin;
            this.drawVerticalDivider(canvas, left);
        }
        if (this.hasDividerBeforeChildAt(count)) {
            View child = this.getChildAt(count - 1);
            int right = 0;
            right = child == null ? this.getWidth() - this.getPaddingRight() - this.mDividerWidth : child.getRight();
            this.drawVerticalDivider(canvas, right);
        }
    }

    void drawHorizontalDivider(Canvas canvas, int top) {
        this.mDivider.setBounds(this.getPaddingLeft() + this.mDividerPadding, top, this.getWidth() - this.getPaddingRight() - this.mDividerPadding, top + this.mDividerHeight);
        this.mDivider.draw(canvas);
    }

    void drawVerticalDivider(Canvas canvas, int left) {
        this.mDivider.setBounds(left, this.getPaddingTop() + this.mDividerPadding, left + this.mDividerWidth, this.getHeight() - this.getPaddingBottom() - this.mDividerPadding);
        this.mDivider.draw(canvas);
    }

    protected boolean hasDividerBeforeChildAt(int childIndex) {
        if (childIndex == 0) {
            return (this.mShowDividers & 1) != 0;
        }
        if (childIndex == this.getChildCount()) {
            return (this.mShowDividers & 4) != 0;
        }
        if ((this.mShowDividers & 2) != 0) {
            boolean hasVisibleViewBefore = false;
            for (int i = childIndex - 1; i >= 0; --i) {
                if (this.getChildAt(i).getVisibility() == 8) continue;
                hasVisibleViewBefore = true;
                break;
            }
            return hasVisibleViewBefore;
        }
        return false;
    }

    public boolean isMeasureWithLargestChildEnabled() {
        return this.mUseLargestChild;
    }

    public void setMeasureWithLargestChildEnabled(boolean enabled) {
        this.mUseLargestChild = enabled;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mUseLargestChild) {
            int orientation = this.getOrientation();
            switch (orientation) {
                case 0: {
                    this.useLargestChildHorizontal();
                    break;
                }
                case 1: {
                    this.useLargestChildVertical();
                }
            }
        }
    }

    private void useLargestChildHorizontal() {
        int childCount = this.getChildCount();
        int largestChildWidth = 0;
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            largestChildWidth = Math.max(child.getMeasuredWidth(), largestChildWidth);
        }
        int totalWidth = 0;
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8) continue;
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)child.getLayoutParams();
            float childExtra = lp.weight;
            if (childExtra > 0.0f) {
                child.measure(View.MeasureSpec.makeMeasureSpec((int)largestChildWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)child.getMeasuredHeight(), (int)0x40000000));
                totalWidth += largestChildWidth;
            } else {
                totalWidth += child.getMeasuredWidth();
            }
            totalWidth += lp.leftMargin + lp.rightMargin;
        }
        this.setMeasuredDimension(totalWidth += this.getPaddingLeft() + this.getPaddingRight(), this.getMeasuredHeight());
    }

    private void useLargestChildVertical() {
        int childCount = this.getChildCount();
        int largestChildHeight = 0;
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            largestChildHeight = Math.max(child.getMeasuredHeight(), largestChildHeight);
        }
        int totalHeight = 0;
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8) continue;
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)child.getLayoutParams();
            float childExtra = lp.weight;
            if (childExtra > 0.0f) {
                child.measure(View.MeasureSpec.makeMeasureSpec((int)child.getMeasuredWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)largestChildHeight, (int)0x40000000));
                totalHeight += largestChildHeight;
            } else {
                totalHeight += child.getMeasuredHeight();
            }
            totalHeight += lp.leftMargin + lp.rightMargin;
        }
        this.setMeasuredDimension(this.getMeasuredWidth(), totalHeight += this.getPaddingLeft() + this.getPaddingRight());
    }
}

