/*
 * Decompiled with CFR 0.152.
 */
package com.mottimotti.android.widget;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RadioGroup;

public class RadioGroupSegmented
extends RadioGroup {
    public RadioGroupSegmented(Context context) {
        super(context);
    }

    public RadioGroupSegmented(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.changeButtonsImages();
    }

    private void changeButtonsImages() {
        int count = super.getChildCount();
        if (count > 1) {
            super.getChildAt(0).setBackgroundResource(2130837634);
            for (int i = 1; i < count - 1; ++i) {
                super.getChildAt(i).setBackgroundResource(2130837635);
            }
            super.getChildAt(count - 1).setBackgroundResource(2130837636);
        } else if (count == 1) {
            super.getChildAt(0).setBackgroundResource(2130837621);
        }
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        int checkedRadioButtonId = savedState.checkedRadioButtonId;
        this.check(checkedRadioButtonId);
        this.requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.checkedRadioButtonId = this.getCheckedRadioButtonId();
        return savedState;
    }

    static class SavedState
    extends View.BaseSavedState {
        int checkedRadioButtonId;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.checkedRadioButtonId = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.checkedRadioButtonId);
        }
    }
}

