/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.nativeads.NativeAd;
import java.util.WeakHashMap;

class NativeAdViewHelper {
    private static final WeakHashMap<View, NativeAd> sNativeAdMap = new WeakHashMap();

    private NativeAdViewHelper() {
    }

    @NonNull
    static View getAdView(@Nullable View convertView, @Nullable ViewGroup parent, @NonNull Context context, @Nullable NativeAd nativeAd) {
        if (convertView != null) {
            NativeAdViewHelper.clearNativeAd(convertView);
        }
        if (nativeAd == null || nativeAd.isDestroyed()) {
            MoPubLog.d((String)"NativeAd null or invalid. Returning empty view");
            if (convertView == null || !ViewType.EMPTY.equals(convertView.getTag())) {
                convertView = new View(context);
                convertView.setTag((Object)ViewType.EMPTY);
                convertView.setVisibility(8);
            }
        } else {
            if (convertView == null || !ViewType.AD.equals(convertView.getTag())) {
                convertView = nativeAd.createAdView(context, parent);
                convertView.setTag((Object)ViewType.AD);
            }
            NativeAdViewHelper.prepareNativeAd(convertView, nativeAd);
            nativeAd.renderAdView(convertView);
        }
        return convertView;
    }

    private static void clearNativeAd(@NonNull View view) {
        NativeAd nativeAd = sNativeAdMap.get(view);
        if (nativeAd != null) {
            nativeAd.clear(view);
        }
    }

    private static void prepareNativeAd(@NonNull View view, @NonNull NativeAd nativeAd) {
        sNativeAdMap.put(view, nativeAd);
        nativeAd.prepare(view);
    }

    @VisibleForTesting
    static enum ViewType {
        EMPTY,
        AD;

    }
}

