/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.mopub.common.VisibilityTracker;
import com.mopub.common.VisibleForTesting;
import com.mopub.nativeads.ImpressionInterface;
import com.mopub.nativeads.TimestampWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class ImpressionTracker {
    private static final int PERIOD = 250;
    @NonNull
    private final VisibilityTracker mVisibilityTracker;
    @NonNull
    private final Map<View, ImpressionInterface> mTrackedViews;
    @NonNull
    private final Map<View, TimestampWrapper<ImpressionInterface>> mPollingViews;
    @NonNull
    private final Handler mPollHandler;
    @NonNull
    private final PollingRunnable mPollingRunnable;
    @NonNull
    private final VisibilityTracker.VisibilityChecker mVisibilityChecker;
    @Nullable
    private VisibilityTracker.VisibilityTrackerListener mVisibilityTrackerListener;

    public ImpressionTracker(@NonNull Context context) {
        this(new WeakHashMap<View, ImpressionInterface>(), new WeakHashMap<View, TimestampWrapper<ImpressionInterface>>(), new VisibilityTracker.VisibilityChecker(), new VisibilityTracker(context), new Handler(Looper.getMainLooper()));
    }

    @VisibleForTesting
    ImpressionTracker(@NonNull Map<View, ImpressionInterface> trackedViews, @NonNull Map<View, TimestampWrapper<ImpressionInterface>> pollingViews, @NonNull VisibilityTracker.VisibilityChecker visibilityChecker, @NonNull VisibilityTracker visibilityTracker, @NonNull Handler handler) {
        this.mTrackedViews = trackedViews;
        this.mPollingViews = pollingViews;
        this.mVisibilityChecker = visibilityChecker;
        this.mVisibilityTracker = visibilityTracker;
        this.mVisibilityTrackerListener = new VisibilityTracker.VisibilityTrackerListener(){

            public void onVisibilityChanged(@NonNull List<View> visibleViews, @NonNull List<View> invisibleViews) {
                for (View view : visibleViews) {
                    ImpressionInterface impressionInterface = (ImpressionInterface)ImpressionTracker.this.mTrackedViews.get(view);
                    if (impressionInterface == null) {
                        ImpressionTracker.this.removeView(view);
                        continue;
                    }
                    TimestampWrapper polling = (TimestampWrapper)ImpressionTracker.this.mPollingViews.get(view);
                    if (polling != null && impressionInterface.equals(polling.mInstance)) continue;
                    ImpressionTracker.this.mPollingViews.put(view, new TimestampWrapper<ImpressionInterface>(impressionInterface));
                }
                for (View view : invisibleViews) {
                    ImpressionTracker.this.mPollingViews.remove(view);
                }
                ImpressionTracker.this.scheduleNextPoll();
            }
        };
        this.mVisibilityTracker.setVisibilityTrackerListener(this.mVisibilityTrackerListener);
        this.mPollHandler = handler;
        this.mPollingRunnable = new PollingRunnable();
    }

    public void addView(View view, @NonNull ImpressionInterface impressionInterface) {
        if (this.mTrackedViews.get(view) == impressionInterface) {
            return;
        }
        this.removeView(view);
        if (impressionInterface.isImpressionRecorded()) {
            return;
        }
        this.mTrackedViews.put(view, impressionInterface);
        this.mVisibilityTracker.addView(view, impressionInterface.getImpressionMinPercentageViewed(), impressionInterface.getImpressionMinVisiblePx());
    }

    public void removeView(View view) {
        this.mTrackedViews.remove(view);
        this.removePollingView(view);
        this.mVisibilityTracker.removeView(view);
    }

    public void clear() {
        this.mTrackedViews.clear();
        this.mPollingViews.clear();
        this.mVisibilityTracker.clear();
        this.mPollHandler.removeMessages(0);
    }

    public void destroy() {
        this.clear();
        this.mVisibilityTracker.destroy();
        this.mVisibilityTrackerListener = null;
    }

    @VisibleForTesting
    void scheduleNextPoll() {
        if (this.mPollHandler.hasMessages(0)) {
            return;
        }
        this.mPollHandler.postDelayed((Runnable)this.mPollingRunnable, 250L);
    }

    private void removePollingView(View view) {
        this.mPollingViews.remove(view);
    }

    @Deprecated
    @Nullable
    @VisibleForTesting
    VisibilityTracker.VisibilityTrackerListener getVisibilityTrackerListener() {
        return this.mVisibilityTrackerListener;
    }

    @VisibleForTesting
    class PollingRunnable
    implements Runnable {
        @NonNull
        private final ArrayList<View> mRemovedViews = new ArrayList();

        PollingRunnable() {
        }

        @Override
        public void run() {
            for (Map.Entry entry : ImpressionTracker.this.mPollingViews.entrySet()) {
                View view = (View)entry.getKey();
                TimestampWrapper timestampWrapper = (TimestampWrapper)entry.getValue();
                if (!ImpressionTracker.this.mVisibilityChecker.hasRequiredTimeElapsed(timestampWrapper.mCreatedTimestamp, ((ImpressionInterface)timestampWrapper.mInstance).getImpressionMinTimeViewed())) continue;
                ((ImpressionInterface)timestampWrapper.mInstance).recordImpression(view);
                ((ImpressionInterface)timestampWrapper.mInstance).setImpressionRecorded();
                this.mRemovedViews.add(view);
            }
            for (View view : this.mRemovedViews) {
                ImpressionTracker.this.removeView(view);
            }
            this.mRemovedViews.clear();
            if (!ImpressionTracker.this.mPollingViews.isEmpty()) {
                ImpressionTracker.this.scheduleNextPoll();
            }
        }
    }
}

