/*
 * Decompiled with CFR 0.152.
 */
package com.moos.library;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.OvershootInterpolator;
import com.moos.library.HorizontalProgressView;
import com.moos.library.R;
import com.moos.library.Utils;

public class HorizontalProgressView
extends View {
    public static final int ACCELERATE_DECELERATE_INTERPOLATOR = 0;
    public static final int LINEAR_INTERPOLATOR = 1;
    public static final int ACCELERATE_INTERPOLATOR = 2;
    public static final int DECELERATE_INTERPOLATOR = 3;
    public static final int OVERSHOOT_INTERPOLATOR = 4;
    private static final String TAG = "Moos-Progress-View";
    private Context mContext;
    private int mAnimateType = 0;
    private float mStartProgress = 0.0f;
    private float mEndProgress = 60.0f;
    private int mStartColor = this.getResources().getColor(R.color.light_orange);
    private int mEndColor = this.getResources().getColor(R.color.dark_orange);
    private boolean trackEnabled = false;
    private int mTrackWidth = 6;
    private int mProgressTextSize = 48;
    private int mProgressTextColor = this.getResources().getColor(R.color.colorAccent);
    private int mTrackColor = this.getResources().getColor(R.color.default_track_color);
    private int mProgressDuration = 1200;
    private boolean textVisibility = true;
    private int mCornerRadius = 30;
    private int mTextPaddingBottomOffset = 5;
    private ObjectAnimator progressAnimator;
    private float moveProgress = 0.0f;
    private Paint progressPaint;
    private LinearGradient mShader;
    private RectF mRect;
    private RectF mTrackRect;
    private Paint mTextPaint;
    private Interpolator mInterpolator;
    private HorizontalProgressUpdateListener animatorUpdateListener;

    public HorizontalProgressView(Context context) {
        super(context);
        this.mContext = context;
        this.obtainAttrs(context, null);
        this.init();
    }

    public HorizontalProgressView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.obtainAttrs(context, attrs);
        this.init();
    }

    public HorizontalProgressView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.obtainAttrs(context, attrs);
        this.init();
    }

    private void obtainAttrs(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.HorizontalProgressView);
        this.mStartProgress = typedArray.getInt(R.styleable.HorizontalProgressView_start_progress, 0);
        this.mEndProgress = typedArray.getInt(R.styleable.HorizontalProgressView_end_progress, 60);
        this.mStartColor = typedArray.getColor(R.styleable.HorizontalProgressView_start_color, this.getResources().getColor(R.color.light_orange));
        this.mEndColor = typedArray.getColor(R.styleable.HorizontalProgressView_end_color, this.getResources().getColor(R.color.dark_orange));
        this.trackEnabled = typedArray.getBoolean(R.styleable.HorizontalProgressView_isTracked, false);
        this.mProgressTextColor = typedArray.getColor(R.styleable.HorizontalProgressView_progressTextColor, this.getResources().getColor(R.color.colorAccent));
        this.mProgressTextSize = typedArray.getDimensionPixelSize(R.styleable.HorizontalProgressView_progressTextSize, this.getResources().getDimensionPixelSize(R.dimen.default_horizontal_text_size));
        this.mTrackWidth = typedArray.getDimensionPixelSize(R.styleable.HorizontalProgressView_track_width, this.getResources().getDimensionPixelSize(R.dimen.default_trace_width));
        this.mAnimateType = typedArray.getInt(R.styleable.HorizontalProgressView_animateType, 0);
        this.mTrackColor = typedArray.getColor(R.styleable.HorizontalProgressView_trackColor, this.getResources().getColor(R.color.default_track_color));
        this.textVisibility = typedArray.getBoolean(R.styleable.HorizontalProgressView_progressTextVisibility, true);
        this.mProgressDuration = typedArray.getInt(R.styleable.HorizontalProgressView_progressDuration, 1200);
        this.mCornerRadius = typedArray.getDimensionPixelSize(R.styleable.HorizontalProgressView_corner_radius, this.getResources().getDimensionPixelSize(R.dimen.default_corner_radius));
        this.mTextPaddingBottomOffset = typedArray.getDimensionPixelSize(R.styleable.HorizontalProgressView_text_padding_bottom, this.getResources().getDimensionPixelSize(R.dimen.default_corner_radius));
        Log.e((String)TAG, (String)("progressDuration: " + this.mProgressDuration));
        typedArray.recycle();
        this.moveProgress = this.mStartProgress;
    }

    private void init() {
        this.progressPaint = new Paint(1);
        this.progressPaint.setStyle(Paint.Style.FILL);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.updateTheTrack();
        this.drawTrack(canvas);
        this.progressPaint.setShader((Shader)this.mShader);
        canvas.drawRoundRect(this.mRect, (float)this.mCornerRadius, (float)this.mCornerRadius, this.progressPaint);
        this.drawProgressText(canvas);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mShader = new LinearGradient((float)(this.getPaddingLeft() - 200), (float)(this.getHeight() - this.getPaddingTop() - 100), (float)(this.getWidth() - this.getPaddingRight()), (float)(this.getHeight() / 2 + this.getPaddingTop() + this.mTrackWidth), this.mStartColor, this.mEndColor, Shader.TileMode.CLAMP);
    }

    private void drawTrack(Canvas canvas) {
        if (this.trackEnabled) {
            this.progressPaint.setShader(null);
            this.progressPaint.setColor(this.mTrackColor);
            canvas.drawRoundRect(this.mTrackRect, (float)this.mCornerRadius, (float)this.mCornerRadius, this.progressPaint);
        }
    }

    private void drawProgressText(Canvas canvas) {
        if (this.textVisibility) {
            this.mTextPaint = new Paint(1);
            this.mTextPaint.setStyle(Paint.Style.FILL);
            this.mTextPaint.setTextSize((float)this.mProgressTextSize);
            this.mTextPaint.setColor(this.mProgressTextColor);
            this.mTextPaint.setTextAlign(Paint.Align.CENTER);
            String progressText = (int)this.moveProgress + "%";
            canvas.drawText(progressText, (float)((this.getWidth() - this.getPaddingLeft()) / 2), (float)(this.getHeight() / 2 - this.getPaddingTop() - this.mTextPaddingBottomOffset), this.mTextPaint);
        }
    }

    public void setAnimateType(@AnimateType int type) {
        this.mAnimateType = type;
        this.setObjectAnimatorType(type);
    }

    private void setObjectAnimatorType(int animatorType) {
        Log.e((String)TAG, (String)("AnimatorType>>>>>>" + animatorType));
        switch (animatorType) {
            case 0: {
                if (this.mInterpolator != null) {
                    this.mInterpolator = null;
                }
                this.mInterpolator = new AccelerateDecelerateInterpolator();
                break;
            }
            case 1: {
                if (this.mInterpolator != null) {
                    this.mInterpolator = null;
                }
                this.mInterpolator = new LinearInterpolator();
                break;
            }
            case 2: {
                if (this.mInterpolator == null) break;
                this.mInterpolator = null;
                this.mInterpolator = new AccelerateInterpolator();
                break;
            }
            case 3: {
                if (this.mInterpolator != null) {
                    this.mInterpolator = null;
                }
                this.mInterpolator = new DecelerateInterpolator();
                break;
            }
            case 4: {
                if (this.mInterpolator != null) {
                    this.mInterpolator = null;
                }
                this.mInterpolator = new OvershootInterpolator();
            }
        }
    }

    public void setProgress(float progress) {
        this.moveProgress = progress;
        this.refreshTheView();
    }

    public float getProgress() {
        return this.moveProgress;
    }

    public void setStartProgress(float startProgress) {
        if (startProgress < 0.0f || startProgress > 100.0f) {
            throw new IllegalArgumentException("Illegal progress value, please change it!");
        }
        this.moveProgress = this.mStartProgress = startProgress;
        this.refreshTheView();
    }

    public void setEndProgress(float endProgress) {
        if (endProgress < 0.0f || endProgress > 100.0f) {
            throw new IllegalArgumentException("Illegal progress value, please change it!");
        }
        this.mEndProgress = endProgress;
        this.refreshTheView();
    }

    public void setStartColor(@ColorInt int startColor) {
        this.mStartColor = startColor;
        this.mShader = new LinearGradient((float)(this.getPaddingLeft() - 200), (float)(this.getHeight() - this.getPaddingTop() - 100), (float)(this.getWidth() - this.getPaddingRight()), (float)(this.getHeight() / 2 + this.getPaddingTop() + this.mTrackWidth), this.mStartColor, this.mEndColor, Shader.TileMode.CLAMP);
        this.refreshTheView();
    }

    public void setEndColor(@ColorInt int endColor) {
        this.mEndColor = endColor;
        this.mShader = new LinearGradient((float)(this.getPaddingLeft() - 200), (float)(this.getHeight() - this.getPaddingTop() - 100), (float)(this.getWidth() - this.getPaddingRight()), (float)(this.getHeight() / 2 + this.getPaddingTop() + this.mTrackWidth), this.mStartColor, this.mEndColor, Shader.TileMode.CLAMP);
        this.refreshTheView();
    }

    public void setTrackWidth(int width) {
        this.mTrackWidth = Utils.dp2px(this.mContext, width);
        this.refreshTheView();
    }

    public void setProgressTextColor(@ColorInt int textColor) {
        this.mProgressTextColor = textColor;
    }

    public void setProgressTextSize(int size) {
        this.mProgressTextSize = Utils.sp2px(this.mContext, size);
        this.refreshTheView();
    }

    public void setProgressDuration(int duration) {
        this.mProgressDuration = duration;
    }

    public void setTrackEnabled(boolean trackAble) {
        this.trackEnabled = trackAble;
        this.refreshTheView();
    }

    public void setProgressTextVisibility(boolean visibility) {
        this.textVisibility = visibility;
        this.refreshTheView();
    }

    public void startProgressAnimation() {
        this.progressAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"progress", (float[])new float[]{this.mStartProgress, this.mEndProgress});
        Log.e((String)TAG, (String)("progressDuration: " + this.mProgressDuration));
        this.progressAnimator.setInterpolator((TimeInterpolator)this.mInterpolator);
        this.progressAnimator.setDuration((long)this.mProgressDuration);
        this.progressAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float progress = ((Float)animation.getAnimatedValue("progress")).floatValue();
                if (HorizontalProgressView.this.animatorUpdateListener != null) {
                    HorizontalProgressView.this.animatorUpdateListener.onProgressUpdate(progress);
                }
            }
        });
        this.progressAnimator.start();
    }

    public void stopProgressAnimation() {
        if (this.progressAnimator != null) {
            this.progressAnimator.cancel();
            this.progressAnimator = null;
        }
    }

    public void setProgressCornerRadius(int radius) {
        this.mCornerRadius = Utils.dp2px(this.mContext, radius);
        this.refreshTheView();
    }

    public void setProgressTextPaddingBottom(int offset) {
        this.mTextPaddingBottomOffset = Utils.dp2px(this.mContext, offset);
    }

    private void refreshTheView() {
        this.invalidate();
    }

    private void updateTheTrack() {
        this.mRect = new RectF((float)this.getPaddingLeft() + this.mStartProgress * (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) / 100.0f, (float)(this.getHeight() / 2 - this.getPaddingTop()), (float)(this.getWidth() - this.getPaddingRight()) * (this.moveProgress / 100.0f), (float)(this.getHeight() / 2 + this.getPaddingTop() + this.mTrackWidth));
        this.mTrackRect = new RectF((float)this.getPaddingLeft(), (float)(this.getHeight() / 2 - this.getPaddingTop()), (float)(this.getWidth() - this.getPaddingRight()), (float)(this.getHeight() / 2 + this.getPaddingTop() + this.mTrackWidth));
    }

    public void setProgressViewUpdateListener(HorizontalProgressUpdateListener listener) {
        this.animatorUpdateListener = listener;
    }

    protected static interface HorizontalProgressUpdateListener {
        public void onProgressUpdate(float var1);
    }
}

