/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.json;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.monitorjbl.json.DefaultView;
import com.monitorjbl.json.JsonViewHttpEntityMethodProcessor;
import com.monitorjbl.json.JsonViewMessageConverter;
import com.monitorjbl.json.JsonViewReturnValueHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.mvc.method.annotation.HttpEntityMethodProcessor;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestResponseBodyMethodProcessor;

public class JsonViewSupportFactoryBean
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(JsonViewSupportFactoryBean.class);
    @Autowired
    private RequestMappingHandlerAdapter adapter;
    private final JsonViewMessageConverter converter;
    private final DefaultView defaultView;

    public JsonViewSupportFactoryBean() {
        this(new ObjectMapper());
    }

    public JsonViewSupportFactoryBean(ObjectMapper mapper) {
        this(new JsonViewMessageConverter(mapper.copy()), DefaultView.create());
    }

    public JsonViewSupportFactoryBean(DefaultView defaultView) {
        this(new JsonViewMessageConverter(new ObjectMapper()), defaultView);
    }

    public JsonViewSupportFactoryBean(ObjectMapper mapper, DefaultView defaultView) {
        this(new JsonViewMessageConverter(mapper.copy()), defaultView);
    }

    private JsonViewSupportFactoryBean(JsonViewMessageConverter converter, DefaultView defaultView) {
        this.converter = converter;
        this.defaultView = defaultView;
    }

    public void afterPropertiesSet() throws Exception {
        ArrayList<HandlerMethodReturnValueHandler> handlers = new ArrayList<HandlerMethodReturnValueHandler>(this.adapter.getReturnValueHandlers());
        List<HttpMessageConverter<?>> converters = this.removeJackson(this.adapter.getMessageConverters());
        converters.add((HttpMessageConverter<?>)this.converter);
        this.adapter.setMessageConverters(converters);
        this.decorateHandlers(handlers);
        this.adapter.setReturnValueHandlers(handlers);
    }

    private List<HttpMessageConverter<?>> removeJackson(List<HttpMessageConverter<?>> converters) {
        ArrayList copy = new ArrayList(converters);
        Iterator iter = copy.iterator();
        while (iter.hasNext()) {
            HttpMessageConverter next = (HttpMessageConverter)iter.next();
            if (!(next instanceof MappingJackson2HttpMessageConverter)) continue;
            log.debug("Removing MappingJackson2HttpMessageConverter as it interferes with us");
            iter.remove();
        }
        return copy;
    }

    private void decorateHandlers(List<HandlerMethodReturnValueHandler> handlers) {
        ArrayList converters = new ArrayList(this.adapter.getMessageConverters());
        converters.add((HttpMessageConverter<?>)this.converter);
        for (HandlerMethodReturnValueHandler handler : handlers) {
            int index = handlers.indexOf(handler);
            if (handler instanceof HttpEntityMethodProcessor) {
                handlers.set(index, (HandlerMethodReturnValueHandler)new JsonViewHttpEntityMethodProcessor(converters));
                continue;
            }
            if (!(handler instanceof RequestResponseBodyMethodProcessor)) continue;
            handlers.set(index, new JsonViewReturnValueHandler(converters, this.defaultView));
            break;
        }
    }

    public <T> void registerCustomSerializer(Class<T> cls, JsonSerializer<T> forType) {
        this.converter.registerCustomSerializer(cls, forType);
    }

    public void unregisterCustomSerializer(Class<?> cls) {
        this.converter.unregisterCustomSerializer(cls);
    }
}

