/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.jdbc.AbstractParameterResultSetHandler;
import com.mockrunner.mock.jdbc.MockPreparedStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class PreparedStatementResultSetHandler
extends AbstractParameterResultSetHandler {
    private final List<MockPreparedStatement> preparedStatements = new ArrayList<MockPreparedStatement>();
    private final Map<String, List<MockPreparedStatement>> preparedStatementMap = new TreeMap<String, List<MockPreparedStatement>>();

    public void addPreparedStatement(MockPreparedStatement statement) {
        statement.setPreparedStatementResultSetHandler(this);
        List<MockPreparedStatement> list = this.preparedStatementMap.get(statement.getSQL());
        if (null == list) {
            list = new ArrayList<MockPreparedStatement>();
            this.preparedStatementMap.put(statement.getSQL(), list);
        }
        list.add(statement);
        this.preparedStatements.add(statement);
    }

    public List<MockPreparedStatement> getPreparedStatements() {
        return Collections.unmodifiableList(this.preparedStatements);
    }

    public Map<String, List<MockPreparedStatement>> getPreparedStatementMap() {
        return Collections.unmodifiableMap(this.preparedStatementMap);
    }

    public void clearPreparedStatements() {
        this.preparedStatements.clear();
        this.preparedStatementMap.clear();
    }
}

