/*
 * Decompiled with CFR 0.152.
 */
package com.mobsandgeeks.saripaar.rule;

import android.view.View;
import com.mobsandgeeks.saripaar.ContextualAnnotationRule;
import com.mobsandgeeks.saripaar.ValidationContext;
import java.lang.annotation.Annotation;
import java.util.List;

class SameValueContextualRule<CONFIRM extends Annotation, SOURCE extends Annotation, DATA_TYPE>
extends ContextualAnnotationRule<CONFIRM, DATA_TYPE> {
    private Class<SOURCE> mSourceClass;
    private Class<CONFIRM> mConfirmClass;

    protected SameValueContextualRule(ValidationContext validationContext, CONFIRM confirmAnnotation, Class<SOURCE> sourceClass) {
        super(validationContext, confirmAnnotation);
        this.mSourceClass = sourceClass;
        this.mConfirmClass = confirmAnnotation.annotationType();
    }

    @Override
    public boolean isValid(DATA_TYPE confirmValue) {
        List<View> sourceViews = this.mValidationContext.getAnnotatedViews(this.mSourceClass);
        int nSourceViews = sourceViews.size();
        if (nSourceViews == 0) {
            String message = String.format("You should have a view annotated with '%s' to use '%s'.", this.mSourceClass.getName(), this.mConfirmClass.getName());
            throw new IllegalStateException(message);
        }
        if (nSourceViews > 1) {
            String message = String.format("More than 1 field annotated with '%s'.", this.mSourceClass.getName());
            throw new IllegalStateException(message);
        }
        View view = sourceViews.get(0);
        Object sourceValue = this.mValidationContext.getData(view, this.mSourceClass);
        return confirmValue.equals(sourceValue);
    }
}

