/*
 * Decompiled with CFR 0.152.
 */
package com.mobsandgeeks.saripaar.rule;

import com.mobsandgeeks.saripaar.AnnotationRule;
import com.mobsandgeeks.saripaar.annotation.Password;
import java.util.HashMap;
import java.util.Map;

public class PasswordRule
extends AnnotationRule<Password, String> {
    private final Map<Password.Scheme, String> SCHEME_PATTERNS = new HashMap<Password.Scheme, String>(){
        {
            this.put(Password.Scheme.ANY, ".+");
            this.put(Password.Scheme.ALPHA, "\\w+");
            this.put(Password.Scheme.ALPHA_MIXED_CASE, "(?=.*[a-z])(?=.*[A-Z]).+");
            this.put(Password.Scheme.NUMERIC, "\\d+");
            this.put(Password.Scheme.ALPHA_NUMERIC, "(?=.*[a-zA-Z])(?=.*[\\d]).+");
            this.put(Password.Scheme.ALPHA_NUMERIC_MIXED_CASE, "(?=.*[a-z])(?=.*[A-Z])(?=.*[\\d]).+");
            this.put(Password.Scheme.ALPHA_NUMERIC_SYMBOLS, "(?=.*[a-zA-Z])(?=.*[\\d])(?=.*([^\\w])).+");
            this.put(Password.Scheme.ALPHA_NUMERIC_MIXED_CASE_SYMBOLS, "(?=.*[a-z])(?=.*[A-Z])(?=.*[\\d])(?=.*([^\\w])).+");
        }
    };

    protected PasswordRule(Password password) {
        super(password);
    }

    @Override
    public boolean isValid(String password) {
        boolean hasMinChars = password.length() >= ((Password)this.mRuleAnnotation).min();
        boolean matchesScheme = password.matches(this.SCHEME_PATTERNS.get((Object)((Password)this.mRuleAnnotation).scheme()));
        return hasMinChars && matchesScheme;
    }
}

