/*
 * Decompiled with CFR 0.152.
 */
package com.mobsandgeeks.saripaar;

import android.content.Context;
import android.util.Pair;
import android.view.View;
import com.mobsandgeeks.saripaar.AnnotationRule;
import com.mobsandgeeks.saripaar.Rule;
import com.mobsandgeeks.saripaar.Validator;
import com.mobsandgeeks.saripaar.adapter.ViewDataAdapter;
import com.mobsandgeeks.saripaar.annotation.ValidateUsing;
import com.mobsandgeeks.saripaar.exception.ConversionException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ValidationContext {
    Map<View, ArrayList<Pair<Rule, ViewDataAdapter>>> mViewRulesMap;
    private Context mContext;

    ValidationContext(Context context) {
        this.mContext = context;
    }

    public List<View> getAnnotatedViews(Class<? extends Annotation> saripaarAnnotation) {
        this.assertNotNull(saripaarAnnotation, "saripaarAnnotation");
        this.assertIsRegisteredAnnotation(saripaarAnnotation);
        Class<? extends AnnotationRule> annotationRuleClass = this.getRuleClass(saripaarAnnotation);
        ArrayList<View> annotatedViews = new ArrayList<View>();
        Set<View> views = this.mViewRulesMap.keySet();
        for (View view : views) {
            ArrayList<Pair<Rule, ViewDataAdapter>> ruleAdapterPairs = this.mViewRulesMap.get(view);
            for (Pair<Rule, ViewDataAdapter> ruleAdapterPair : ruleAdapterPairs) {
                boolean uniqueMatchingView = annotationRuleClass.equals(((Rule)ruleAdapterPair.first).getClass()) && !annotatedViews.contains(view);
                if (!uniqueMatchingView) continue;
                annotatedViews.add(view);
            }
        }
        return annotatedViews;
    }

    public Object getData(View view, Class<? extends Annotation> saripaarAnnotation) {
        this.assertNotNull(view, "view");
        this.assertNotNull(saripaarAnnotation, "saripaarAnnotation");
        Object data = null;
        ArrayList<Pair<Rule, ViewDataAdapter>> ruleAdapterPairs = this.mViewRulesMap.get(view);
        Class<? extends AnnotationRule> annotationRuleClass = this.getRuleClass(saripaarAnnotation);
        for (Pair<Rule, ViewDataAdapter> ruleAdapterPair : ruleAdapterPairs) {
            if (!annotationRuleClass.equals(((Rule)ruleAdapterPair.first).getClass())) continue;
            try {
                data = ((ViewDataAdapter)ruleAdapterPair.second).getData(view);
            }
            catch (ConversionException e) {
                e.printStackTrace();
            }
        }
        return data;
    }

    public Context getContext() {
        return this.mContext;
    }

    void setViewRulesMap(Map<View, ArrayList<Pair<Rule, ViewDataAdapter>>> viewRulesMap) {
        this.mViewRulesMap = viewRulesMap;
    }

    private void assertNotNull(Object object, String argumentName) {
        if (object == null) {
            String message = String.format("'%s' cannot be null.", argumentName);
            throw new IllegalArgumentException(message);
        }
    }

    private void assertIsRegisteredAnnotation(Class<? extends Annotation> saripaarAnnotation) {
        if (!Validator.isSaripaarAnnotation(saripaarAnnotation)) {
            String message = String.format("%s is not a registered Saripaar annotation.", saripaarAnnotation.getName());
            throw new IllegalArgumentException(message);
        }
    }

    private Class<? extends AnnotationRule> getRuleClass(Class<? extends Annotation> saripaarAnnotation) {
        ValidateUsing validateUsingAnnotation = saripaarAnnotation.getAnnotation(ValidateUsing.class);
        return validateUsingAnnotation.value();
    }
}

