/*
 * Decompiled with CFR 0.152.
 */
package com.mobsandgeeks.saripaar;

import android.view.View;
import com.mobsandgeeks.saripaar.AnnotationRule;
import com.mobsandgeeks.saripaar.ContextualAnnotationRule;
import com.mobsandgeeks.saripaar.ValidationContext;
import com.mobsandgeeks.saripaar.adapter.ViewDataAdapter;
import com.mobsandgeeks.saripaar.annotation.ValidateUsing;
import com.mobsandgeeks.saripaar.exception.SaripaarViolationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

final class Reflector {
    public static Method getAttributeMethod(Class<? extends Annotation> annotationType, String attributeName) {
        Method attributeMethod = null;
        try {
            attributeMethod = annotationType.getMethod(attributeName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return attributeMethod;
    }

    public static <T> T getAttributeValue(Annotation annotation, String attributeName, Class<T> attributeDataType) {
        Object attributeValue = null;
        Class<? extends Annotation> annotationType = annotation.annotationType();
        Method attributeMethod = Reflector.getAttributeMethod(annotationType, attributeName);
        if (attributeMethod == null) {
            String message = String.format("Cannot find attribute '%s' in annotation '%s'.", attributeName, annotationType.getName());
            throw new IllegalStateException(message);
        }
        try {
            Object result = attributeMethod.invoke((Object)annotation, new Object[0]);
            attributeValue = attributeDataType.isPrimitive() ? result : attributeDataType.cast(result);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return (T)attributeValue;
    }

    public static boolean isAnnotated(Class<? extends Annotation> inspected, Class<? extends Annotation> expected) {
        Annotation declaredAnnotation;
        Annotation[] declaredAnnotations;
        boolean isAnnotated = false;
        Annotation[] annotationArray = declaredAnnotations = inspected.getDeclaredAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n && !(isAnnotated = expected.equals((declaredAnnotation = annotationArray[i]).annotationType())); ++i) {
        }
        return isAnnotated;
    }

    public static Method findGetDataMethod(Class<? extends ViewDataAdapter> dataAdapterType) {
        Method[] declaredMethods;
        Method getDataMethod = null;
        for (Method method : declaredMethods = dataAdapterType.getDeclaredMethods()) {
            boolean hasSingleViewParameter;
            boolean methodNameIsGetData = "getData".equals(method.getName());
            if (!methodNameIsGetData) continue;
            int modifiers = method.getModifiers();
            boolean nonVolatile = !Modifier.isVolatile(modifiers);
            Class<?>[] parameterTypes = method.getParameterTypes();
            boolean bl = hasSingleViewParameter = parameterTypes.length == 1 && View.class.isAssignableFrom(parameterTypes[0]);
            if (!nonVolatile || !hasSingleViewParameter) continue;
            getDataMethod = method;
            break;
        }
        return getDataMethod;
    }

    public static AnnotationRule instantiateRule(Class<? extends AnnotationRule> ruleType, Annotation ruleAnnotation, ValidationContext validationContext) throws SaripaarViolationException {
        AnnotationRule rule = null;
        try {
            if (ContextualAnnotationRule.class.isAssignableFrom(ruleType)) {
                Constructor<? extends AnnotationRule> constructor = ruleType.getDeclaredConstructor(ValidationContext.class, ruleAnnotation.annotationType());
                constructor.setAccessible(true);
                rule = constructor.newInstance(validationContext, ruleAnnotation);
            } else if (AnnotationRule.class.isAssignableFrom(ruleType)) {
                Constructor<? extends AnnotationRule> constructor = ruleType.getDeclaredConstructor(ruleAnnotation.annotationType());
                constructor.setAccessible(true);
                rule = constructor.newInstance(ruleAnnotation);
            }
        }
        catch (NoSuchMethodException e) {
            String message = Reflector.getMissingConstructorErrorMessage(ruleType, ruleAnnotation.annotationType());
            throw new SaripaarViolationException(message);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return rule;
    }

    public static Class<?> getRuleDataType(Annotation ruleAnnotation) {
        ValidateUsing validateUsing = Reflector.getValidateUsingAnnotation(ruleAnnotation.annotationType());
        return Reflector.getRuleDataType(validateUsing);
    }

    public static Class<?> getRuleDataType(ValidateUsing validateUsing) {
        Class<? extends AnnotationRule> rule = validateUsing.value();
        Method[] methods = rule.getDeclaredMethods();
        return Reflector.getRuleTypeFromIsValidMethod(rule, methods);
    }

    private static ValidateUsing getValidateUsingAnnotation(Class<? extends Annotation> annotationType) {
        Annotation[] declaredAnnotations;
        ValidateUsing validateUsing = null;
        for (Annotation annotation : declaredAnnotations = annotationType.getDeclaredAnnotations()) {
            if (!ValidateUsing.class.equals(annotation.annotationType())) continue;
            validateUsing = (ValidateUsing)annotation;
            break;
        }
        return validateUsing;
    }

    private static String getMissingConstructorErrorMessage(Class<? extends AnnotationRule> ruleType, Class<? extends Annotation> annotationType) {
        String message = null;
        if (ContextualAnnotationRule.class.isAssignableFrom(ruleType)) {
            message = String.format("A constructor accepting a '%s' and a '%s' is required for %s.", ValidationContext.class, annotationType.getName(), ruleType.getClass().getName());
        } else if (AnnotationRule.class.isAssignableFrom(ruleType)) {
            message = String.format("'%s' should have a single-argument constructor that accepts a '%s' instance.", ruleType.getName(), annotationType.getName());
        }
        return message;
    }

    private static Class<?> getRuleTypeFromIsValidMethod(Class<? extends AnnotationRule> rule, Method[] methods) {
        Class<?> returnType = null;
        for (Method method : methods) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (!Reflector.matchesIsValidMethodSignature(method, parameterTypes)) continue;
            if (returnType != null) {
                String message = String.format("Found duplicate 'boolean isValid(T)' method signature in '%s'.", rule.getName());
                throw new SaripaarViolationException(message);
            }
            returnType = parameterTypes[0];
        }
        return returnType;
    }

    private static boolean matchesIsValidMethodSignature(Method method, Class<?>[] parameterTypes) {
        int modifiers = method.getModifiers();
        boolean isPublic = Modifier.isPublic(modifiers);
        boolean nonVolatile = !Modifier.isVolatile(modifiers);
        boolean returnsBoolean = Boolean.TYPE.equals(method.getReturnType());
        boolean matchesMethodName = "isValid".equals(method.getName());
        boolean hasSingleParameter = parameterTypes.length == 1;
        return isPublic && nonVolatile && returnsBoolean && matchesMethodName && hasSingleParameter;
    }

    private Reflector() {
    }
}

