/*
 * Decompiled with CFR 0.152.
 */
package com.mobsandgeeks.saripaar;

import android.content.Context;
import android.util.Log;
import android.view.View;
import android.widget.Checkable;
import android.widget.Spinner;
import android.widget.TextView;
import com.mobsandgeeks.saripaar.Rule;
import com.mobsandgeeks.saripaar.Rules;
import com.mobsandgeeks.saripaar.annotation.Checked;
import com.mobsandgeeks.saripaar.annotation.ConfirmPassword;
import com.mobsandgeeks.saripaar.annotation.Email;
import com.mobsandgeeks.saripaar.annotation.IpAddress;
import com.mobsandgeeks.saripaar.annotation.NumberRule;
import com.mobsandgeeks.saripaar.annotation.Password;
import com.mobsandgeeks.saripaar.annotation.Regex;
import com.mobsandgeeks.saripaar.annotation.Required;
import com.mobsandgeeks.saripaar.annotation.Select;
import com.mobsandgeeks.saripaar.annotation.TextRule;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;

class AnnotationRuleFactory {
    static final String TAG = "AnnotationToRuleConverter";
    static final String WARN_TEXT = "%s - @%s can only be applied to TextView and its subclasses.";
    static final String WARN_CHECKABLE = "%s - @%s can only be applied to Checkable, its implementations and subclasses.";
    static final String WARN_SPINNER = "%s - @%s can only be applied to Spinner, its implementations and subclasses.";

    AnnotationRuleFactory() {
    }

    public static Rule<?> getRule(Field field, View view, Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (Checked.class.equals(annotationType)) {
            return AnnotationRuleFactory.getCheckedRule(field, view, (Checked)annotation);
        }
        if (Required.class.equals(annotationType)) {
            return AnnotationRuleFactory.getRequiredRule(field, view, (Required)annotation);
        }
        if (TextRule.class.equals(annotationType)) {
            return AnnotationRuleFactory.getTextRule(field, view, (TextRule)annotation);
        }
        if (Regex.class.equals(annotationType)) {
            return AnnotationRuleFactory.getRegexRule(field, view, (Regex)annotation);
        }
        if (NumberRule.class.equals(annotationType)) {
            return AnnotationRuleFactory.getNumberRule(field, view, (NumberRule)annotation);
        }
        if (Password.class.equals(annotationType)) {
            return AnnotationRuleFactory.getPasswordRule(field, view, (Password)annotation);
        }
        if (Email.class.equals(annotationType)) {
            return AnnotationRuleFactory.getEmailRule(field, view, (Email)annotation);
        }
        if (IpAddress.class.equals(annotationType)) {
            return AnnotationRuleFactory.getIpAddressRule(field, view, (IpAddress)annotation);
        }
        if (Select.class.equals(annotationType)) {
            return AnnotationRuleFactory.getSelectRule(field, view, (Select)annotation);
        }
        return null;
    }

    private static Rule<Spinner> getSelectRule(Field field, View view, Select select) {
        if (!Spinner.class.isAssignableFrom(view.getClass())) {
            Log.w((String)TAG, (String)String.format(WARN_SPINNER, field.getName(), Spinner.class.getSimpleName()));
            return null;
        }
        int messageResId = select.messageResId();
        String message = messageResId != 0 ? view.getContext().getString(messageResId) : select.message();
        int unexpectedSelection = select.defaultSelection();
        return Rules.spinnerNotEq(message, unexpectedSelection);
    }

    public static Rule<?> getRule(Field field, View view, Annotation annotation, Object ... params) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (ConfirmPassword.class.equals(annotationType)) {
            TextView passwordTextView = (TextView)params[0];
            return AnnotationRuleFactory.getConfirmPasswordRule(field, view, (ConfirmPassword)annotation, passwordTextView);
        }
        return params == null || params.length == 0 ? AnnotationRuleFactory.getRule(field, view, annotation) : null;
    }

    private static Rule<TextView> getRequiredRule(Field field, View view, Required required) {
        if (!TextView.class.isAssignableFrom(view.getClass())) {
            Log.w((String)TAG, (String)String.format(WARN_TEXT, field.getName(), Required.class.getSimpleName()));
            return null;
        }
        int messageResId = required.messageResId();
        String message = messageResId != 0 ? view.getContext().getString(messageResId) : required.message();
        return Rules.required(message, required.trim());
    }

    private static Rule<View> getTextRule(Field field, View view, TextRule textRule) {
        String message;
        if (!TextView.class.isAssignableFrom(view.getClass())) {
            Log.w((String)TAG, (String)String.format(WARN_TEXT, field.getName(), TextRule.class.getSimpleName()));
            return null;
        }
        ArrayList<Rule<TextView>> rules = new ArrayList<Rule<TextView>>();
        int messageResId = textRule.messageResId();
        String string = message = messageResId != 0 ? view.getContext().getString(messageResId) : textRule.message();
        if (textRule.minLength() > 0) {
            rules.add(Rules.minLength(null, textRule.minLength(), textRule.trim()));
        }
        if (textRule.maxLength() != Integer.MAX_VALUE) {
            rules.add(Rules.maxLength(null, textRule.maxLength(), textRule.trim()));
        }
        Rule[] ruleArray = new Rule[rules.size()];
        rules.toArray(ruleArray);
        return Rules.and(message, ruleArray);
    }

    private static Rule<TextView> getRegexRule(Field field, View view, Regex regexRule) {
        if (!TextView.class.isAssignableFrom(view.getClass())) {
            Log.w((String)TAG, (String)String.format(WARN_TEXT, field.getName(), Regex.class.getSimpleName()));
            return null;
        }
        Context context = view.getContext();
        int messageResId = regexRule.messageResId();
        String message = messageResId != 0 ? context.getString(messageResId) : regexRule.message();
        int patternResId = regexRule.patternResId();
        String pattern = patternResId != 0 ? view.getContext().getString(patternResId) : regexRule.pattern();
        return Rules.regex(message, pattern, regexRule.trim());
    }

    private static Rule<View> getNumberRule(Field field, View view, NumberRule numberRule) {
        double number;
        if (!TextView.class.isAssignableFrom(view.getClass())) {
            Log.w((String)TAG, (String)String.format(WARN_TEXT, field.getName(), NumberRule.class.getSimpleName()));
            return null;
        }
        if (numberRule.type() == null) {
            throw new IllegalArgumentException(String.format("@%s.type() cannot be null.", NumberRule.class.getSimpleName()));
        }
        ArrayList<Rule<TextView>> rules = new ArrayList<Rule<TextView>>();
        int messageResId = numberRule.messageResId();
        String message = messageResId != 0 ? view.getContext().getString(messageResId) : numberRule.message();
        switch (numberRule.type()) {
            case INTEGER: 
            case LONG: {
                Rules.regex(null, "\\d+", true);
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                Rules.regex(null, "[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?", true);
            }
        }
        if (numberRule.lt() != Double.MIN_VALUE) {
            String ltNumber = String.valueOf(numberRule.lt());
            number = Double.parseDouble(ltNumber);
            switch (numberRule.type()) {
                case INTEGER: {
                    rules.add(Rules.lt(null, (int)number));
                    break;
                }
                case LONG: {
                    rules.add(Rules.lt(null, (long)number));
                    break;
                }
                case FLOAT: {
                    rules.add(Rules.lt(null, Float.parseFloat(ltNumber)));
                    break;
                }
                case DOUBLE: {
                    rules.add(Rules.lt(null, Double.parseDouble(ltNumber)));
                }
            }
        }
        if (numberRule.gt() != Double.MAX_VALUE) {
            String gtNumber = String.valueOf(numberRule.gt());
            number = Double.parseDouble(gtNumber);
            switch (numberRule.type()) {
                case INTEGER: {
                    rules.add(Rules.gt(null, (int)number));
                    break;
                }
                case LONG: {
                    rules.add(Rules.gt(null, (long)number));
                    break;
                }
                case FLOAT: {
                    rules.add(Rules.gt(null, Float.parseFloat(gtNumber)));
                    break;
                }
                case DOUBLE: {
                    rules.add(Rules.gt(null, Double.parseDouble(gtNumber)));
                }
            }
        }
        if (numberRule.eq() != Double.MAX_VALUE) {
            String eqNumber = String.valueOf(numberRule.eq());
            number = Double.parseDouble(eqNumber);
            switch (numberRule.type()) {
                case INTEGER: {
                    rules.add(Rules.eq(null, (int)number));
                    break;
                }
                case LONG: {
                    rules.add(Rules.eq(null, (long)number));
                    break;
                }
                case FLOAT: {
                    rules.add(Rules.eq(null, Float.parseFloat(eqNumber)));
                    break;
                }
                case DOUBLE: {
                    rules.add(Rules.eq(null, Double.parseDouble(eqNumber)));
                }
            }
        }
        Rule[] ruleArray = new Rule[rules.size()];
        rules.toArray(ruleArray);
        return Rules.and(message, ruleArray);
    }

    private static Rule<TextView> getPasswordRule(Field field, View view, Password password) {
        if (!TextView.class.isAssignableFrom(view.getClass())) {
            Log.w((String)TAG, (String)String.format(WARN_TEXT, field.getName(), Password.class.getSimpleName()));
            return null;
        }
        int messageResId = password.messageResId();
        String message = messageResId != 0 ? view.getContext().getString(messageResId) : password.message();
        return Rules.required(message, false);
    }

    private static Rule<TextView> getConfirmPasswordRule(Field field, View view, ConfirmPassword confirmPassword, TextView passwordTextView) {
        if (!TextView.class.isAssignableFrom(view.getClass())) {
            Log.w((String)TAG, (String)String.format(WARN_TEXT, field.getName(), ConfirmPassword.class.getSimpleName()));
            return null;
        }
        int messageResId = confirmPassword.messageResId();
        String message = messageResId != 0 ? view.getContext().getString(messageResId) : confirmPassword.message();
        return Rules.eq(message, passwordTextView);
    }

    private static Rule<View> getEmailRule(Field field, View view, Email email) {
        if (!TextView.class.isAssignableFrom(view.getClass())) {
            Log.w((String)TAG, (String)String.format(WARN_TEXT, field.getName(), Regex.class.getSimpleName()));
            return null;
        }
        int messageResId = email.messageResId();
        String message = messageResId != 0 ? view.getContext().getString(messageResId) : email.message();
        return Rules.or(message, Rules.eq(null, ""), Rules.regex(message, "^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$", true));
    }

    private static Rule<View> getIpAddressRule(Field field, View view, IpAddress ipAddress) {
        if (!TextView.class.isAssignableFrom(view.getClass())) {
            Log.w((String)TAG, (String)String.format(WARN_TEXT, field.getName(), IpAddress.class.getSimpleName()));
            return null;
        }
        int messageResId = ipAddress.messageResId();
        String message = messageResId != 0 ? view.getContext().getString(messageResId) : ipAddress.message();
        return Rules.or(message, Rules.eq(null, ""), Rules.regex(message, "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$", true));
    }

    private static Rule<Checkable> getCheckedRule(Field field, View view, Checked checked) {
        if (!Checkable.class.isAssignableFrom(view.getClass())) {
            Log.w((String)TAG, (String)String.format(WARN_CHECKABLE, field.getName(), Checked.class.getSimpleName()));
            return null;
        }
        int messageResId = checked.messageResId();
        String message = messageResId != 0 ? view.getContext().getString(messageResId) : checked.message();
        return Rules.checked(message, checked.checked());
    }
}

