package com.mobgame.gui.floatbutton;

import java.util.Calendar;

import android.animation.Animator;
import android.animation.Animator.AnimatorListener;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.DialogFragment;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.PixelFormat;
import android.os.Handler;
import android.support.v4.content.LocalBroadcastManager;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver.OnGlobalLayoutListener;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.OvershootInterpolator;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.RelativeLayout.LayoutParams;
import android.widget.TextView;

import com.mobgame.R;
import com.mobgame.component.GameConfigManager;
import com.mobgame.component.GoogleAnalyticsManager;
import com.mobgame.model.MobMenuItem;
import com.mobgame.utils.Constants;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Res;
import com.mobgame.utils.Utils;

@SuppressLint({ "InflateParams", "ClickableViewAccessibility" })
public class MobGameOverlayView {

//	private static String TAG = MobFloatOverlayView.class.getSimpleName();
	private static final int ANIMAION_TIME_ROTATE = 800;
	private static final int ANIMAION_TIME_FADE_OUT = 400;
	private static final int ANIMAION_TIME_FADE_IN = 400;
	private static final int IDLE_TIME = 6000;
	private static final int IDLE_TIME2 = 2000;

	private Activity activity;
	private View rootView, layoutBottom, layoutFloat;/*, layoutMenu*/
	private TextView txtDismiss;
//	FloatMenu smartMenu;
	private Handler idleHandler = new Handler();
	private MobGameFloatGestureView floatArea;
	private ImageView floatButton, floatButtonNtf;
	private MobGameFloatMenuView floatMenu;
//	View floatMenu, floatMenuBackground;
//	ArrayList<MobFloatMenuModel> floatMenuitems = new ArrayList<MobFloatMenuModel>();

	private boolean isInit;
	private boolean isShowingMenu;
	private boolean isOutsideBottomArea;
	// Screen
	private int boundWidth, boundHeight;
	private int relativePositionOnScreen;
	private int statusBarHeight;
//	private int screenWidth, screenHeight;
	private float density;
	
	private boolean isShowDialogAgain;

	public MobGameOverlayView(Activity a) {
		activity = a;
		floatMenu = new MobGameFloatMenuView(activity);
		floatArea = new MobGameFloatGestureView(activity);

		density = DeviceUtils.getDensity(a);
//		screenWidth = DeviceUtils.getScreenWidthInPixels(a);
//		screenHeight = DeviceUtils.getScreenHeightInPixels(a);
		statusBarHeight = DeviceUtils.getStatusBarHeightInPixels(activity);

		attachView();
		initView();
		hide();
	}

	public void attachView() {
		rootView = LayoutInflater.from(activity).inflate(R.layout.float_overlay_view, null);
		WindowManager windowManager = (WindowManager) activity.getApplicationContext()
				.getSystemService(Activity.WINDOW_SERVICE);
		WindowManager.LayoutParams params = new WindowManager.LayoutParams(
				WindowManager.LayoutParams.MATCH_PARENT,
				WindowManager.LayoutParams.MATCH_PARENT, 
				WindowManager.LayoutParams.TYPE_PHONE,
				WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE, 
				PixelFormat.TRANSPARENT);
		params.gravity = Gravity.LEFT | Gravity.TOP;
		params.flags = WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE
			| WindowManager.LayoutParams.FLAG_NOT_TOUCH_MODAL
		    | WindowManager.LayoutParams.FLAG_NOT_TOUCHABLE;
		windowManager.addView(rootView, params);
		rootView.getViewTreeObserver().addOnGlobalLayoutListener(new OnGlobalLayoutListener() {

			@SuppressLint("NewApi")
		    public void onGlobalLayout() {

				if (rootView != null) {
					boundWidth = rootView.getWidth();
					boundHeight = rootView.getHeight();
					floatArea.setMovableWidth(boundWidth);
					floatArea.setMovableHeight(boundHeight);

			        int[] locations = new int[2];
			        rootView.getLocationOnScreen(locations);
			        relativePositionOnScreen = locations[1];
			        
			        if (!isInit) {
			        	isInit = true;
			        	floatArea.moveTo(0, boundHeight / 2);
			        }

//			        if (Build.VERSION.SDK_INT < 16) {
//						rootView.getViewTreeObserver().removeGlobalOnLayoutListener(this);
//					} else {
//						rootView.getViewTreeObserver().removeOnGlobalLayoutListener(this);
//					}
				}
		    }
		});
	}

	public void initView() {
		layoutBottom = rootView.findViewById(R.id.layout_bottom);
		layoutFloat = rootView.findViewById(R.id.layout_float);
//		layoutMenu = rootView.findViewById(R.id.layout_menu);
		txtDismiss = (TextView) rootView.findViewById(R.id.txt_dismiss);
		floatButton = (ImageView) rootView.findViewById(R.id.img_float);
		floatButtonNtf = (ImageView) rootView.findViewById(R.id.img_float_ntf);
//		floatMenu = rootView.findViewById(R.id.float_menu);
//		floatMenuBackground = rootView.findViewById(R.id.img_menu_background);
		
		int imgRes = Res.drawableResource(activity, R.drawable.float_button);
		floatButton.setImageResource(imgRes);

		floatMenu.setEventListener(mMenuEventListener);
		floatArea.setEventListener(mButtonEventListener);
		floatArea.moveTo(0, boundHeight / 2);
		
		txtDismiss.setText(Res.string(activity, R.string.dismiss));
		
		layoutBottom.setY(boundHeight + statusBarHeight - relativePositionOnScreen - 125 * density);
	}

	public void fadeOut(boolean isAnimated) {
		int buttonSize = floatArea.getSizeInPixels(); 
		int newX = boundWidth - buttonSize / 2;
		if (layoutFloat.getX() <= boundWidth / 2) {
			RelativeLayout.LayoutParams lp = (LayoutParams) floatButtonNtf.getLayoutParams();
			lp.addRule(RelativeLayout.ALIGN_PARENT_LEFT, 0);
			lp.addRule(RelativeLayout.ALIGN_PARENT_RIGHT, RelativeLayout.TRUE);
			floatButtonNtf.setLayoutParams(lp);
			newX = -buttonSize / 2;
		} else {
			RelativeLayout.LayoutParams lp = (LayoutParams) floatButtonNtf.getLayoutParams();
			lp.addRule(RelativeLayout.ALIGN_PARENT_LEFT, RelativeLayout.TRUE);
			lp.addRule(RelativeLayout.ALIGN_PARENT_RIGHT, 0);
			floatButtonNtf.setLayoutParams(lp);
		}
		
		if (isAnimated) {
			layoutFloat.animate()
				.setDuration(ANIMAION_TIME_FADE_OUT)
				.setInterpolator(new OvershootInterpolator(1f))
//				.alpha(0.5f)
				.x(newX);
		} else {
//			layoutFloat.setAlpha(0.5f);
			layoutFloat.setX(newX);
		}
		idleHandler.postDelayed(mIdleRunnable2, IDLE_TIME2);
	}
	
	public void fadeOut2(boolean isAnimated) {		
		if (isAnimated) {
			layoutFloat.animate()
				.setDuration(ANIMAION_TIME_FADE_OUT)
				.setInterpolator(new OvershootInterpolator(1f))
				.alpha(0.5f);
		} else {
			layoutFloat.setAlpha(0.5f);
		}
	}

	public void fadeIn(boolean isAnimated) {
		idleHandler.removeCallbacksAndMessages(null);

		if (isAnimated) {
			layoutFloat.animate()
				.setDuration(ANIMAION_TIME_FADE_IN)
				.setInterpolator(new OvershootInterpolator(1f))
				.alpha(1f);
		} else {
			layoutFloat.setAlpha(1f);
		}
	}

	private Runnable mIdleRunnable = new Runnable() {

		@Override
		public void run() {
			if (!isShowingMenu) {
				fadeOut(true);
			} else {
				hideMenu();
				idleHandler.postDelayed(mIdleRunnable, IDLE_TIME);
			}
		}
	};
	
	private Runnable mIdleRunnable2 = new Runnable() {

		@Override
		public void run() {
			fadeOut2(true);
		}
	};

	private MobGameFloatGestureView.EventListener mButtonEventListener = new MobGameFloatGestureView.EventListener() {

		@Override
		public void onTouchDown(MotionEvent event) {
			isOutsideBottomArea = true;
			fadeIn(false);
		}

		@Override
		public void onTouchMove(MotionEvent event) {
			hideMenu();
			if (isInBottomArea(event.getRawX(), event.getRawY())) {
				if (isOutsideBottomArea) {
					showLayoutBottom();
				}
				isOutsideBottomArea = false;
			} else {
				if (!isOutsideBottomArea) {
					hideLayoutBottom();
				}
				isOutsideBottomArea = true;
			}
			if (isInDismissArea(event.getRawX(), event.getRawY())) {

				txtDismiss.setCompoundDrawablesWithIntrinsicBounds(0, R.drawable.float_hide_active, 0, 0);
				txtDismiss.setTextColor(Color.rgb(194, 39, 45));
			} else {

				txtDismiss.setCompoundDrawablesWithIntrinsicBounds(0, R.drawable.float_hide_normal, 0, 0);
				txtDismiss.setTextColor(Color.rgb(255, 255, 255));
			}
		}

		@Override
		public void onTouchUp(MotionEvent event) {
			idleHandler.removeCallbacksAndMessages(null);
			idleHandler.postDelayed(mIdleRunnable, IDLE_TIME);

			hideLayoutBottom();
			floatArea.moveToEdge(true);

			if (event != null) {
				if (isInDismissArea(event.getRawX(), event.getRawY())) {
					isShowDialogAgain = Preference.getBoolean(activity, 
							Constants.SHARED_PREF_FLOAT_BUTTON_SHOW_DIALOG, true);
					if (isShowDialogAgain) {
						showConfirmDialog();
					}

					layoutFloat.setVisibility(View.GONE);
					floatArea.hide();
					hideMenu();
					
//					Calendar c = Calendar.getInstance(); 
//					int dismissTime = c.get(Calendar.DAY_OF_YEAR);
					long dismissTime = Calendar.getInstance().getTimeInMillis();
					Preference.save(activity, 
							Constants.SHARED_PREF_FLOAT_BUTTON_DISMISS_TIME, dismissTime);
				}
			}
		}

		@Override
		public void onClick(MotionEvent event) {
			if (isShowingMenu) {
				hideMenu();
			} else {
				showMenu();
			}
		}

		@Override
		public void onMove(int x, int y) {
			//y = y - floatArea.getSizeInPixels() / 2;
			x = Math.max(0, Math.min(boundWidth - floatArea.getSizeInPixels(), x));
			y = Math.max(0, Math.min(boundHeight - relativePositionOnScreen - floatArea.getSizeInPixels(), y));

			layoutFloat.setX(x);
			layoutFloat.setY(y);
		}
	};

	private MobGameFloatMenuView.EventListener mMenuEventListener = new MobGameFloatMenuView.EventListener() {

		@Override
		public void onShow() {
			idleHandler.removeCallbacksAndMessages(null);
			idleHandler.postDelayed(mIdleRunnable, IDLE_TIME);

			floatButton.animate()
				.setDuration(ANIMAION_TIME_ROTATE)
				.setInterpolator(new OvershootInterpolator(1f))
				.rotation(90f)
				.setListener(new AnimatorListener() {
					
					@Override
					public void onAnimationStart(Animator anim) {}
					
					@Override
					public void onAnimationRepeat(Animator anim) {}
					
					@Override
					public void onAnimationEnd(Animator anim) {
						isShowingMenu = true;
					}
					
					@Override
					public void onAnimationCancel(Animator anim) {}
				});
		}
		
		@Override
		public void onHide() {
			idleHandler.removeCallbacksAndMessages(null);
			idleHandler.postDelayed(mIdleRunnable, IDLE_TIME);

			hideLayoutBottom();
			floatArea.moveToEdge(true);
			
			floatButton.animate()
				.setDuration(ANIMAION_TIME_ROTATE)
				.setInterpolator(new OvershootInterpolator(1f))
				.rotation(0f)
				.setListener(new AnimatorListener() {
					
					@Override
					public void onAnimationStart(Animator arg0) {}
					
					@Override
					public void onAnimationRepeat(Animator arg0) {}
					
					@Override
					public void onAnimationEnd(Animator arg0) {
						isShowingMenu = false;
					}
					
					@Override
					public void onAnimationCancel(Animator arg0) {}
				});
		}

		@Override
		public void onClick(View v, MobMenuItem menuItem) {
			hideMenu();

			GoogleAnalyticsManager.getInstance().trackEvent(
				"Float icon", 
				"button_press", 
				menuItem.getLabel(), 
				1);
			
			Intent intent = new Intent(Constants.INTENT_FILTER);
			intent.putExtra("category", menuItem.getCommand());
			intent.putExtra("data", menuItem.getParams());
			LocalBroadcastManager.getInstance(activity.getApplicationContext())
				.sendBroadcast(intent);
		}

	};
	
	public void showMenu() {
		fadeIn(true);
		int floatY = floatArea.getY() - relativePositionOnScreen;
		int x = floatArea.getSizeInPixels();
		int y = Math.min(boundHeight - relativePositionOnScreen, floatY);
		if (floatMenu == null) {
			floatMenu = new MobGameFloatMenuView(activity);
		}
		if (floatArea.getX() > boundWidth / 2) {
			floatMenu.showInReverse(x, y, true);
		} else {
			floatMenu.show(x, y, true);
		}
	}

	public void hideMenu() {
		if (floatMenu != null) {
			floatMenu.hide();
		}
	}
	
	public void updateMenu() {
		if (floatMenu != null) {
			floatMenu.updateMenu();
		}
	}

	private boolean isInBottomArea(float left, float top) {
		int dY = (int) (boundHeight - 150 * density);
		return top >= dY || isInDismissArea(left, top);
	}

	private boolean isInDismissArea(float left, float top) {
		int dX = boundWidth / 2;
		int dY = (int) (boundHeight - 100 * density);
		double distance = Math.sqrt(Math.pow(left - dX, 2) + Math.pow(top - dY, 2));
		double maxDistance = Math.min(120 * density, boundWidth / 5);

		return distance <= maxDistance
			|| (top >= dY && left >= dX - maxDistance && left <= dX + maxDistance);
	}

	private void showLayoutBottom() {
		layoutBottom.setVisibility(View.VISIBLE);
		layoutBottom.animate()
			.setDuration(200)
			.y(boundHeight + statusBarHeight - relativePositionOnScreen - 125 * density);
	}

	private void hideLayoutBottom() {
		layoutBottom.animate()
			.setDuration(200)
			.y(boundHeight + statusBarHeight - relativePositionOnScreen);
	}

	DialogFragment dialog = null;
	public void showConfirmDialog() {
		try {
			dialog = new MobGameFloatConfirmDialog(activity, new MobGameFloatConfirmDialog.EventListener() {
	
				@Override
				public void onConfirmClick(View v) {
					Preference.save(activity, 
							Constants.SHARED_PREF_FLOAT_BUTTON_SHOW_DIALOG, isShowDialogAgain);
					Preference.save(activity, 
							Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, false);
					layoutFloat.setVisibility(View.GONE);
					floatArea.hide();
					hideMenu();
					hideConfirmDialog();
				}
	
				@Override
				public void onCancelClick(View v) {
					Preference.save(activity, 
							Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, false);
					layoutFloat.setVisibility(View.GONE);
					floatArea.hide();
					hideMenu();
					hideConfirmDialog();
				}
	
				@Override
				public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
					isShowDialogAgain = !isChecked;
				}
			});
			dialog.show(activity.getFragmentManager(), "tag_fragment_confirm");
		} catch (Exception e) {
			hideConfirmDialog();
		}
	}

	public void hideConfirmDialog() {
		if (dialog != null && dialog.isAdded()) {
			dialog.dismiss();
			dialog = null;
		}
	}

	public void show() {
		if (Utils.hasNtf(activity)) {
			floatButtonNtf.setVisibility(View.VISIBLE);
		} else {
			floatButtonNtf.setVisibility(View.GONE);
		}
		layoutFloat.setVisibility(View.VISIBLE);
		layoutBottom.setVisibility(View.GONE);
		floatArea.show();
		floatArea.moveTo(0, boundHeight / 2);
		hideConfirmDialog();
		fadeIn(false);
		idleHandler.removeCallbacksAndMessages(null);
		idleHandler.postDelayed(mIdleRunnable, IDLE_TIME);
	}

//	public void show(int x, int y) {
//		if (Utils.hasNtf(activity)) {
//			floatButtonNtf.setVisibility(View.VISIBLE);
//		} else {
//			floatButtonNtf.setVisibility(View.GONE);
//		}
//		layoutFloat.setVisibility(View.VISIBLE);
//		layoutBottom.setVisibility(View.GONE);
//		floatArea.show();
//		floatArea.moveTo(x, y);
//		hideConfirmDialog();
//		fadeIn(false);
//		idleHandler.removeCallbacksAndMessages(null);
//		idleHandler.postDelayed(mIdleRunnable, IDLE_TIME);
//	}

	public void hide() {
		hideMenu();
		layoutFloat.setVisibility(View.GONE);
		layoutBottom.setVisibility(View.GONE);
		floatArea.hide();
	}
	
	public void viberate() {
		if(Preference.getBoolean(activity, Constants.SHARED_PREF_HIDE_FLOAT_BUTTON, true)){
			show();
		}
//		if (Utils.hasNtf(activity)) {
//			floatButtonNtf.setVisibility(View.VISIBLE);
//		} else {
//			floatButtonNtf.setVisibility(View.GONE);
//		}
		Animation viberate = AnimationUtils.loadAnimation(activity, R.anim.viberate);
		floatButton.startAnimation(viberate);
		GameConfigManager.getInstance().setHasUnreadNotifications(false);
	}
	
	public boolean isShowing() {
		return layoutFloat.getVisibility() == View.VISIBLE;
	}

	public boolean isShowingConfirmDialog() {
		return dialog != null && dialog.isVisible();
	}

	public void dismiss() {
		try {
			rootView.setVisibility(View.GONE);
			WindowManager windowManager = (WindowManager) activity.getApplicationContext().getSystemService(
					Activity.WINDOW_SERVICE);
			windowManager.removeView(rootView);
			if (floatMenu != null) {
				floatMenu.dismiss();
			}
			if (floatArea != null) {
				floatArea.dismiss();
			}
			rootView = null;
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public int getFloatButtonX() {
		return floatArea.getX();
	}

	public int getFloatButtonY() {
		return floatArea.getY();
	}

}
