package com.mobgame.gui;

import android.animation.Animator;
import android.animation.Animator.AnimatorListener;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.v13.app.FragmentPagerAdapter;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.view.ViewPager.SimpleOnPageChangeListener;
import android.support.v4.widget.DrawerLayout;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ImageSpan;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.ArrayAdapter;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.RelativeLayout.LayoutParams;
import android.widget.TextView;
import android.widget.Toast;

import com.bumptech.glide.Glide;
import com.facebook.FacebookSdk;
import com.mobgame.MobGameSDK;
import com.mobgame.R;
import com.mobgame.component.GameConfigManager;
import com.mobgame.component.GoogleAnalyticsManager;
import com.mobgame.model.MobMenu;
import com.mobgame.model.MobMenuItem;
import com.mobgame.utils.Constants;
import com.mobgame.utils.DeviceUtils;
import com.mobgame.utils.Res;
import com.mobgame.utils.Utils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

//import com.mobgame.ads.OfferWall;

public class MobGameActivity extends Activity {

	private static String TAG = MobGameActivity.class.getSimpleName();
	public static String KEY_DATA = "data";
	public static String KEY_ENABLE_AUTOHIDE_HEADER_BAR = "autohide_header_bar";
	public static String KEY_ENABLE_SIDE_MENU = "enable_side_menu";
	
	public static boolean shouldReload = false;
	
	private DrawerLayout layoutRoot;
	private View layoutMain, layoutHeader, layoutContent, layoutDrawer;
	private TextView txtTitle, txtVersion;
	private ImageButton btnMenu, btnBack, btnShare, btnClose;
	private ProgressBar prgBar;
	private ListView lvDrawer;
	private SideMenuAdapter lvAdapter;
	private MobGamePagerFragment fragContent;
	private MobPagerAdapter adapter;

	private float density;

	private int currentPage;
	private boolean isEnableAutohideHeaderBar = false, isEnableSideMenu = true;
	private boolean isScrollAnimating;
	private boolean isLockingHeaderBar;


	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_mob);

		FacebookSdk.sdkInitialize(getApplicationContext());

		Bundle bundle = getIntent().getExtras();
		if (bundle != null) {
			isEnableAutohideHeaderBar = bundle.getBoolean(KEY_ENABLE_AUTOHIDE_HEADER_BAR, true);
			isEnableSideMenu = bundle.getBoolean(KEY_ENABLE_SIDE_MENU, true);
		}

		layoutRoot = (DrawerLayout) findViewById(R.id.layout_root);
		layoutDrawer = findViewById(R.id.left_drawer);
		layoutMain = findViewById(R.id.layout_main);
		layoutHeader = findViewById(R.id.layout_header);
		layoutContent = findViewById(R.id.layout_content);

		lvDrawer = (ListView) findViewById(R.id.left_drawer_lv);
		prgBar = (ProgressBar) findViewById(R.id.progress_bar);
		txtTitle = (TextView) findViewById(R.id.txt_title);
		txtVersion = (TextView) findViewById(R.id.txt_version);
		btnMenu = (ImageButton) findViewById(R.id.btn_menu);
		btnBack = (ImageButton) findViewById(R.id.btn_back);
		btnShare = (ImageButton) findViewById(R.id.btn_share);
		btnClose = (ImageButton) findViewById(R.id.btn_close);

		density = DeviceUtils.getDensity(this);

		txtVersion.setText("Game version: " + Utils.getGameVersion(this) + "\n"
				+ "SDK version: " + Utils.getSDKVersion(this));
		
		initHeaderBar();
		initSideMenu();
		//lay du lieu deeplink
		Intent intentDeepLink = this.getIntent();
		MobGameSDK.getInstance().onHandleIntent(intentDeepLink);
		// CONTENT
		fragContent = MobGamePagerFragment.newInstance(this);
		fragContent.addOnPageChangeListener(mOnPageChangeListener);
		fragContent.setWebEventListener(mWebEventListener);

		FragmentManager fm = getFragmentManager();
		FragmentTransaction ft = fm.beginTransaction();
		ft.add(layoutContent.getId(), fragContent , "fragment_web");
//		Log.e("ABC", "abc:" + layoutContent.getId() + " ,"+ layoutContent.getTag());
		ft.commit();

		try {
			String data = getIntent().getExtras().getString(KEY_DATA);
//			Log.d(TAG, "data:" + data);
			JSONArray items = new JSONArray(data);
			loadUrls(items);
		} catch (Exception e) {
			try {
				performOnItemClick(0);
			} catch (IndexOutOfBoundsException e1) {}
		}
//		offerWall = new OfferWall(this);
	}


	@Override
	protected void onResume() {
		super.onResume();
		LocalBroadcastManager.getInstance(this).registerReceiver(
			mBroadcastReceiver, 
			new IntentFilter(Constants.INTENT_FILTER));
		Intent intent = new Intent(Constants.INTENT_FILTER);
		intent.putExtra("category", "float_button");
		intent.putExtra("message", "hide");
		LocalBroadcastManager.getInstance(this).sendBroadcast(intent);
		if (shouldReload) {
			reload();
		}
	}

	@Override
	protected void onPause() {
		LocalBroadcastManager.getInstance(this).unregisterReceiver(
			mBroadcastReceiver);
		super.onPause();
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		super.onActivityResult(requestCode, resultCode, data);
		MobGameSDK.getInstance().onActivityResult(requestCode, resultCode, data);
	}
	
	@TargetApi(19)
	public void onWindowFocusChanged(boolean hasFocus) {
		if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.KITKAT) {
	        if (hasFocus) {
	            getWindow().getDecorView()
	                    .setSystemUiVisibility(View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
	                            | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION
	                            | View.SYSTEM_UI_FLAG_FULLSCREEN
	                            | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY);
	        }
	    }
	}
	
	@Override
	public void onBackPressed() {
		Log.i(TAG, "onBackPressed:" + currentPage);
		MobGameWebFragment fragWeb = adapter.getItem(currentPage);
		if (fragWeb.canGoBack()) {
			fragWeb.goBack();
		} else {
			MobGameSDK.getInstance().close();
		}
	}

	public void loadUrls(JSONArray items) {
		if (adapter == null) {
			adapter = new MobPagerAdapter(getFragmentManager());
		}
		currentPage = 0;
		JSONArray revItems = new JSONArray();
		for (int i = items.length() - 1; i >= 0; i--) {
			try {
				JSONObject item = items.getJSONObject(i);
				revItems.put(item);
			} catch (Exception e) {}
		}
		for (int i = revItems.length() - 1; i >= 0; i--) {
			try {
				JSONObject item = revItems.getJSONObject(i);
				if (Utils.hasNtf(this, item.getInt("id"))) {
					currentPage = i;
				}
			} catch (Exception e) {}
		}
		adapter.setItems(revItems);
		fragContent.setAdapter(adapter, currentPage);
	}

	private void reload() {
		shouldReload = false;
		for (int i = 0; i < adapter.getCount(); i++) {
			MobGameWebFragment frag = (MobGameWebFragment) adapter.getItem(i);
			frag.reload();
		}
	}
	
	private void initHeaderBar() {
		
		int imgRes = Res.drawableResource(this, R.drawable.bar_header);
		layoutHeader.setBackgroundResource(imgRes);

		if (isEnableSideMenu) {
			txtTitle.setGravity(Gravity.LEFT | Gravity.CENTER_VERTICAL);
			btnMenu.setVisibility(View.VISIBLE);
			btnMenu.setOnClickListener(new OnClickListener() {
	
				@Override
				public void onClick(View v) {
					layoutRoot.openDrawer(layoutDrawer);
				}
			});
		} else {
			txtTitle.setGravity(Gravity.CENTER);
			btnMenu.setVisibility(View.GONE);
		}

		btnBack.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View v) {
				onBackPressed();
			}
		});

		btnClose.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View v) {
				MobGameSDK.getInstance().close();
			}
		});
	}

	private void initSideMenu() {
//		try {
			if (!isEnableSideMenu) {
				layoutRoot.setDrawerLockMode(DrawerLayout.LOCK_MODE_LOCKED_CLOSED);
			}
			
			MobMenu mobMenu = GameConfigManager.getInstance().getMobMenu();
			if(mobMenu == null){
				return;
			}

			ArrayList<MobMenuItem> menuItems = mobMenu.getMenuItems();
			ArrayList<SideMenuModel> models = new ArrayList<SideMenuModel>(menuItems.size());
			for (MobMenuItem menuItem : menuItems) {
				if (menuItem.shouldShow()) {
					// TODO
					SideMenuModel menuItemModel = new SideMenuModel(
							menuItem.getId(),
							menuItem.getIconUrl(), 
							menuItem.getLabel()
						);
					if (menuItem.isExternal()) {
						menuItemModel.setType(SideMenuModel.EXTERNAL);
					}
					if(menuItem.getSubMenuIds() != null){
						menuItemModel.setIds(menuItem.getSubMenuIds());
					}
					menuItemModel.setAction(
							menuItem.getCommand(),
							menuItem.getParams());
					
					models.add(menuItemModel);
				}
			}

//			String menuConfigsString = Preference.getString(this, 
//					Constants.SHARED_PREF_DB_MENU);
//			JSONArray menuConfigs = new JSONArray(menuConfigsString);
//			List<SideMenuModel> models = new ArrayList<SideMenuModel>(menuConfigsString.length());
//			for (int i = 0; i < menuConfigs.length(); i++) {
//				JSONObject menuItemJSON = menuConfigs.getJSONObject(i);
//				if (menuItemJSON.has("show") && menuItemJSON.getBoolean("show")) {
//					SideMenuModel menuItem = new SideMenuModel(
//							menuItemJSON.getInt("id"),
//							menuItemJSON.getString("icon"), 
//							menuItemJSON.getString("title")
//						);
//					if (menuItemJSON.has("external") && menuItemJSON.getBoolean("external")) {
//						menuItem.setType(SideMenuModel.EXTERNAL);
//					}
//
//					boolean isTab = menuItemJSON.getBoolean("is_tab");
//					if (isTab) {
//						JSONArray menuActions = menuItemJSON.getJSONArray("action");
//						menuItem.setItems(menuActions);
//					} else {
//						String menuAction = menuItemJSON.getString("action");
//						if (Utils.isJSONValid(menuAction)) {
//							JSONObject menuActionJSON = new JSONObject(menuAction);
//							menuItem.setAction(
//								menuActionJSON.getString("command"),
//								menuActionJSON.getString("param"));
//						} else {
//							JSONArray menuActions = new JSONArray();
//							menuActions.put(menuItemJSON);
//							menuItem.setItems(menuActions);
//						}
//					}
//
//					models.add(menuItem);
//				}
//			}
			lvAdapter = new SideMenuAdapter(this, models);
			lvDrawer.setAdapter(lvAdapter);
			lvDrawer.setOnItemClickListener(mOnMenuItemSelectedListener);
//		} catch (JSONException e) {
//			e.printStackTrace();
//		}
	}

	private OnItemClickListener mOnMenuItemSelectedListener = new OnItemClickListener() {

		@Override
		public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
			
			SideMenuModel menuItem = lvAdapter.getItem(position);
			GoogleAnalyticsManager.getInstance().trackEvent(
					"Left menu", 
					"button_press", 
					menuItem.getLabel(), 
					1);
			
			performOnItemClick(position);
		}
	};

	private SimpleOnPageChangeListener mOnPageChangeListener = new SimpleOnPageChangeListener() {

		@Override
		public void onPageSelected(int position) {
			if (position != currentPage) {
				currentPage = position;
				prgBar.setVisibility(View.GONE);
				updateHeaderBar(position);

				MobGameWebFragment fragWeb = adapter.getItem(currentPage);
//				if (fragWeb.computeVerticalScrollRange() > layoutHeader.getHeight() * 2) {
//					isEnableAutohideHeaderBar = true;
//				} else {
//					isEnableAutohideHeaderBar = false;
//					showHeader(true);
//				}

				mWebEventListener.onScrollChanged(
					fragWeb.getWebView(), 
					fragWeb.getScrollX(), fragWeb.getScrollY(), 
					fragWeb.getScrollX(), fragWeb.getScrollY());
			}
			int itemId = (int) adapter.getItemId(position);
			if (Utils.hasNtf(MobGameActivity.this, itemId)) {
				Utils.removeNtf(MobGameActivity.this, itemId);
				MobGameActivity.this.runOnUiThread(new Runnable() {

					@Override
					public void run() {
						fragContent.notifyTabsChanged();
						lvAdapter.notifyDataSetChanged();
					}
				});
			}
		}
	};

	private MobGameWebFragment.EventListener mWebEventListener = new MobGameWebFragment.EventListener() {

		@Override
		public void onPageStarted(WebView view, String url, Bitmap favicon) {
			lockHeader();
			MobGameActivity.this.runOnUiThread(new Runnable() {
				
				@Override
				public void run() {
					MobGameWebFragment fragWeb = (MobGameWebFragment) adapter.getItem(currentPage);
					if (fragContent.countTabs() > 1
					&& !fragWeb.canGoBack()) {
						fragContent.showTabs(true);
						isEnableAutohideHeaderBar = true;
						new Handler().postDelayed(new Runnable() {
							
							@Override
							public void run() {
								unlockHeader();
							}
						}, 1000);
					} else {
						fragContent.hideTabs(true);
						isEnableAutohideHeaderBar = false;
					}
					btnShare.setVisibility(View.GONE);
				}
			});
			view.addJavascriptInterface(MobGameActivity.this, "android");
		}

		@Override
		public void onProgressChanged(WebView view, int progress) {
			int pos = Integer.parseInt((String) view.getTag());
			if (pos == currentPage) {
				updateHeaderBar(pos);
				progress = Math.max(1, progress);
				prgBar.setProgress(progress);

				if (progress == 100) {
					hideProgressBar();
				} else {
					showProgressBar();
				}
			}
		}

		@Override
		public void onPageFinished(WebView view, String url) {
			int pos = Integer.parseInt((String) view.getTag());
			if (pos == currentPage) {
				updateHeaderBar(pos);
				hideProgressBar();
			}
		}

		@Override
		public void onScrollChanged(WebView view, int l, int t, int oldl, int oldt) {
			if (!isEnableAutohideHeaderBar) return;
			if (isLockingHeaderBar) return;
			MobGameWebView webView = (MobGameWebView) view;
			int maxt = webView.computeVerticalScrollRange();
			if (t == 0) {
				cancelAnimationHeader();
				showHeader();
				return;
			} else if (t == maxt) {
				cancelAnimationHeader();
				hideHeader();
				return;
			}
			if (isScrollAnimating) return;
			if (oldt - t > 5 * density) {
				cancelAnimationHeader();
				showHeader();
			} else if (t - oldt > 5 * density) {
				cancelAnimationHeader();
				hideHeader();
			}
		}

		@Override
		public void onSizeChanged(WebView view, int w, int h, int oldw, int oldh) {
			/*int pos = Integer.parseInt((String) view.getTag());
			if (pos == currentPage) {
				MobWebView webView = (MobWebView) view;
				if (webView.computeVerticalScrollRange() > layoutHeader.getHeight() * 2) {
					isEnableAutohideHeaderBar = true;
				} else {
					isEnableAutohideHeaderBar = false;
					showHeader(true);
				}
			}*/
		}
		
	};

	private AnimatorListener mHeaderAnimatorListener = new AnimatorListener() {
		
		@Override
		public void onAnimationStart(Animator animator) {
			isScrollAnimating = true;
			MobGameActivity.this.runOnUiThread(new Runnable() {
				
				@Override
				public void run() {
					((ViewGroup) layoutMain).updateViewLayout(
						layoutContent, 
						new RelativeLayout.LayoutParams(
							LayoutParams.MATCH_PARENT, 
							layoutMain.getHeight()
						)
					);
				}
			});
		}

		@Override
		public void onAnimationRepeat(Animator animator) {}
		
		@Override
		public void onAnimationEnd(Animator animator) {
			MobGameActivity.this.runOnUiThread(new Runnable() {
				
				@Override
				public void run() {
					((ViewGroup) layoutMain).updateViewLayout(
						layoutContent, 
						new RelativeLayout.LayoutParams(
							LayoutParams.MATCH_PARENT, 
							(layoutMain.getHeight()  - layoutHeader.getHeight() - (int) layoutHeader.getY())
						)
					);
					fragContent.updateTabs();
					isScrollAnimating = false;
				}
			});
		}

		@Override
		public void onAnimationCancel(Animator animator) {}
	};

	private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver() {

		@Override
		public void onReceive(Context context, Intent intent) {
			String category = intent.getStringExtra("category");
			if ("gcm".equalsIgnoreCase(category)) {
				String strId = intent.getStringExtra("id");
				if (strId != null) {
					lvAdapter.notifyDataSetChanged();
					fragContent.notifyTabsChanged();
				}
			} else if ("dashboard".equalsIgnoreCase(category)) {
				Log.e(TAG , "android go here!");
				try {

					fragContent.hideTabs(false);
				} catch (Exception e) {
					e.printStackTrace();
				}
				try {
					String strUrls = intent.getStringExtra("urls");
					JSONArray urls = new JSONArray(strUrls);
					loadUrls(urls);
				} catch (Exception e) {
					e.printStackTrace();
				}
			} else if ("finish_facebook_upgrade".equalsIgnoreCase(category)) {
				performOnItemClick(0);
			} else if ("dashboard_close".equalsIgnoreCase(category)) {
				Log.d(TAG , "dashboard close ");
				finish();
			} else if ("mobOpenOfferWall".equalsIgnoreCase(category)) {
				if(!Utils.isOnline(getApplicationContext())){
					Toast.makeText(getApplicationContext(), getResources().getString(R.string.error_network), Toast.LENGTH_SHORT).show();
				}else{
//					offerWall.loadAd();
//					offerWall.show();
				}
			} else if ("reload".equalsIgnoreCase(category)) {
				reload();
			}
		}
	};

	private void updateHeaderBar(int pos) {
		try {
			final MobGameWebFragment fragWeb = (MobGameWebFragment) adapter.getItem(pos);
			if (fragWeb != null && fragWeb.isAdded()) {
				this.runOnUiThread(new Runnable() {
					
					@Override
					public void run() {
						String title = fragWeb.getTitle();
						if (title.contains(Constants.DOMAIN_NAME)
						|| title.equalsIgnoreCase("about:blank")
						|| title.equalsIgnoreCase("website not available")
						|| title.contains("data:text/html")
						|| title.startsWith("http://")
						|| title.startsWith("https://")) {
							title = "";
						}
						if(!Utils.isOnline(getApplicationContext())){
							title = "Website not available";
						}
						
						txtTitle.setText(title);
						if (fragWeb.canGoBack()) {
							btnBack.setVisibility(View.VISIBLE);
							btnMenu.setVisibility(View.GONE);
						} else {
							btnBack.setVisibility(View.GONE);
							if (isEnableSideMenu) {
								btnMenu.setVisibility(View.VISIBLE);
							}
						}
					}
				});
	
				String inject = "" +
					"if (typeof getShareUrl === 'function') {							" +
					"	try {															" +
					"		window.android.onGetShareUrl(getShareUrl());				" +
					"	} catch (err) {													" +
					"		window.android.onGetShareUrl('');							" +
					"		console.log(err);											" +
					"	}																" +
					"} else {															" +
					"	window.android.onGetShareUrl('');								" +
					"}																	";
				fragWeb.invokeJavascript(inject);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private void showProgressBar() {
		MobGameActivity.this.runOnUiThread(new Runnable() {
			
			@Override
			public void run() {
				prgBar.setVisibility(View.VISIBLE);
			}
		});
	}

	private void hideProgressBar() {
		new Handler().postDelayed(new Runnable() {
			
			@Override
			public void run() {
				MobGameActivity.this.runOnUiThread(new Runnable() {
					
					@Override
					public void run() {
						prgBar.setVisibility(View.GONE);
					}
				});
			}
		}, 500);
	}

	private void showHeader() {
		if (isLockingHeaderBar) return;
		layoutHeader.animate()
			.setDuration(100)
			.y(0);
		layoutContent.animate()
			.y(layoutHeader.getHeight())
			.setDuration(100)
			.setListener(mHeaderAnimatorListener);
	}

	private void hideHeader() {
		if (isLockingHeaderBar) return;
		layoutHeader.animate()
			.setDuration(100)
			.y(-layoutHeader.getHeight());
		layoutContent.animate()
			.setDuration(100)
			.y(0)
			.setListener(mHeaderAnimatorListener);
	}

	private void lockHeader() {
		showHeader();
		isLockingHeaderBar = true;
	}

	private void unlockHeader() {
		isLockingHeaderBar = false;
	}

	private void cancelAnimationHeader() {
		layoutHeader.animate().cancel();
		layoutContent.animate().cancel();
	}
	
	private void performOnItemClick(int position) {
		if (lvAdapter == null) return;
		SideMenuModel menuItem = lvAdapter.getItem(position);
		Log.d(TAG, menuItem.toString());
		Utils.removeNtf(this, menuItem.getId());
		if ("dashboard".equalsIgnoreCase(menuItem.getCommand())) {
			try {
				loadUrls(new JSONArray(menuItem.getParams()));
				if (menuItem.isTabbed()) {
					fragContent.showTabs(false);
				} else {
					fragContent.hideTabs(false);
				}
			} catch (JSONException e) {}
		} else if (menuItem.getCommand() != null) {
			MobGameWebFragment fragWeb = (MobGameWebFragment) adapter.getItem(currentPage);
			fragWeb.handleCommand(menuItem.getCommand(), menuItem.getParams());
		}
		lvAdapter.notifyDataSetChanged();
		layoutRoot.closeDrawers();
	}
	
//	private OfferWall offerWall;

	@JavascriptInterface
	public void onGetShareUrl(String value) {
		try {
			JSONObject obj = new JSONObject(value);
			final String shareUrl = obj.getString("url");
			final String shareTitle = obj.getString("title");
			btnShare.setOnClickListener(new OnClickListener() {

				@Override
				public void onClick(View v) {
					Intent intent = new Intent(Intent.ACTION_SEND);
					intent.setType("text/plain");
					intent.putExtra(Intent.EXTRA_TEXT, shareUrl);
					intent.putExtra(android.content.Intent.EXTRA_SUBJECT, shareTitle);
					startActivity(Intent.createChooser(intent, "Share"));
				}
			});
			this.runOnUiThread(new Runnable() {
				
				@Override
				public void run() {
					if (TextUtils.isEmpty(shareUrl)) {
						btnShare.setVisibility(View.GONE);
					} else {
						btnShare.setVisibility(View.VISIBLE);
					}
				}
			});
		} catch (JSONException e) {
			this.runOnUiThread(new Runnable() {
				
				@Override
				public void run() {
					btnShare.setVisibility(View.GONE);
				}
			});
		}
	}

	private class SideMenuModel {
		private int id;
		private int[] ids;
		private String iconUrl;
		private String label;
		private String command;
		private String params;
//		private ArrayList<MobUrl> dataset;
		private JSONArray items;
		
		public int[] getIds() {
			return ids;
		}

		public void setIds(int[] ids) {
			this.ids = ids;
		}

		int type = DEFAULT;

		public SideMenuModel(int id, String imageUrl, String label) {
			this(id, imageUrl, label, DEFAULT);
		}

		public SideMenuModel(int id, String imageUrl, String label, int type) {
			this.id = id;
			this.iconUrl = imageUrl;
			this.label = label;
			this.type = type;
		}
		
		public int getId() {
			return id;
		}
		
		public void setType(int type) {
			this.type = type;
		}
		
		public void setItems(JSONArray items) {
			this.items = items;
		}
		
		public void setAction(String command, String params) {
			this.command = command;
			this.params = params;
		}
		
		public String getCommand() {
			return command;
		}
		
		public String getParams() {
			return params;
		}
		
		public boolean isTabbed() {
			return (items != null && items.length() > 1);
		}
		
		public boolean hasNtf() {
			if (Utils.hasNtf(MobGameActivity.this, id)) {
				return true;
			}
			if (isTabbed()) {
				for (int i = 0; i < items.length(); i++) {
					try {
						JSONObject item = items.getJSONObject(i);
						int id = item.getInt("id");
						if (Utils.hasNtf(MobGameActivity.this, id)) {
							return true;
						}
					} catch (JSONException e) {}
				}
			}
			return false;
		}
		
		public JSONArray getItems() {
			return items;
		}

		public String getLabel() {
			return label;
		}

		static final int DEFAULT = 0;
		static final int EXTERNAL = 1;
	}

	private class SideMenuAdapter extends ArrayAdapter<SideMenuModel> {

		private Activity context;
		private List<SideMenuModel> items;

		public SideMenuAdapter(Activity activity, List<SideMenuModel> items) {
			super(activity, R.layout.sidemenu_item);
			this.context = activity;
			this.items = items;
		}

		@Override
		public SideMenuModel getItem(int position) {
			return items.get(position);
		}

		@Override
		public int getCount() {
			return items.size();
		}

		@SuppressLint("InflateParams")
		@Override
		public View getView(int position, View convertView, ViewGroup parent) {
			LayoutInflater inflator = context.getLayoutInflater();
			View v = inflator.inflate(R.layout.sidemenu_item, null);
			ImageView  imageView = (ImageView) v.findViewById(R.id.image);
			TextView textView = (TextView) v.findViewById(R.id.label);
			ImageView imageView2 = (ImageView) v.findViewById(R.id.image2);
			
			textView.setText(items.get(position).label);
			Glide.with(MobGameActivity.this)
			    .load(items.get(position).iconUrl)
			    .into(imageView);
			switch (items.get(position).type) {
				case SideMenuModel.EXTERNAL:
					imageView2.setImageResource(R.drawable.ic_external_sm);
					imageView2.setVisibility(View.VISIBLE);
					break;
				case SideMenuModel.DEFAULT:
				default:
					imageView2.setVisibility(View.GONE);
					break;
			}
//			if (items.get(position).hasNtf()) {
			for (int i = 0; i < items.get(position).getIds().length; i++) {
				if(Utils.hasNtf(context, items.get(position).getIds()[i])){
					imageView2.setImageResource(R.drawable.ic_notification);
					imageView2.setVisibility(View.VISIBLE);
				}
			}
			if(Utils.hasNtf(context, items.get(position).getId())){
				imageView2.setImageResource(R.drawable.ic_notification);
				imageView2.setVisibility(View.VISIBLE);
			}
			return v;
		}
	}

	private class MobPagerAdapter extends FragmentPagerAdapter {

		private ArrayList<MobGameWebFragment> fragments;
		private FragmentManager fm;
		private JSONArray items;

		{
			fragments = new ArrayList<MobGameWebFragment>();
		}

		public MobPagerAdapter(FragmentManager fm) {
			super(fm);
			this.fm = fm;
		}

		public void setItems(JSONArray items) {
			releaseFragments();
			this.items = items;
			fragments = new ArrayList<MobGameWebFragment>();
        	for (int i = 0; i < items.length(); i++) {
        		try {
					JSONObject item = items.getJSONObject(i);
					String url = item.getString("action");
	        		MobGameWebFragment frag = MobGameWebFragment.newInstance(url);
	            	frag.setEventListener(mWebEventListener);
	            	frag.setWebViewTag(i + "");
	            	fragments.add(frag);
				} catch (JSONException e) {
					e.printStackTrace();
				}
        	}
		}

        @Override
		public MobGameWebFragment getItem(int position) {
        	try {
        		return fragments.get(position);
        	} catch (Exception e) {
        		return null;
        	}
		}

		@Override
		public long getItemId(int position) {
			try {
				return items.getJSONObject(position).getInt("id");
			} catch (Exception e) {
				return -1;
			}
		}

		@Override
		public int getCount() {
			return fragments.size();
		}

		@Override
		public int getItemPosition(Object item) {
		    return POSITION_NONE;
		}

		@Override
		public CharSequence getPageTitle(int position) {
			try {
				JSONObject item = items.getJSONObject(position);
				int id = item.getInt("id");
				if (item.has("title")) {
					String title = item.getString("title").toUpperCase(Locale.ENGLISH);
					if (Utils.hasNtf(MobGameActivity.this, id)) {
						
						Drawable image = Res.drawable(MobGameActivity.this, R.drawable.ic_notification_tab_strip);
					    image.setBounds(0, 0, image.getIntrinsicWidth(), image.getIntrinsicHeight());
					    SpannableString sb = new SpannableString(title + "  ");
					    ImageSpan imageSpan = new ImageSpan(image, ImageSpan.ALIGN_BASELINE);
					    sb.setSpan(imageSpan, title.length() + 1, title.length() + 2, Spannable.SPAN_INCLUSIVE_INCLUSIVE);
					    return sb;
					}
					return title;
				} else {
					return "Tab " + position;
				}
			} catch (Exception e) {
				return "Tab " + position;
			}
		}

		private void releaseFragments() {
			if (fragments != null) {
				for (MobGameWebFragment frag : fragments) {
					frag.stopLoading();
					fm.beginTransaction().remove(frag).commitAllowingStateLoss();
				}
			}
		}
    }

}
