/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.component;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.appsflyer.AppsFlyerLib;
import com.google.ads.conversiontracking.AdWordsAutomatedUsageReporter;
import com.mobgame.MobGameSDK;
import com.mobgame.component.FacebookManager;
import com.mobgame.component.GoogleAnalyticsManager;
import com.mobgame.component.GoogleAuthManager;
import com.mobgame.model.CharacterInfo;
import com.mobgame.model.Game;
import com.mobgame.model.MobMenu;
import com.mobgame.model.UserInfo;
import com.mobgame.utils.Preference;

public final class GameConfigManager {
    private static final String TAG = GameConfigManager.class.getSimpleName();
    private static final String SHARED_PREF_MACCESS_TOKEN = "shared_pref_maccess_token";
    private static GameConfigManager INSTANCE;
    private String appkey;
    private Game gameConfig;
    private UserInfo userInfo;
    private CharacterInfo characterInfo;
    private MobMenu mobMenu;
    private String accessToken;
    private boolean hasUnreadNotifications;

    public static GameConfigManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GameConfigManager();
        }
        return INSTANCE;
    }

    public String getAppKey() {
        return this.appkey;
    }

    public void setAppKey(String appkey) {
        this.appkey = appkey;
    }

    public Game getGameConfig() {
        return this.gameConfig;
    }

    public void setGameConfig(Game gameConfig) {
        this.gameConfig = gameConfig;
        this.initLang(gameConfig.getLang());
        this.initGoogleAuth();
        this.initFacebook(gameConfig.getFacebookId());
        this.initAppsFlyer(gameConfig.getAppsflyer());
        this.initGoogleAnalytics(new String[]{gameConfig.getGoogleAnalyticsId(), gameConfig.getGoogleAnalyticsIdTotal(), gameConfig.getGoogleAnalyticsIdLocal()});
        this.initAdwords(gameConfig.getAdwords());
        this.initAds(gameConfig.getAdsConfig());
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public void clearUserInfo() {
        this.userInfo = null;
    }

    public CharacterInfo getCharacterInfo() {
        if (this.characterInfo == null) {
            this.characterInfo = new CharacterInfo();
        }
        return this.characterInfo;
    }

    public void setCharacterInfo(CharacterInfo characterInfo) {
        this.characterInfo = characterInfo;
    }

    public void clearCharacterInfo() {
        this.characterInfo = null;
    }

    public String getAccessToken() {
        if (this.accessToken == null) {
            Activity a = MobGameSDK.activity;
            this.accessToken = Preference.getString((Context)a, SHARED_PREF_MACCESS_TOKEN);
        }
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        Activity a = MobGameSDK.activity;
        Preference.save((Context)a, SHARED_PREF_MACCESS_TOKEN, accessToken);
        this.accessToken = accessToken;
    }

    public void clearAccessToken() {
        Activity a = MobGameSDK.activity;
        Preference.remove((Context)a, SHARED_PREF_MACCESS_TOKEN);
        this.accessToken = null;
    }

    public MobMenu getMobMenu() {
        if (this.mobMenu == null) {
            this.mobMenu = new MobMenu();
        }
        return this.mobMenu;
    }

    public void setMobMenu(MobMenu mobMenu) {
        this.mobMenu = mobMenu;
    }

    public void clearMobMenu() {
        this.mobMenu = null;
    }

    public void clearLogin() {
        this.clearMobMenu();
        this.clearUserInfo();
        this.clearCharacterInfo();
        this.clearAccessToken();
    }

    public boolean isHasUnreadNotifications() {
        return this.hasUnreadNotifications;
    }

    public void setHasUnreadNotifications(boolean hasUnreadNotifications) {
        this.hasUnreadNotifications = hasUnreadNotifications;
    }

    public void clearUnreadNotifications() {
        this.hasUnreadNotifications = false;
    }

    public String getFacebookId() {
        return this.gameConfig.getFacebookId();
    }

    private void initFacebook(String facebookAppId) {
        try {
            Log.i((String)TAG, (String)"initFacebook");
            Activity a = MobGameSDK.activity;
            FacebookManager.getInstance().init(a.getApplicationContext(), facebookAppId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initGoogleAuth() {
        Activity a = MobGameSDK.activity;
        GoogleAuthManager.getInstance().init(a);
    }

    private void initAppsFlyer(Game.AppsFlyerConfig config) {
        try {
            Log.i((String)TAG, (String)"initAppsFlyer");
            Activity a = MobGameSDK.activity;
            AppsFlyerLib.getInstance().setUseHTTPFalback(config.isUseHttp());
            AppsFlyerLib.getInstance().setCurrencyCode(config.getCurrency());
            AppsFlyerLib.getInstance().startTracking(a.getApplication(), config.getDevKey());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initGoogleAnalytics(String id) {
        this.initGoogleAnalytics(new String[]{id});
    }

    private void initGoogleAnalytics(String[] ids) {
        try {
            Activity a = MobGameSDK.activity;
            GoogleAnalyticsManager.getInstance().init(a.getApplicationContext());
            for (String id : ids) {
                GoogleAnalyticsManager.getInstance().addTracker(id);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initAdwords(Game.AdwordsConfig config) {
        try {
            Activity a = MobGameSDK.activity;
            String conversionId = config.getConversionId();
            AdWordsAutomatedUsageReporter.enableAutomatedUsageReporting((Context)a.getApplicationContext(), (String)conversionId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initAds(Game.AdsConfig config) {
        try {
            Activity activity = MobGameSDK.activity;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initLang(String lang) {
        if ("vie".equalsIgnoreCase(lang) || "vi".equalsIgnoreCase(lang)) {
            this.gameConfig.setLang("vie");
        } else if ("eng".equalsIgnoreCase(lang) || "en".equalsIgnoreCase(lang)) {
            this.gameConfig.setLang("eng");
        } else if ("es_es".equalsIgnoreCase(lang)) {
            this.gameConfig.setLang("es_es");
        } else if ("zh".equalsIgnoreCase(lang) || "zh_cn".equalsIgnoreCase(lang) || "zh_tw".equalsIgnoreCase(lang)) {
            this.gameConfig.setLang("zh_cn");
        } else if ("th".equalsIgnoreCase(lang) || "tha".equalsIgnoreCase(lang)) {
            this.gameConfig.setLang("tha");
        } else if ("ind".equalsIgnoreCase(lang) || "id".equalsIgnoreCase(lang)) {
            this.gameConfig.setLang("ind");
        }
    }
}

