/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.webkit.CookieSyncManager;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.appsflyer.AppsFlyerLib;
import com.mobgame.MobGameGCMIntentService;
import com.mobgame.MobGameHelper;
import com.mobgame.MobGameListener;
import com.mobgame.R;
import com.mobgame.api.GetInfoAfterAuthenTask;
import com.mobgame.api.GetInfoBeforeAuthenTask;
import com.mobgame.api.LogoutTask;
import com.mobgame.api.SaveCharacterTask;
import com.mobgame.component.FacebookManager;
import com.mobgame.component.GameConfigManager;
import com.mobgame.component.GoogleAuthManager;
import com.mobgame.gui.MobGameActivity;
import com.mobgame.gui.MobGameUpgradeDialog;
import com.mobgame.js.CmdDashboard;
import com.mobgame.js.CmdPayment;
import com.mobgame.model.Game;
import com.mobgame.model.MobMenuItem;
import com.mobgame.model.UserInfo;
import com.mobgame.utils.Constants;
import com.mobgame.utils.PermissionUtils;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Res;
import com.mobgame.utils.Utils;
import com.mobgame.utils.debug.LogUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class MobGameSDK {
    private static final String TAG = MobGameSDK.class.getSimpleName();
    private static MobGameSDK INSTANCE;
    public static Activity activity;
    public static Activity currentActivity;
    private SensorManager sensorManager;
    private Sensor accelerometerSensor;
    private boolean accelerometerPresent;
    private MobGameListener mListener;
    private static boolean shouldShowFloatButton;
    private static boolean shouldShowPopup;
    private ArrayList<String> queuePopups = new ArrayList();
    private static final String POPUP_HELLO = "popup_hello";
    private static final String POPUP_ACCOUNT = "popup_account";
    private static final String POPUP_NTFS = "popup_ntfs";
    private static final String POPUP_FLOAT_BUTTON = "popup_float_button";
    private static final String POPUP_ADS = "popup_ads";
    private static final long TIMEOUT_DISMISS_FLOAT_BUTTON = 86400000L;
    private int menuId;
    private boolean isShowAds = true;
    private SensorEventListener accelerometerListener = new SensorEventListener(){
        private float oldZ;

        public void onAccuracyChanged(Sensor event, int accuracy) {
        }

        public void onSensorChanged(SensorEvent event) {
            float z_value = event.values[2];
            if (z_value < 0.0f && this.oldZ * z_value < 0.0f) {
                Preference.remove((Context)activity, "shared_pref_float_button_dismiss_time");
                Preference.remove((Context)activity, "shared_pref_hide_float_button");
                Intent intent = new Intent("com.mobgame.broadcast");
                intent.putExtra("category", "float_button");
                LocalBroadcastManager.getInstance((Context)activity).sendBroadcast(intent);
            }
            this.oldZ = z_value;
        }
    };
    private boolean loginProcessDone = false;
    boolean isUpgradeDialog = false;
    private MobGameUpgradeDialog dialog;
    MobGameListener mDefaultListener = new MobGameListener(){

        @Override
        public void onLoginSuccessful(String accID, String token) {
        }

        @Override
        public void onPaySuccessful(String userId, String orderId, String orderProduct, String orderInfo, String orderTime, String platformPrice, String gamePrice, String state, String game_role_id, String game_area_id, String is_sandbox) {
            try {
                double price = 0.01 * Double.parseDouble(platformPrice);
                HashMap<String, Object> eventValue = new HashMap<String, Object>();
                eventValue.put("af_revenue", price);
                eventValue.put("af_content_type", "category_rev");
                eventValue.put("af_content_id", "123456");
                eventValue.put("af_currency", "USD");
                AppsFlyerLib.getInstance().trackEvent(currentActivity.getApplicationContext(), "af_purchase", eventValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void onError(int errorCode, String message) {
        }
    };
    private int countShowHello = 0;
    private StatusAd adStatus = StatusAd.AD_INIT;
    private Application.ActivityLifecycleCallbacks mActivityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){
        private final String TAG = Application.ActivityLifecycleCallbacks.class.getSimpleName();

        public void onActivityCreated(Activity a, Bundle b) {
            Log.i((String)this.TAG, (String)("onActivityCreated:" + a.getClass().getSimpleName()));
            currentActivity = a;
            if (a.equals(activity)) {
                // empty if block
            }
        }

        public void onActivityStarted(Activity a) {
            Log.i((String)this.TAG, (String)("onActivityStarted:" + a.getClass().getSimpleName()));
            currentActivity = a;
            if (a.equals(activity)) {
                // empty if block
            }
        }

        public void onActivityResumed(Activity a) {
            Log.i((String)this.TAG, (String)("onActivityResumed:" + a.getClass().getSimpleName()));
            currentActivity = a;
            if (a.equals(activity)) {
                Log.d((String)this.TAG, (String)("menu-id onActivityResumed:" + MobGameSDK.this.menuId));
                this.requestReadExternalPermission();
                Game gameConfig = GameConfigManager.getInstance().getGameConfig();
                if (gameConfig == null) {
                    MobGameSDK.this.getGameInfoRemote();
                }
                LocalBroadcastManager.getInstance((Context)activity.getApplicationContext()).registerReceiver(MobGameSDK.this.mMessageReceiver, new IntentFilter("com.mobgame.broadcast"));
                CookieSyncManager.getInstance().startSync();
                Intent intent = new Intent("com.mobgame.broadcast");
                intent.putExtra("category", "float_button");
                LocalBroadcastManager.getInstance((Context)activity).sendBroadcast(intent);
                Log.d((String)this.TAG, (String)("shouldShowPopup:" + shouldShowPopup));
                if (shouldShowPopup) {
                    MobGameSDK.this.showPopup();
                    shouldShowPopup = false;
                }
                Log.e((String)this.TAG, (String)("isShowAds: " + MobGameSDK.this.isShowAds));
                if (MobGameSDK.this.isLoggedIn() && MobGameSDK.this.isShowAds && MobGameSDK.this.isShowPopupUpgrade()) {
                    Log.e((String)this.TAG, (String)("Go inside :" + MobGameSDK.this.isShowAds + ", isShowPopupUpgrade():" + MobGameSDK.this.isShowPopupUpgrade()));
                }
                if (MobGameSDK.this.accelerometerPresent) {
                    MobGameSDK.this.sensorManager.registerListener(MobGameSDK.this.accelerometerListener, MobGameSDK.this.accelerometerSensor, 3);
                }
            }
        }

        @SuppressLint(value={"InlinedApi"})
        private void requestReadExternalPermission() {
            boolean grantedReadStorage = PermissionUtils.hasPermission("android.permission.READ_EXTERNAL_STORAGE");
            if (!grantedReadStorage) {
                PermissionUtils.requestPermission(activity, "android.permission.READ_EXTERNAL_STORAGE");
            }
        }

        public void onActivityPaused(Activity a) {
            Log.i((String)this.TAG, (String)("onActivityPaused:" + a.getClass().getSimpleName()));
            currentActivity = a;
            if (a.equals(activity)) {
                if (MobGameSDK.this.accelerometerPresent) {
                    MobGameSDK.this.sensorManager.unregisterListener(MobGameSDK.this.accelerometerListener);
                }
                MobGameHelper.hideFloatButton();
                CookieSyncManager.getInstance().stopSync();
                LocalBroadcastManager.getInstance((Context)activity.getApplicationContext()).unregisterReceiver(MobGameSDK.this.mMessageReceiver);
            }
        }

        public void onActivityStopped(Activity a) {
            Log.i((String)this.TAG, (String)("onActivityStopped:" + a.getClass().getSimpleName()));
            if (a.equals(activity)) {
                MobGameHelper.hideFloatButton();
            }
        }

        public void onActivityDestroyed(Activity a) {
            Log.i((String)this.TAG, (String)("onActivityDestroyed:" + a.getClass().getSimpleName()));
            if (a.equals(activity)) {
                if (!a.getClass().getSimpleName().equals("MobGameActivity") && !a.getClass().getSimpleName().equals("FacebookActivity")) {
                    MobGameSDK.this.isShowAds = true;
                }
                Log.i((String)this.TAG, (String)"removeAllCookie");
                MobGameGCMIntentService.destroy((Context)activity);
                LocalBroadcastManager.getInstance((Context)activity.getApplicationContext()).unregisterReceiver(MobGameSDK.this.mGlobalMessageReceiver);
            }
        }

        public void onActivitySaveInstanceState(Activity a, Bundle b) {
            if (a.equals(activity)) {
                // empty if block
            }
        }
    };
    private ComponentCallbacks mComponentCallbacks = new ComponentCallbacks(){

        public void onConfigurationChanged(Configuration newConfig) {
            Log.d((String)TAG, (String)"onConfigurationChanged");
            if (newConfig.orientation == 2 || newConfig.orientation == 1) {
                Log.d((String)TAG, (String)("onConfigurationChanged : " + newConfig.orientation));
                if (Utils.isDashboardEnabled((Context)activity)) {
                    MobGameHelper.initFloatButton();
                }
                Intent intent = new Intent("com.mobgame.broadcast");
                intent.putExtra("category", "float_button");
                LocalBroadcastManager.getInstance((Context)activity).sendBroadcast(intent);
            }
        }

        public void onLowMemory() {
        }
    };
    private BroadcastReceiver mMessageReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            Log.d((String)TAG, (String)"BroadcastReceiver::onReceive");
            String category = intent.getStringExtra("category");
            Log.e((String)TAG, (String)("category:" + category));
            if (category != null) {
                if ("dashboard".equalsIgnoreCase(category)) {
                    String data = intent.getStringExtra("data");
                    if (!TextUtils.isEmpty((CharSequence)data)) {
                        try {
                            MobGameSDK.this.dashboard(data);
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    } else {
                        MobGameSDK.this.dashboard();
                    }
                } else if ("float_button".equalsIgnoreCase(category)) {
                    String msg = intent.getStringExtra("message");
                    Log.d((String)TAG, (String)("message:" + msg));
                    if ("hide".equalsIgnoreCase(msg)) {
                        Log.d((String)TAG, (String)"Da vao day");
                        MobGameHelper.hideFloatButton();
                    } else {
                        Log.d((String)TAG, (String)("alo alo : " + Utils.isDashboardEnabled((Context)activity)));
                        if (GameConfigManager.getInstance().getGameConfig() != null && MobGameSDK.this.isLoggedIn() && Utils.isDashboardEnabled((Context)activity) && shouldShowFloatButton) {
                            if (GameConfigManager.getInstance().isHasUnreadNotifications() && Preference.getBoolean((Context)activity, "shared_pref_hide_float_button", true)) {
                                MobGameHelper.notifyFloatButton();
                            }
                            long currentTimeMilisecond = Calendar.getInstance().getTimeInMillis();
                            long dismissTime = Preference.getLong((Context)activity, "shared_pref_float_button_dismiss_time", -1L);
                            if (dismissTime < 0L) {
                                MobGameHelper.showFloatButton();
                                return;
                            }
                            long totalTime = currentTimeMilisecond - dismissTime;
                            LogUtils.log((Context)activity, TAG, String.format("total time float button dismissed: %s hours", totalTime / 60L * 60L * 1000L));
                            if (totalTime >= 86400000L) {
                                MobGameHelper.showFloatButton();
                                Preference.remove((Context)activity, "shared_pref_float_button_dismiss_time");
                            }
                        }
                    }
                } else if ("gcm".equalsIgnoreCase(category)) {
                    if (GameConfigManager.getInstance().getGameConfig() != null && MobGameSDK.this.isLoggedIn() && Utils.isDashboardEnabled((Context)activity)) {
                        MobGameHelper.notifyFloatButton();
                    }
                } else if (!"mobOpenOfferWall".equalsIgnoreCase(category)) {
                    if ("mobOpenFanPage".equalsIgnoreCase(category)) {
                        String params = intent.getStringExtra("data");
                        CmdDashboard.getInstance().mobOpenFBFanpage(activity, params);
                    } else if ("mobOpenGroup".equalsIgnoreCase(category)) {
                        String params = intent.getStringExtra("data");
                        CmdDashboard.getInstance().mobOpenFBGroup(activity, params);
                    } else if ("mobOpenBrowser".equalsIgnoreCase(category)) {
                        String params = intent.getStringExtra("data");
                        CmdDashboard.getInstance().mobOpenBrowser(activity, params);
                    } else if ("MobGameUpgradeDialog.btnUpgradeInfo".equalsIgnoreCase(category)) {
                        shouldShowPopup = true;
                    }
                }
            }
        }
    };
    private BroadcastReceiver mGlobalMessageReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            Log.d((String)TAG, (String)"GlobalMessageReceiver::onReceive");
            String category = intent.getStringExtra("category");
            Log.d((String)TAG, (String)("GlobalMessageReceiver::onReceive " + category));
            if (category != null) {
                if ("login".equalsIgnoreCase(category)) {
                    MobGameSDK.this.handleLogin();
                } else if ("payment".equalsIgnoreCase(category)) {
                    boolean success = intent.getBooleanExtra("status", false);
                    if (success) {
                        String userId = intent.getStringExtra("user_id");
                        String orderId = intent.getStringExtra("order_id");
                        String orderProduct = intent.getStringExtra("order_product");
                        String orderInfo = intent.getStringExtra("order_info");
                        String orderTime = intent.getStringExtra("order_time");
                        String platformPrice = intent.getStringExtra("platform_price");
                        String gamePrice = intent.getStringExtra("game_price");
                        String state = intent.getStringExtra("state");
                        String game_role_id = intent.getStringExtra("game_role_id");
                        String game_area_id = intent.getStringExtra("game_area_id");
                        String is_sandbox = intent.getStringExtra("is_sandbox");
                        MobGameSDK.this.mListener.onPaySuccessful(userId, orderId, orderProduct, orderInfo, orderTime, platformPrice, gamePrice, state, game_role_id, game_area_id, is_sandbox);
                    } else {
                        String message = intent.getStringExtra("message");
                        MobGameSDK.this.mListener.onError(10002, message);
                    }
                } else if ("reload".equalsIgnoreCase(category)) {
                    MobGameActivity.shouldReload = true;
                }
            }
        }
    };
    private GetInfoBeforeAuthenTask mGetInfoBeforeAuthenTask;
    private static View helloView;
    private static boolean isShowingHello;
    private static final int DEFAULT_HELLO_TIMEOUT = 3000;

    private MobGameSDK() {
    }

    public static MobGameSDK getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MobGameSDK();
        }
        return INSTANCE;
    }

    public void init(Activity activity, String appkey) {
        Log.i((String)TAG, (String)"MobGameSDK");
        MobGameSDK.activity = activity;
        if (this.mListener == null) {
            this.setMobGameListener(new MobGameListener(){

                @Override
                public void onPaySuccessful(String userId, String orderId, String orderProduct, String orderInfo, String orderTime, String platformPrice, String gamePrice, String state, String game_role_id, String game_area_id, String is_sandbox) {
                }

                @Override
                public void onLoginSuccessful(String accountID, String accessToken) {
                }

                @Override
                public void onError(int errorCode, String message) {
                }
            });
        }
        GameConfigManager.getInstance().setAppKey(appkey);
        activity.getApplication().unregisterActivityLifecycleCallbacks(this.mActivityLifecycleCallbacks);
        activity.getApplication().registerActivityLifecycleCallbacks(this.mActivityLifecycleCallbacks);
        activity.getApplication().unregisterComponentCallbacks(this.mComponentCallbacks);
        activity.getApplication().registerComponentCallbacks(this.mComponentCallbacks);
        LocalBroadcastManager.getInstance((Context)activity.getApplicationContext()).registerReceiver(this.mGlobalMessageReceiver, new IntentFilter("com.mobgame.broadcast"));
        CookieSyncManager.createInstance((Context)activity.getApplicationContext());
        this.sensorManager = (SensorManager)activity.getSystemService("sensor");
        List sensorList = this.sensorManager.getSensorList(1);
        if (sensorList.size() > 0) {
            this.accelerometerPresent = true;
            this.accelerometerSensor = (Sensor)sensorList.get(0);
        } else {
            this.accelerometerPresent = false;
        }
        MobGameGCMIntentService.register((Context)activity);
    }

    public void onHandleIntent(Intent intent) {
        block5: {
            Uri data = intent.getData();
            if (data != null) {
                try {
                    int menuId = Integer.parseInt(data.getQueryParameter("menu-id"));
                    Log.d((String)TAG, (String)("menu-id:" + menuId));
                    this.menuId = menuId;
                    if (menuId <= 0) break block5;
                    MobMenuItem menuItem = GameConfigManager.getInstance().getMobMenu().getMobMenuItemById(menuId);
                    menuId = -1;
                    if (menuItem != null) {
                        Intent intent2 = new Intent("com.mobgame.broadcast");
                        intent.putExtra("category", menuItem.getCommand());
                        intent.putExtra("data", menuItem.getParams());
                        LocalBroadcastManager.getInstance((Context)activity.getApplicationContext()).sendBroadcast(intent2);
                        return;
                    }
                }
                catch (Exception e) {
                    this.menuId = -1;
                }
            } else {
                this.menuId = -1;
            }
        }
    }

    public static Context getApplicationContext() {
        return activity.getApplicationContext();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        Log.i((String)TAG, (String)("onActivityResult:requestCode=" + requestCode + ";resultCode=" + resultCode));
        try {
            switch (requestCode) {
                case 0: {
                    GoogleAuthManager.getInstance().onActivityResult(requestCode, resultCode, data);
                    break;
                }
                case 64206: 
                case 64207: 
                case 64213: {
                    FacebookManager.getInstance().onActivityResult(requestCode, resultCode, data);
                    break;
                }
                case 10001: {
                    CmdPayment.getInstance().handleResult(activity, requestCode, resultCode, data);
                    break;
                }
                case 20002: {
                    CmdDashboard.getInstance().handleResult(activity, requestCode, resultCode, data);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @TargetApi(value=19)
    public void onWindowFocusChanged(boolean hasFocus) {
        if (Build.VERSION.SDK_INT >= 19 && hasFocus) {
            activity.getWindow().getDecorView().setSystemUiVisibility(5126);
        }
    }

    public void login() {
        Log.i((String)TAG, (String)"login");
        if (GameConfigManager.getInstance().getGameConfig() == null) {
            this.getGameInfoRemote();
            return;
        }
        if (this.isLoggedIn()) {
            return;
        }
        shouldShowFloatButton = false;
        MobGameHelper.hideFloatButton();
        if (!this.isLoggedIn()) {
            Intent intent = new Intent((Context)activity, MobGameActivity.class);
            intent.putExtra(MobGameActivity.KEY_DATA, "[{'action':'" + Constants.URL_USER + "'}]");
            intent.putExtra(MobGameActivity.KEY_ENABLE_AUTOHIDE_HEADER_BAR, false);
            intent.putExtra(MobGameActivity.KEY_ENABLE_SIDE_MENU, false);
            activity.startActivity(intent);
        } else {
            this.handleLogin();
        }
    }

    public void logout() {
        Log.i((String)TAG, (String)"logout");
        new LogoutTask().execute(new Void[0]);
        MobGameHelper.hideFloatButton();
        this.countShowHello = 0;
        this.queuePopups.clear();
    }

    public void dashboard() {
        Log.i((String)TAG, (String)"dashboard");
        if (GameConfigManager.getInstance().getGameConfig() == null) {
            this.getGameInfoRemote();
            return;
        }
        if (!Utils.isDashboardEnabled((Context)activity)) {
            Log.i((String)TAG, (String)"Dashboard is disabled");
            return;
        }
        if (!this.isLoggedIn()) {
            Toast.makeText((Context)activity, (CharSequence)"You must login first", (int)0).show();
        } else {
            MobGameHelper.hideFloatButton();
            Intent intent = new Intent((Context)activity, MobGameActivity.class);
            activity.startActivity(intent);
        }
    }

    private void dashboard(String data) throws JSONException {
        Log.i((String)TAG, (String)("dashboard:" + data.toString()));
        if (GameConfigManager.getInstance().getGameConfig() == null) {
            this.getGameInfoRemote();
            return;
        }
        if (!Utils.isDashboardEnabled((Context)activity)) {
            Log.i((String)TAG, (String)"Dashboard is disabled");
            return;
        }
        if (!this.isLoggedIn()) {
            Toast.makeText((Context)activity, (CharSequence)"You must login first", (int)0).show();
        } else {
            MobGameHelper.hideFloatButton();
            Intent intent = new Intent((Context)activity, MobGameActivity.class);
            if (this.isJsonArray(data)) {
                intent.putExtra(MobGameActivity.KEY_DATA, data);
            } else {
                JSONObject jsonData = new JSONObject(data);
                boolean autohideHeaderBar = true;
                if (jsonData.has("autohide_header_bar")) {
                    autohideHeaderBar = jsonData.getBoolean("autohide_header_bar");
                }
                boolean enableSideMenu = true;
                if (jsonData.has("enable_side_menu")) {
                    enableSideMenu = jsonData.getBoolean("enable_side_menu");
                }
                intent.putExtra(MobGameActivity.KEY_DATA, jsonData.getJSONArray("items").toString());
                intent.putExtra(MobGameActivity.KEY_ENABLE_AUTOHIDE_HEADER_BAR, autohideHeaderBar);
                intent.putExtra(MobGameActivity.KEY_ENABLE_SIDE_MENU, enableSideMenu);
            }
            activity.startActivity(intent);
        }
    }

    private boolean isJsonArray(String strData) {
        try {
            JSONObject json = new JSONObject(strData);
            return false;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return true;
        }
    }

    public void payment() {
        this.payment(null);
    }

    public void payment(String state) {
        Log.i((String)TAG, (String)("payment:" + state));
        if (GameConfigManager.getInstance().getGameConfig() == null) {
            this.getGameInfoRemote();
            return;
        }
        if (!this.isLoggedIn()) {
            Toast.makeText((Context)activity, (CharSequence)"You must login first", (int)0).show();
        } else {
            MobGameHelper.hideFloatButton();
            String url = Constants.URL_PAYMENT;
            if (!TextUtils.isEmpty((CharSequence)state)) {
                url = url + "?state=" + state;
            }
            Log.d((String)TAG, (String)url);
            Intent intent = new Intent((Context)activity, MobGameActivity.class);
            intent.putExtra(MobGameActivity.KEY_DATA, "[{'action':'" + url + "'}]");
            intent.putExtra(MobGameActivity.KEY_ENABLE_AUTOHIDE_HEADER_BAR, false);
            intent.putExtra(MobGameActivity.KEY_ENABLE_SIDE_MENU, false);
            activity.startActivity(intent);
        }
    }

    public void showDialogSocial() {
        if (GameConfigManager.getInstance().getGameConfig() == null) {
            this.getGameInfoRemote();
            return;
        }
        if (!this.isLoggedIn()) {
            Toast.makeText((Context)activity, (CharSequence)"You must login first", (int)0).show();
        } else {
            GameConfigManager.getInstance().clearUnreadNotifications();
        }
    }

    public void close() {
        this.close(true);
    }

    private void close(boolean check) {
        Intent i = new Intent("com.mobgame.broadcast");
        i.putExtra("category", "dashboard_close");
        LocalBroadcastManager.getInstance((Context)activity).sendBroadcast(i);
        this.queuePopups.add(POPUP_FLOAT_BUTTON);
        if (check) {
            this.showPopup();
        }
    }

    public void setUserConfig(String mAreaId, String mAreaName, String mRoleId, String mRoleName) {
        Log.i((String)TAG, (String)("setUserConfig: area_id=" + mAreaId + ";role_id=" + mRoleId + ";area_name=" + mAreaName + ";role_name=" + mRoleName));
        new SaveCharacterTask(mAreaId, mAreaName, mRoleId, mRoleName).execute(new Void[0]);
    }

    public boolean isLoggedIn() {
        return !TextUtils.isEmpty((CharSequence)GameConfigManager.getInstance().getAccessToken());
    }

    private void handleLogin() {
        new GetInfoAfterAuthenTask(new GetInfoAfterAuthenTask.Listener(){

            @Override
            public void onSuccess(UserInfo userInfo) {
                GameConfigManager.getInstance().setUserInfo(userInfo);
                if (userInfo != null) {
                    String accountId = GameConfigManager.getInstance().getUserInfo().getUser().getAccountId();
                    String accessToken = GameConfigManager.getInstance().getAccessToken();
                    MobGameSDK.this.mListener.onLoginSuccessful(accountId, accessToken);
                    return;
                }
            }

            @Override
            public void onFailure(Throwable t) {
                MobGameSDK.this.logout();
                MobGameSDK.this.mListener.onError(10000, "Unable to login to MobGame server");
            }
        }).execute(new Void[0]);
    }

    public void callShowPopup() {
        this.showPopup();
    }

    private void showPopup() {
        if (this.queuePopups == null || this.queuePopups.isEmpty()) {
            return;
        }
        if (isShowingHello) {
            return;
        }
        if (this.menuId > 0) {
            MobMenuItem menuItem = GameConfigManager.getInstance().getMobMenu().getMobMenuItemById(this.menuId);
            this.menuId = -1;
            if (menuItem != null) {
                Intent intent = new Intent("com.mobgame.broadcast");
                intent.putExtra("category", menuItem.getCommand());
                intent.putExtra("data", menuItem.getParams());
                LocalBroadcastManager.getInstance((Context)activity.getApplicationContext()).sendBroadcast(intent);
                return;
            }
        }
        String popup = this.queuePopups.get(0);
        Log.d((String)TAG, (String)("Show popup: " + popup));
        this.queuePopups.remove(0);
        if (POPUP_HELLO.equalsIgnoreCase(popup)) {
            if (this.countShowHello < 2) {
                this.showHello(activity, 4000L, new Runnable(){

                    @Override
                    public void run() {
                        MobGameSDK.this.loginProcessDone = true;
                        MobGameSDK.this.showPopup();
                        Log.d((String)TAG, (String)"showHello 3:");
                    }
                });
            }
        } else if (POPUP_ACCOUNT.equalsIgnoreCase(popup)) {
            currentActivity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (MobGameSDK.this.dialog != null) {
                            MobGameSDK.this.dialog.dismiss();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    MobGameSDK.this.dialog = new MobGameUpgradeDialog(activity);
                    MobGameSDK.this.dialog.setCancelable(false);
                    MobGameSDK.this.dialog.setOnCancelClickListener(new View.OnClickListener(){

                        public void onClick(View arg0) {
                            Utils.hideLoading();
                            new Handler().postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    MobGameSDK.this.showPopup();
                                }
                            }, 1000L);
                        }
                    });
                    MobGameSDK.this.dialog.show();
                }
            });
        } else if (POPUP_NTFS.equalsIgnoreCase(popup)) {
            ArrayList<Integer> ids = Utils.getNtfs(MobGameSDK.getApplicationContext());
            ArrayList<MobMenuItem> menuItems = GameConfigManager.getInstance().getMobMenu().getMobMenuItemsByIds(ids);
            if (menuItems.size() > 0 && !menuItems.isEmpty()) {
                MobMenuItem menuItem = menuItems.get(0);
                for (int i = 1; i < menuItems.size(); ++i) {
                    if (menuItems.get(i).getPriority() <= menuItem.getPriority()) continue;
                    menuItem = menuItems.get(i);
                    Log.e((String)TAG, (String)("menuItem value:" + menuItem));
                }
                this.close(false);
                final MobMenuItem fMenuItem = menuItem;
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Intent intent = new Intent("com.mobgame.broadcast");
                        intent.putExtra("category", fMenuItem.getCommand());
                        intent.putExtra("data", fMenuItem.getParams());
                        LocalBroadcastManager.getInstance((Context)activity.getApplicationContext()).sendBroadcast(intent);
                    }
                }, 500L);
            } else {
                this.close(false);
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        MobGameSDK.this.dashboard();
                    }
                }, 500L);
            }
        } else if (POPUP_FLOAT_BUTTON.equalsIgnoreCase(popup)) {
            shouldShowFloatButton = true;
            Intent intent = new Intent("com.mobgame.broadcast");
            intent.putExtra("category", "float_button");
            LocalBroadcastManager.getInstance((Context)activity).sendBroadcast(intent);
            this.showPopup();
        }
    }

    public void setMobGameListener(MobGameListener listener) {
        MobGameListener onLoginListener;
        final MobGameListener fl = listener;
        this.mListener = onLoginListener = new MobGameListener(){

            @Override
            public void onLoginSuccessful(String accID, String token) {
                MobGameSDK.this.countShowHello = 1;
                Log.i((String)TAG, (String)"OnLoginListener::onLoginSuccessful");
                Log.i((String)TAG, (String)("accountID = " + accID + "; accessToken = " + token));
                String userId = GameConfigManager.getInstance().getUserInfo().getUser().getUserId();
                if (userId != null) {
                    // empty if block
                }
                MobGameSDK.this.close(false);
                MobGameHelper.hideFloatButton();
                MobGameSDK.this.queuePopups.clear();
                MobGameSDK.this.queuePopups.add(MobGameSDK.POPUP_HELLO);
                UserInfo.UserDaily userDaily = GameConfigManager.getInstance().getUserInfo().getUserDaily();
                int typeHello = userDaily.getTypeHello();
                if (typeHello >= 2) {
                    MobGameSDK.this.queuePopups.add(MobGameSDK.POPUP_ACCOUNT);
                }
                if (Utils.hasNtf((Context)activity)) {
                    MobGameSDK.this.queuePopups.add(MobGameSDK.POPUP_NTFS);
                }
                MobGameSDK.this.queuePopups.add(MobGameSDK.POPUP_FLOAT_BUTTON);
                MobGameSDK.this.showPopup();
                MobGameHelper.updateFloatButtonMenu();
                MobGameGCMIntentService.register((Context)activity);
                fl.onLoginSuccessful(accID, token);
            }

            @Override
            public void onPaySuccessful(String userId, String orderId, String orderProduct, String orderInfo, String orderTime, String platformPrice, String gamePrice, String state, String game_role_id, String game_area_id, String is_sandbox) {
                try {
                    double price = 0.01 * Double.parseDouble(platformPrice);
                    HashMap<String, Object> eventValue = new HashMap<String, Object>();
                    eventValue.put("af_revenue", price);
                    eventValue.put("af_content_type", "category_rev");
                    eventValue.put("af_content_id", "123456");
                    eventValue.put("af_currency", "USD");
                    AppsFlyerLib.getInstance().trackEvent(currentActivity.getApplicationContext(), "af_purchase", eventValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                fl.onPaySuccessful(userId, orderId, orderProduct, orderInfo, orderTime, platformPrice, gamePrice, state, game_role_id, game_area_id, is_sandbox);
                MobGameSDK.this.isShowAds = false;
            }

            @Override
            public void onError(int errorCode, String message) {
            }
        };
    }

    private boolean isShowPopupUpgrade() {
        if (this.dialog != null) {
            return !this.dialog.isShowing();
        }
        return true;
    }

    private void getGameInfoRemote() {
        if (this.mGetInfoBeforeAuthenTask != null && !this.mGetInfoBeforeAuthenTask.isCancelled()) {
            this.mGetInfoBeforeAuthenTask.cancel(true);
        }
        this.mGetInfoBeforeAuthenTask = new GetInfoBeforeAuthenTask(new GetInfoBeforeAuthenTask.Listener(){

            @Override
            public void onSuccess(Game gameConfig) {
                if (gameConfig == null) {
                    MobGameSDK.this.onGetGameInfoRemoteFailed();
                } else {
                    GameConfigManager.getInstance().setGameConfig(gameConfig);
                    if (MobGameSDK.this.isLoggedIn()) {
                        MobGameSDK.this.handleLogin();
                    }
                }
            }

            @Override
            public void onFailure(Throwable t) {
                t.printStackTrace();
                MobGameSDK.this.onGetGameInfoRemoteFailed();
            }
        });
        this.mGetInfoBeforeAuthenTask.execute(new Void[0]);
    }

    private void onGetGameInfoRemoteFailed() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)Utils.getContextThemeWrapper((Context)activity));
        builder.setCancelable(false);
        builder.setMessage((CharSequence)Res.string((Context)activity, R.string.unable_to_connect));
        builder.setPositiveButton((CharSequence)Res.string((Context)activity, R.string.retry), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MobGameSDK.this.getGameInfoRemote();
            }
        });
        builder.setNegativeButton((CharSequence)Res.string((Context)activity, R.string.exit), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Intent intent = new Intent("android.intent.action.MAIN");
                intent.addCategory("android.intent.category.HOME");
                intent.setFlags(0x10000000);
                activity.startActivity(intent);
            }
        });
        builder.show();
    }

    public void showHello(Activity activity) {
        this.showHello(activity, 3000L, null);
    }

    public void showHello(final Activity activity, long duration, final Runnable afterHideRunnable) {
        try {
            if (activity == null) {
                return;
            }
            if (isShowingHello) {
                return;
            }
            final String username = GameConfigManager.getInstance().getUserInfo().getUser().getUserName();
            Log.i((String)TAG, (String)("showHello:" + username));
            activity.runOnUiThread(new Runnable(){

                @Override
                @SuppressLint(value={"InflateParams"})
                public void run() {
                    try {
                        Utils.hideLoading();
                        ViewGroup rootView = (ViewGroup)activity.findViewById(0x1020002);
                        LayoutInflater inflater = LayoutInflater.from((Context)activity);
                        helloView = inflater.inflate(R.layout.layout_processing, null);
                        ImageView img = (ImageView)helloView.findViewById(R.id.imv_loading);
                        Drawable imgDrawable = Res.drawable((Context)activity, R.drawable.logo_sm);
                        img.setImageDrawable(imgDrawable);
                        TextView tv = (TextView)helloView.findViewById(R.id.txt_status);
                        tv.setText((CharSequence)(Res.string((Context)activity, R.string.hello) + ", " + username));
                        try {
                            UserInfo.UserDaily userDaily = GameConfigManager.getInstance().getUserInfo().getUserDaily();
                            String title = userDaily.getTitle();
                            int coin = userDaily.getCoin();
                            if (coin > 0) {
                                View layoutMobCoin = helloView.findViewById(R.id.layout_mobcoin);
                                layoutMobCoin.setVisibility(0);
                                TextView tvMobCoinActivity = (TextView)helloView.findViewById(R.id.txt_mobcoin_activity);
                                tvMobCoinActivity.setText((CharSequence)title);
                                TextView tvMobCoin = (TextView)helloView.findViewById(R.id.txt_mobcoin_value);
                                tvMobCoin.setText((CharSequence)("+" + coin));
                            } else {
                                View layoutMobCoin = helloView.findViewById(R.id.layout_mobcoin);
                                layoutMobCoin.setVisibility(8);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        rootView.addView(helloView);
                        if (helloView.getParent() == null) {
                            rootView.addView(helloView);
                        }
                        helloView.startAnimation(AnimationUtils.loadAnimation((Context)activity, (int)R.anim.top_in));
                        isShowingHello = true;
                        MobGameSDK.this.countShowHello = MobGameSDK.this.countShowHello + 1;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    MobGameSDK.this.hideHello(activity, true);
                    if (afterHideRunnable != null) {
                        afterHideRunnable.run();
                    }
                }
            }, duration + 500L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hideHello(final Activity activity, boolean isAnimated) {
        isShowingHello = false;
        ++this.countShowHello;
        if (isAnimated) {
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    Animation animation = AnimationUtils.loadAnimation((Context)activity, (int)R.anim.top_out);
                    helloView.startAnimation(animation);
                }
            });
        }
    }

    private static enum StatusAd {
        AD_INIT,
        AD_LOADING,
        AD_OPENED,
        AD_LOADED,
        AD_CLOSED,
        AD_ERROR,
        AD_SHOWING;

    }
}

