package com.mobgame.gui;

import java.util.Set;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import android.app.Activity;
import android.app.Dialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.facebook.AccessToken;
import com.mobgame.R;
import com.mobgame.api.UpgradeToFacebookTask;
import com.mobgame.component.FacebookManager;
import com.mobgame.component.GameConfigManager;
import com.mobgame.model.LoginResponse;
import com.mobgame.model.MobAccessToken;
import com.mobgame.model.UserInfo;
import com.mobgame.utils.Constants;
import com.mobgame.utils.Res;
import com.mobgame.utils.Utils;

public class MobGameUpgradeDialog extends Dialog {
	
//	private static final String TAG = MobGameUpgradeDialog.class.getSimpleName();

	private Activity activity;
	private TextView txtAlert, txtBonusFacebook, txtBonusEmail, txtBonusInfo, txtConnect;
	private Button btnUpgrade, btnRegisterEmail, btnUpgradeInfo, btnCancel;
	
	long startTime = 0;
    Handler timerHandler = new Handler();
    Runnable timerRunnable = new Runnable() {

        @Override
        public void run() {
            long millis = System.currentTimeMillis() - startTime;
            int seconds = (int) (millis / 1000);
            seconds = seconds % 60;

            if (seconds <= 10) {
            	if (btnCancel != null) {
                	btnCancel.setText(Res.string(activity, R.string.remind_me) + " (" + (10 - seconds) + "s)");
                }
            	timerHandler.postDelayed(this, 1000);
            } else {
            	if (isShowing()) {
	            	mOnCancelClickListener.onClick(btnCancel);
	            	dismiss();
            	}
            }
        }
    };
	
	public MobGameUpgradeDialog(Activity a) {
		super(a, R.style.MobUpgradeDialog);
		this.activity = a;
	}
	
	public MobGameUpgradeDialog(Activity a, int themeResId) {
		super(a, R.style.MobUpgradeDialog);
		this.activity = a;
	}

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		requestWindowFeature(Window.FEATURE_NO_TITLE);
		setContentView(R.layout.dialog_upgrade);
		
		Window dialog_window = getWindow();
		dialog_window.setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);

		btnUpgrade = (Button) findViewById(R.id.btn_upgrade_facebook);
		btnRegisterEmail = (Button) findViewById(R.id.btn_register_email);
		btnUpgradeInfo = (Button) findViewById(R.id.btn_upgrade_info);
		btnCancel = (Button) findViewById(R.id.btn_cancel);
		txtAlert = (TextView) findViewById(R.id.txt_alert);
		txtConnect = (TextView) findViewById(R.id.txt_connect_with_facebook_tip);
		txtBonusFacebook = (TextView) findViewById(R.id.txt_mobcoin_facebook);
		txtBonusEmail = (TextView) findViewById(R.id.txt_mobcoin_email);
		txtBonusInfo = (TextView) findViewById(R.id.txt_mobcoin_info);

		txtAlert.setText(Res.string(activity, R.string.notice));
		btnRegisterEmail.setText(Res.string(activity, R.string.bind_account));
		btnUpgradeInfo.setText(Res.string(activity, R.string.complete_now));
		btnCancel.setText(Res.string(activity, R.string.remind_me));

		UserInfo userInfo = GameConfigManager.getInstance().getUserInfo();
		UserInfo.UserDaily userDaily = null;
		if(userInfo != null){
			userDaily = userInfo.getUserDaily();
		}
		
		if(userDaily == null){
			return;
		}
		
		if (!TextUtils.isEmpty(userDaily.getTooltip())) {
			txtConnect.setVisibility(View.VISIBLE);
			txtConnect.setText(userDaily.getTooltip());
		} else {
			txtConnect.setVisibility(View.GONE);
		}

		btnCancel.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				dismiss();
				if (mOnCancelClickListener != null) {
					mOnCancelClickListener.onClick(v);
				}
			}
		});

		int typeHello = userDaily.getTypeHello();
		// 2 : upgrade facebook
		// 3 : update personal info
		// 4 : upgrade facebook + register email
		if (typeHello == 2) {

			if (userDaily.getBonusFacebook() > 0) {
				txtBonusFacebook.setText("+" + userDaily.getBonusFacebook());
				txtBonusFacebook.setVisibility(View.VISIBLE);
			}
			
			btnUpgrade.setVisibility(View.VISIBLE);
			btnUpgrade.setOnClickListener(new View.OnClickListener() {
				public void onClick(View v) {
					
					if (timerHandler != null) {
						timerHandler.removeCallbacks(timerRunnable);
						btnCancel.setText(Res.string(activity, R.string.remind_me));
					}
					
					Utils.showLoading(activity, Res.string(activity, R.string.connecting_facebook));
					
					FacebookManager.getInstance().login(activity, mFacebookCallback);
				}
			});
		} else if (typeHello == 3) {

			if (userDaily.getBonusInfo() > 0) {
				txtBonusInfo.setText("+" + userDaily.getBonusInfo());
				txtBonusInfo.setVisibility(View.VISIBLE);
			}

			final String fUrl = userDaily.getUpdateInfoDetails().getUrl();
			final int fType = userDaily.getUpdateInfoDetails().getType();
			btnUpgradeInfo.setVisibility(View.VISIBLE);
			btnUpgradeInfo.setOnClickListener(new View.OnClickListener() {
				public void onClick(View v) {
					dismiss();
					Intent i = new Intent(Constants.INTENT_FILTER);
					i.putExtra("category", "MobGameUpgradeDialog.btnUpgradeInfo");
					LocalBroadcastManager.getInstance(activity).sendBroadcast(i);
					if (fType == 2) {
						Intent intent = new Intent(Constants.INTENT_FILTER);
						intent.putExtra("category", "mobOpenBrowser");
						intent.putExtra("data", "{url:'" + fUrl + "'}");
						LocalBroadcastManager.getInstance(activity.getApplicationContext())
							.sendBroadcast(intent);
					} else if (fType == 1) {
						Intent intent = new Intent(Constants.INTENT_FILTER);
						intent.putExtra("category", "dashboard");
						intent.putExtra("data", "{items:[{action:'" + fUrl + "'}], autohide_header_bar:false, enable_side_menu:false}");
						LocalBroadcastManager.getInstance(activity.getApplicationContext())
							.sendBroadcast(intent);
					}

				}
			});
		} else if (typeHello == 4) {
			
			if (userDaily.getBonusFacebook() > 0) {
				txtBonusFacebook.setText("+" + userDaily.getBonusFacebook());
				txtBonusFacebook.setVisibility(View.VISIBLE);
			}

			if (userDaily.getBonusEmail() > 0) {
				txtBonusEmail.setText("+" + userDaily.getBonusEmail());
				txtBonusEmail.setVisibility(View.VISIBLE);
			}
			
			btnUpgrade.setVisibility(View.VISIBLE);
			btnUpgrade.setOnClickListener(new View.OnClickListener() {
				public void onClick(View v) {

					if (timerHandler != null) {
						timerHandler.removeCallbacks(timerRunnable);
						btnCancel.setText(Res.string(activity, R.string.remind_me));
					}

					Utils.showLoading(activity, Res.string(activity, R.string.connecting_facebook));
					
					FacebookManager.getInstance().login(activity, mFacebookCallback);
				}
			});
			
			final String fUrl = userDaily.getUpgradeEmailDetails().getUrl();
			final int fType = userDaily.getUpgradeEmailDetails().getType();
			btnRegisterEmail.setVisibility(View.VISIBLE);
			btnRegisterEmail.setOnClickListener(new View.OnClickListener() {
				public void onClick(View v) {
					dismiss();
					if (fType == 2) {
						Intent intent = new Intent(Constants.INTENT_FILTER);
						intent.putExtra("category", "mobOpenBrowser");
						intent.putExtra("data", "{url:'" + fUrl + "'}");
						LocalBroadcastManager.getInstance(activity.getApplicationContext())
							.sendBroadcast(intent);
					} else if (fType == 1) {
						Intent intent = new Intent(Constants.INTENT_FILTER);
						intent.putExtra("category", "dashboard");
						intent.putExtra("data", "{items:[{action:'" + fUrl + "'}], autohide_header_bar:false, enable_side_menu:false}");
						LocalBroadcastManager.getInstance(activity.getApplicationContext())
							.sendBroadcast(intent);
					}
				}
			});
		}
		
		setOnShowListener(new OnShowListener() {
			
			@Override
			public void onShow(DialogInterface dialog) {
				startTime = System.currentTimeMillis();
		        timerHandler.postDelayed(timerRunnable, 500);

		        Intent intent = new Intent(Constants.INTENT_FILTER);
				intent.putExtra("category", "float_button");
				intent.putExtra("message", "hide");
				LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);	
			}
		});
		
	}
	
	View.OnClickListener mOnCancelClickListener;
	public void setOnCancelClickListener(View.OnClickListener listener) {
		mOnCancelClickListener = listener;
		if (btnCancel != null) {
			btnCancel.setOnClickListener(listener);
		}
	}

	private FacebookManager.LoginCallback mFacebookCallback = new FacebookManager.LoginCallback() {
		
		@Override
		public void onSuccess(AccessToken accessToken,
				Set<String> recentlyGrantedPermissions,
				Set<String> recentlyDeniedPermissions) {

			new UpgradeToFacebookTask(accessToken.getToken(), new Callback<LoginResponse>() {

				@Override
				public void onFailure(Call<LoginResponse> call, Throwable e) {
					handleException(activity, e.getMessage());
				}

				@Override
				public void onResponse(Call<LoginResponse> call, Response<LoginResponse> response) {
					LoginResponse loginResponse = response.body();
					if (loginResponse.getError() != 0) {
						handleException(activity, loginResponse.getMessage());
					} else {
						MobAccessToken accessToken = loginResponse.getAccessToken();
						GameConfigManager.getInstance().setAccessToken(accessToken.getToken());
						
						Intent intent = new Intent(Constants.INTENT_FILTER);
						intent.putExtra("category", "login");
						LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
						
						dismiss();
					}
				}
			})
			.execute();
		}
		
		@Override
		public void onError(Throwable t) {
			// TODO Auto-generated method stub
			
		}
		
		@Override
		public void onCancel() {
			// TODO Auto-generated method stub
			
		}
	};
	
	
	private void handleException(Activity activity, String message) {
		Toast.makeText(activity, message, Toast.LENGTH_LONG).show();
		Utils.hideLoading();
	}
	
	@Override
		public void show() {
		UserInfo userInfo = GameConfigManager.getInstance().getUserInfo();
		if(userInfo != null){
			super.show();
		}
	}
	
}
