package com.mobgame.component;

import android.app.Activity;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;

import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GoogleAuthUtil;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.GoogleSignInResult;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.Scopes;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.mobgame.utils.Constants;

import java.io.IOException;

public class GoogleAuthManager {

	private final static String TAG = GoogleAuthManager.class.getSimpleName();
	private static final int REQUEST_GOOGLE_PLAY_SERVICES = 412;
	private static GoogleAuthManager INSTANCE;

	private GoogleApiClient mGoogleApiClient;
	private boolean mResolvingError = false;
	private GooglePlusResultCallback googlePlusResultCallback;
	private Activity activity;
	private String SCOPE = "oauth2:https://www.googleapis.com/auth/userinfo.profile";
	//

	public static GoogleAuthManager getInstance() {
		if (INSTANCE == null) {
			INSTANCE = new GoogleAuthManager();
		}
		return INSTANCE;
	}

	private GoogleAuthManager() {
	}

	void init(Activity activity) {
		this.activity = activity;
        this.initGoogleClient(activity);
	}

	public void onActivityResult(int requestCode, int resultCode, Intent data) {
		Log.d(TAG, "Google Login Intent data: " + data);
        switch (requestCode){
            case REQUEST_GOOGLE_PLAY_SERVICES:
                this.initGoogleClient(activity);
                break;

            case 123:
                mResolvingError = false;
                if (resultCode == 0) {
                    // Make sure the app is not already connected or attempting to connect
                    if (!mGoogleApiClient.isConnecting() && !mGoogleApiClient.isConnected()) {
                        mGoogleApiClient.connect();
                    }
                }
                break;

            case Constants.REQUEST_CODE_LOGIN_PLAY_SERVICES:
                GoogleSignInResult result = Auth.GoogleSignInApi.getSignInResultFromIntent(data);
                if (result.isSuccess()) {
                    // Signed in successfully, show authenticated UI.

                    GoogleSignInAccount acct = result.getSignInAccount();
                    if (googlePlusResultCallback != null)
                        new GetToken(activity,SCOPE,acct.getEmail(),acct,googlePlusResultCallback).execute();

                } else {

                    Log.wtf("TAG", "onActivityResult: " + result.getStatus().isSuccess() + " "
                            + result.getStatus().getStatusMessage() + " " + result.getStatus().getStatusCode());
                    // Signed out, show unauthenticated UI.
                    if (googlePlusResultCallback != null)
                        googlePlusResultCallback.onLoginError(result.getStatus().getStatusMessage());
                }
                break;
        }

		logout();
	}

    private void initGoogleClient(Activity activity) {
        if (mGoogleApiClient == null || mGoogleApiClient.isConnected()) {
            GoogleSignInOptions gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN)
                    .requestEmail()
                    .requestScopes(new Scope(Scopes.PLUS_ME))
                    .requestScopes(new Scope(Scopes.PLUS_LOGIN))
                    .build();

            mGoogleApiClient = new GoogleApiClient.Builder(this.activity)
                    .addConnectionCallbacks(mConnectionCallbacks)
                    .addOnConnectionFailedListener(mOnConnectionFailedListener)
                    .addApi(Auth.GOOGLE_SIGN_IN_API, gso)
                    .build();
        } else {
            mGoogleApiClient.disconnect();
        }
    }

    public void login(Activity activity, GooglePlusResultCallback callback) {
		this.googlePlusResultCallback = callback;
		Intent signInIntent = Auth.GoogleSignInApi.getSignInIntent(mGoogleApiClient);
		activity.startActivityForResult(signInIntent, Constants.REQUEST_CODE_LOGIN_PLAY_SERVICES);
	}

	public boolean isGoogleServiceAvailable(Activity activity) {
        GoogleApiAvailability googleAPI = GoogleApiAvailability.getInstance();
        int result = googleAPI.isGooglePlayServicesAvailable(activity);
        if(result != ConnectionResult.SUCCESS) {
            if(googleAPI.isUserResolvableError(result)) {
                googleAPI.getErrorDialog(activity, result,
                        REQUEST_GOOGLE_PLAY_SERVICES).show();
            }

            return false;
        }

        return true;
    }

	public void logout() {
		if (mGoogleApiClient != null && mGoogleApiClient.isConnected()) {
			mGoogleApiClient.disconnect();
		}
	}

	private GoogleApiClient.ConnectionCallbacks mConnectionCallbacks =
			new GoogleApiClient.ConnectionCallbacks() {

				@Override
				public void onConnected(Bundle bundle) {
//			Log.i(TAG, "onConnected:" + bundle + "; " + Plus.AccountApi.getAccountName(mGoogleApiClient));
					try {

					} catch (Exception e) {
						Log.wtf("ERROR", "WTF: " + e.getLocalizedMessage());
						e.printStackTrace();
						mGoogleApiClient.disconnect();
					}
				}

				@Override
				public void onConnectionSuspended(int arg0) {
				}

			};

	private GoogleApiClient.OnConnectionFailedListener mOnConnectionFailedListener =
			new GoogleApiClient.OnConnectionFailedListener() {

				@Override
				public void onConnectionFailed(ConnectionResult result) {
//                    Log.i(TAG, "onConnectionFailed:" + result);
//                    if (mResolvingError) {
//                        // Already attempting to resolve an error.
//                        return;
//                    } else if (result.hasResolution()) {
//                        try {
//                            mResolvingError = true;
//                            result.startResolutionForResult(MobGameSDK.activity, 123);
//                        } catch (IntentSender.SendIntentException e) {
//                            // There was an error with the resolution intent. Try again.
//                            mGoogleApiClient.connect();
//                        }
//                    } else {
//                        // Show dialog using GoogleApiAvailability.getErrorDialog()
//                        Log.wtf("ERROR", result.getErrorMessage());
//                        mResolvingError = true;
//                        if (googlePlusResultCallback != null)
//                            googlePlusResultCallback.onLoginError(result.getErrorMessage());
//                    }

					Log.i("[ ** Google ** ]", " -- Connection failed -- ");
					if(!result.hasResolution()){
						Log.i("[ *** Err Code *** ]", String.valueOf( result.getErrorCode() ) );
					}

				}
			};

	public interface GooglePlusResultCallback {
		void onLoginSuccess(GoogleSignInAccount account, String mToken);

		void onLoginError(String mess);
	}

	public String getToken(Activity activity, String email, String scope) throws IOException, GoogleAuthException {
		return GoogleAuthUtil.getToken(activity, email, scope);
	}

	class GetToken extends AsyncTask<Void,Void,String>{

		Activity mActivity;
		String mScope;
		String mEmail;
		GooglePlusResultCallback mCallback;
		GoogleSignInAccount mGogleSignin;

		public GetToken(Activity activity, String scope, String email,GoogleSignInAccount googleSignInAccount
				,GooglePlusResultCallback callback){

			this.mActivity = activity;
			this.mScope = scope;
			this.mEmail = email;
			this.mCallback = callback;
			this.mGogleSignin = googleSignInAccount;

		}
		@Override
		protected String doInBackground(Void... params) {

			try {
				return getToken(activity,mEmail,mScope);
			} catch (IOException e) {
				e.printStackTrace();
			} catch (GoogleAuthException e) {
				e.printStackTrace();
			}
			return "";
		}

		@Override
		protected void onPostExecute(String aVoid) {
			super.onPostExecute(aVoid);
			if(!TextUtils.isEmpty(aVoid))
				mCallback.onLoginSuccess(mGogleSignin,aVoid);
		}
	}


}
