/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui.dialog;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.DialogFragment;
import android.app.FragmentManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AlertDialog;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.game.sdk.comon.config.AuthenConfigs;
import com.game.sdk.comon.config.GameConfigs;
import com.game.sdk.comon.js.JsHandler;
import com.game.sdk.comon.object.SdkConfigObj;
import com.game.sdk.comon.utils.DeviceUtils;
import com.game.sdk.comon.utils.LogUtils;
import com.game.sdk.comon.utils.Utils;
import com.game.sdk.comon.utils.WvUtil;
import com.mobgame.MobGameHelper;
import com.mobgame.MobGameSDK;
import com.mobgame.R;
import com.mobgame.api.PostTask;
import com.mobgame.gui.MobGameWebViewDetail;
import com.mobgame.gui.dialog.MobGameConfirmDialog;
import com.mobgame.gui.dialog.MobGameDialogWebviewFragment;
import com.mobgame.model.MUrl;
import com.mobgame.utils.Preference;
import com.mobgame.utils.Res;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;

public class MobGameDialogStartWebFragment
extends DialogFragment {
    private static final String TAG = MobGameDialogWebviewFragment.class.getName();
    private Activity activity;
    private MobGameWebViewDetail webView;
    private ProgressBar mProgressView;
    private ImageButton dialogCloseButton;
    public static final String DIALOG_WEBVIEW_TYPE_WEBVIEW_DETAIL = "webview_detail";
    public static final String DIALOG_WEBVIEW_TYPE_ADS = "webview_ads";
    private String type;
    private int orientation;
    private String webview_detail_url;
    private String webview_detail_title;
    private JsHandler jsHandler;
    private boolean saveReaded;
    private View dialogView;
    private int selectButton = 0;
    private DialogInterface.OnDismissListener mOnDismissListener;
    private MobGameDialogWebviewFragment.EventListener eventListeners;
    private static HashMap<String, MUrl> cachedUrls;
    boolean isCheck;
    private BroadcastReceiver mMessageReceiver;
    private final int DefaultKeyboardDP = 100;
    private final int EstimatedKeyboardDP;
    private int heightDiff;
    private boolean wasOpened;

    public MobGameDialogStartWebFragment() {
        cachedUrls = new HashMap();
        this.isCheck = false;
        this.mMessageReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                try {
                    String action = intent.getAction();
                    if (action == null) {
                        return;
                    }
                    switch (action) {
                        case "UploadBitmap": {
                            try {
                                String result = intent.getExtras().getString("result");
                                Log.d((String)TAG, (String)("onReceive: " + result));
                                if (MobGameDialogStartWebFragment.this.webView != null) {
                                    String jsFunction = String.format("loadImage('%s');", result);
                                    Log.d((String)TAG, (String)("onReceive: " + jsFunction));
                                    MobGameDialogStartWebFragment.this.invokeJavascript(jsFunction);
                                    break;
                                }
                                Log.d((String)TAG, (String)"onReceive: webview = null");
                                break;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    String message = intent.getStringExtra("message");
                    Log.d((String)"receiver", (String)("Got message: " + message));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.DefaultKeyboardDP = 100;
        this.EstimatedKeyboardDP = 100 + (Build.VERSION.SDK_INT >= 21 ? 48 : 0);
        this.heightDiff = 0;
    }

    @SuppressLint(value={"ValidFragment"})
    public MobGameDialogStartWebFragment(Activity activity, boolean isShowAds, boolean saveRead) {
        cachedUrls = new HashMap();
        this.isCheck = false;
        this.mMessageReceiver = new /* invalid duplicate definition of identical inner class */;
        this.DefaultKeyboardDP = 100;
        this.EstimatedKeyboardDP = 100 + (Build.VERSION.SDK_INT >= 21 ? 48 : 0);
        this.heightDiff = 0;
        this.activity = activity;
        this.saveReaded = saveRead;
        this.type = DIALOG_WEBVIEW_TYPE_ADS;
        this.setStyle(1, R.style.Theme_AppCompat_Translucent_FullScreen);
    }

    @SuppressLint(value={"ValidFragment"})
    public MobGameDialogStartWebFragment(Activity activity, String title, String url) {
        cachedUrls = new HashMap();
        this.isCheck = false;
        this.mMessageReceiver = new /* invalid duplicate definition of identical inner class */;
        this.DefaultKeyboardDP = 100;
        this.EstimatedKeyboardDP = 100 + (Build.VERSION.SDK_INT >= 21 ? 48 : 0);
        this.heightDiff = 0;
        Log.d((String)TAG, (String)("Reload 1 : " + url));
        this.activity = activity;
        this.webview_detail_url = url;
        this.webview_detail_title = title;
        this.type = DIALOG_WEBVIEW_TYPE_WEBVIEW_DETAIL;
        this.setType(this.type);
        this.setStyle(1, R.style.Theme_AppCompat_Translucent_FullScreen);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            this.orientation = DeviceUtils.getScreenOrientation((Context)this.getActivity());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onPause() {
        if (this.activity != null && this.activity.getApplicationContext() != null) {
            LocalBroadcastManager.getInstance((Context)this.activity.getApplicationContext()).unregisterReceiver(this.mMessageReceiver);
        }
        super.onPause();
    }

    public void onResume() {
        if (this.activity != null && this.activity.getApplicationContext() != null) {
            LocalBroadcastManager.getInstance((Context)this.activity.getApplicationContext()).registerReceiver(this.mMessageReceiver, new IntentFilter("UploadBitmap"));
        }
        super.onResume();
        this.handlerBackButton();
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            this.dialogCloseButton = (ImageButton)this.dialogView.findViewById(R.id.btn_dialog_close);
            this.mProgressView = (ProgressBar)this.dialogView.findViewById(R.id.loading_progress);
            this.webView = (MobGameWebViewDetail)this.dialogView.findViewById(R.id.dialog_webview);
            WindowManager.LayoutParams params = this.getDialog().getWindow().getAttributes();
            params.height = -1;
            params.width = -1;
            this.getDialog().getWindow().setAttributes(params);
            this.getDialog().getWindow().setSoftInputMode(48);
            this.initWebview();
            Log.d((String)TAG, (String)("onCreateDialog: activity name: " + this.activity.getClass().getName()));
            this.dialogCloseButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    MobGameDialogStartWebFragment.this.closeDialog();
                }
            });
            if (this.type.equals(DIALOG_WEBVIEW_TYPE_ADS)) {
                this.showMobAds();
            } else if (this.type.equals(DIALOG_WEBVIEW_TYPE_WEBVIEW_DETAIL)) {
                this.dialogCloseButton.setVisibility(0);
                this.showWebViewDetail(this.webview_detail_title, this.webview_detail_url);
            }
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity(), R.style.Theme_AppCompat_Translucent);
            builder.setView(this.dialogView);
            MobGameSDK.getInstance().unRegisterSensor();
            this.setKeyboardListener();
            SdkConfigObj game = GameConfigs.getInstance().getSdkConfig();
            if (game != null && game.getEx() != null && game.getEx().isShowLogo()) {
                MobGameHelper.hideNotiFloatButton();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.dialogView = inflater.inflate(R.layout.dialog_after_login, null);
        return this.dialogView;
    }

    public void onDetach() {
        super.onDetach();
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss(dialog);
        }
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }

    private void closeDialog() {
        try {
            SdkConfigObj game;
            if (Preference.getBoolean((Context)this.activity, "shared_pref_hide_float_button", true) && this.type.equals(DIALOG_WEBVIEW_TYPE_ADS) && (game = GameConfigs.getInstance().getSdkConfig()) != null && game.getEx() != null && game.getEx().isShowLogo()) {
                MobGameHelper.showNotiFloatButton(game.getEx());
            }
            if (this.isCheck) {
                this.webView.getSettings().setJavaScriptEnabled(true);
                if (Build.VERSION.SDK_INT >= 19) {
                    this.webView.evaluateJavascript("checkFormData()", (ValueCallback)new ValueCallback<String>(){

                        public void onReceiveValue(String s) {
                            Log.d((String)TAG, (String)("onReceiveValue: " + s));
                            if (s != null) {
                                if (s.contains("1")) {
                                    MobGameConfirmDialog dialog = new MobGameConfirmDialog(MobGameDialogStartWebFragment.this.activity, Res.string((Context)MobGameDialogStartWebFragment.this.activity, R.string.do_you_want_close), MobGameDialogStartWebFragment.this.activity.getString(R.string.ok), Res.string((Context)MobGameDialogStartWebFragment.this.activity, R.string.cancel), new MobGameConfirmDialog.EventListener(){

                                        @Override
                                        public void onConfirmClick(View v) {
                                            MobGameDialogStartWebFragment.this.dismiss();
                                        }

                                        @Override
                                        public void onCancelClick(View v) {
                                        }
                                    });
                                    dialog.show(MobGameDialogStartWebFragment.this.activity.getFragmentManager(), "tag_fragment_confirm");
                                } else {
                                    MobGameDialogStartWebFragment.this.dismiss();
                                }
                            }
                        }
                    });
                }
            } else {
                this.dismiss();
            }
            if (Preference.getBoolean((Context)this.activity, "save_ads", false)) {
                Preference.save((Context)this.activity, "save_ads", false);
                MobGameSDK.getInstance().showPopup();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "JavascriptInterface", "ClickableViewAccessibility"})
    private void initWebview() {
        try {
            this.webView.getSettings().setJavaScriptEnabled(true);
            this.webView.setBackgroundColor(0);
            this.webView.setInitialScale((int)DeviceUtils.getDensity((Context)this.getActivity()));
            WebSettings webSettings = this.webView.getSettings();
            webSettings.setJavaScriptEnabled(true);
            webSettings.setLightTouchEnabled(true);
            webSettings.setDomStorageEnabled(true);
            webSettings.setBuiltInZoomControls(false);
            webSettings.setAllowFileAccess(true);
            webSettings.setDatabaseEnabled(true);
            webSettings.setCacheMode(-1);
            webSettings.setRenderPriority(WebSettings.RenderPriority.HIGH);
            this.webView.setScrollBarStyle(0);
            webSettings.setDomStorageEnabled(true);
            webSettings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
            webSettings.setUseWideViewPort(true);
            webSettings.setSaveFormData(true);
            webSettings.setLoadWithOverviewMode(true);
            webSettings.setUseWideViewPort(true);
            webSettings.setLoadsImagesAutomatically(true);
            this.jsHandler = new JsHandler(this.activity, this);
            this.webView.addJavascriptInterface(this.jsHandler, "JsHandler");
            this.jsHandler.mobAppSDKexecute("mobGetError", "");
            this.webView.setWebChromeClient(new WebChromeClient(){

                public void onProgressChanged(WebView view, int progress) {
                    if (MobGameDialogStartWebFragment.this.eventListeners != null) {
                        MobGameDialogStartWebFragment.this.eventListeners.onProgressChanged(view, progress);
                    }
                }
            });
            this.webView.setOnScrollChangedListener(new MobGameWebViewDetail.OnPropertyChangedListener(){

                @Override
                public void onScroll(int l, int t, int oldl, int oldt) {
                    if (MobGameDialogStartWebFragment.this.eventListeners != null) {
                        MobGameDialogStartWebFragment.this.eventListeners.onScrollChanged(MobGameDialogStartWebFragment.this.webView, l, t, oldl, oldt);
                    }
                }

                @Override
                public void onSizeChanged(int w, int h, int ow, int oh) {
                    if (MobGameDialogStartWebFragment.this.eventListeners != null) {
                        MobGameDialogStartWebFragment.this.eventListeners.onSizeChanged(MobGameDialogStartWebFragment.this.webView, w, h, ow, oh);
                    }
                }
            });
            this.webView.setWebViewClient(new WebViewClient(){
                long startLoadPage = 0L;
                long endLoadPage = 0L;

                @TargetApi(value=21)
                public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                    MobGameDialogStartWebFragment.this.showProgress(true);
                    String url = request.getUrl().toString();
                    if (Utils.isPlfUrl(url) && !url.contains("appkey=" + GameConfigs.getInstance().getAppKey())) {
                        Log.i((String)TAG, (String)"loadUrlWithMobHeaders from shouldOverrideUrlLoading() ");
                        MobGameDialogStartWebFragment.this.loadUrlWithMobHeaders(url);
                        return true;
                    }
                    return super.shouldOverrideUrlLoading(view, request);
                }

                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    MobGameDialogStartWebFragment.this.showProgress(true);
                    if (Utils.isPlfUrl(url) && !url.contains("appkey=" + GameConfigs.getInstance().getAppKey())) {
                        Log.i((String)TAG, (String)"loadUrlWithMobHeaders from shouldOverrideUrlLoading() ");
                        MobGameDialogStartWebFragment.this.loadUrlWithMobHeaders(url);
                        return true;
                    }
                    return super.shouldOverrideUrlLoading(view, url);
                }

                public void onPageStarted(WebView view, String url, Bitmap favicon) {
                    try {
                        MobGameDialogStartWebFragment.this.showProgress(true);
                        LogUtils.d(TAG, "onPageStarted: url=" + url);
                        super.onPageStarted(view, url, favicon);
                        if (MobGameDialogStartWebFragment.this.eventListeners != null) {
                            MobGameDialogStartWebFragment.this.eventListeners.onPageStarted(view, url, favicon);
                        }
                        this.startLoadPage = System.currentTimeMillis();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void onPageFinished(WebView view, String url) {
                    MobGameDialogStartWebFragment.this.showProgress(false);
                    LogUtils.d(TAG, "onPageFinished: ");
                    try {
                        if (Utils.isPlfUrl(url)) {
                            WvUtil.parseWebView((Context)MobGameDialogStartWebFragment.this.getActivity());
                        }
                        super.onPageFinished(view, url);
                        if (MobGameDialogStartWebFragment.this.eventListeners != null) {
                            MobGameDialogStartWebFragment.this.eventListeners.onPageFinished(view, url);
                        }
                        this.endLoadPage = System.currentTimeMillis();
                        long l = this.endLoadPage - this.startLoadPage;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @RequiresApi(api=21)
                public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                    Log.d((String)TAG, (String)"onReceivedError: ");
                    try {
                        MobGameDialogStartWebFragment.this.showProgress(false);
                        MobGameDialogStartWebFragment.this.selectButton = 4;
                        if (!MobGameDialogStartWebFragment.this.isConnected()) {
                            MobGameDialogStartWebFragment.this.dialogView.setVisibility(8);
                            MobGameDialogStartWebFragment.this.showDialog();
                        } else {
                            MobGameDialogStartWebFragment.this.selectButton = 5;
                            MobGameDialogStartWebFragment.this.dialogView.setVisibility(8);
                        }
                        MobGameDialogStartWebFragment.this.showProgress(false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                    Log.d((String)TAG, (String)"onReceivedError: ");
                    MobGameDialogStartWebFragment.this.selectButton = 4;
                    MobGameDialogStartWebFragment.this.showProgress(false);
                    if (!MobGameDialogStartWebFragment.this.isConnected()) {
                        MobGameDialogStartWebFragment.this.dialogView.setVisibility(8);
                        MobGameDialogStartWebFragment.this.showDialog();
                    } else {
                        WvUtil.showErrorPage((Context)MobGameDialogStartWebFragment.this.getActivity(), view, failingUrl);
                    }
                    MobGameDialogStartWebFragment.this.showProgress(false);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handlerBackButton() {
        try {
            this.getDialog().setOnKeyListener(new DialogInterface.OnKeyListener(){

                @SuppressLint(value={"SetJavaScriptEnabled"})
                public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                    if (event != null && keyCode == 4 && event.getAction() == 1) {
                        SdkConfigObj.Pop mobPopup = GameConfigs.getInstance().getMobPopup();
                        String url = mobPopup.getUrl();
                        if (url != null && url.contains("btnc=1")) {
                            Log.d((String)TAG, (String)("handlerBackButton: url " + url));
                            MobGameDialogStartWebFragment.this.closeDialog();
                        }
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void show(FragmentManager manager, String tag) {
        try {
            super.show(manager, tag);
            Log.d((String)TAG, (String)("Show " + TAG));
            Intent intent = new Intent("com.mobgame.broadcast");
            intent.putExtra("category", "isShowPopupLink");
            LocalBroadcastManager.getInstance((Context)this.getActivity()).sendBroadcast(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dismiss() {
        super.dismiss();
        try {
            Log.d((String)TAG, (String)("Show " + TAG));
            Intent intent = new Intent("com.mobgame.broadcast");
            intent.putExtra("category", "hideShowPopupLink");
            LocalBroadcastManager.getInstance((Context)this.getActivity()).sendBroadcast(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @TargetApi(value=13)
    private void showProgress(final boolean show) {
        try {
            int shortAnimTime = this.activity.getResources().getInteger(0x10E0000);
            this.mProgressView.setVisibility(show ? 0 : 8);
            this.mProgressView.animate().setDuration((long)shortAnimTime).alpha(show ? 1.0f : 0.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    MobGameDialogStartWebFragment.this.mProgressView.setVisibility(show ? 0 : 8);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showWebViewDetail(String title, String url) {
        try {
            if (!Utils.isPlfUrl(url)) {
                url = "https://a.smobgame.com" + url;
            }
            Log.d((String)TAG, (String)("onCreateDialog: url " + url));
            this.isCheck = url.contains("isCheck=1");
            Log.i((String)TAG, (String)"loadUrlWithMobHeaders from showWebViewDetail() ");
            this.loadUrlWithMobHeaders(url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showMobAds() {
        try {
            SdkConfigObj.Pop mobPopup = GameConfigs.getInstance().getMobPopup();
            String url = mobPopup.getUrl();
            SdkConfigObj sdk = GameConfigs.getInstance().getSdkConfig();
            if (sdk != null && sdk.getMaintenance() != null && !TextUtils.isEmpty((CharSequence)sdk.getMaintenance().getUrl())) {
                url = sdk.getMaintenance().getUrl();
            }
            if (url.contains("btnc=0") || mobPopup.getCanClose() == 0) {
                this.dialogCloseButton.setVisibility(8);
            } else {
                this.dialogCloseButton.setVisibility(0);
            }
            this.loadUrlWithMobHeaders(url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void postUrlWithMobHeaders(String url, HashMap<String, String> postParams) throws InterruptedException, ExecutionException, UnsupportedEncodingException {
        this.postUrlWithMobHeaders(url, postParams, null);
    }

    public void postUrlWithMobHeaders(String url, HashMap<String, String> postParams, PostTask.Callback callback) throws InterruptedException, ExecutionException, UnsupportedEncodingException {
        MUrl mUrl = cachedUrls.get(url);
        if (mUrl == null) {
            mUrl = new MUrl(url);
        }
        this.postUrlWithMobHeaders(mUrl, postParams, callback);
    }

    public void postUrlWithMobHeaders(MUrl url, HashMap<String, String> postParams, PostTask.Callback callback) throws InterruptedException, ExecutionException, UnsupportedEncodingException {
        if (Utils.isPlfUrl(url)) {
            Uri uri = url.toUri();
            String postUrl = uri.toString();
            String postData = "hl=en";
            for (String key : postParams.keySet()) {
                postData = postData + "&" + key + "=" + URLEncoder.encode(postParams.get(key), "UTF-8");
            }
            MobGameDialogStartWebFragment.setCookieToURLWebview(this.webView.getContext(), postUrl);
            this.webView.postUrl(postUrl, postData.getBytes());
        } else {
            this.postUrl(url);
        }
    }

    private void postUrl(MUrl url) {
        this.postUrl(url.getPath());
    }

    private void postUrl(String url) {
        try {
            this.webView.postUrl(url, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadUrlWithMobHeaders(String url) {
        try {
            Log.d((String)TAG, (String)("loadUrlWithMobHeaders: " + url));
            if (Utils.isPlfUrl(url)) {
                Context context = this.activity.getApplicationContext();
                Uri uri = Uri.parse((String)url);
                MobGameDialogStartWebFragment.setCookieToURLWebview(context, url);
                HashMap<String, String> extraHeaders = new HashMap<String, String>();
                String token = AuthenConfigs.getInstance().getAccessToken();
                if (token != null && !TextUtils.isEmpty((CharSequence)token)) {
                    extraHeaders.put("Authorization", "Bearer " + token);
                }
                this.webView.stopLoading();
                this.webView.loadUrl(uri.toString(), extraHeaders);
            } else {
                this.loadUrl(url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setCookieToURLWebview(Context context, String url) {
        try {
            HashSet cookies = (HashSet)Preference.getStringSet(context, "game_shared_pref_cookies", new HashSet<String>());
            CookieSyncManager cookieSyncManager = CookieSyncManager.createInstance((Context)context);
            CookieManager cookieManager = CookieManager.getInstance();
            cookieManager.setAcceptCookie(true);
            for (String cookie : cookies) {
                Log.d((String)TAG, (String)("loadUrlWithMobHeaders form cookie : " + cookie));
                cookieManager.setCookie(url, cookie);
            }
            cookieSyncManager.sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadUrl(String url) {
        try {
            if (this.isAdded()) {
                this.webView.stopLoading();
                this.webView.loadUrl(url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void invokeJavascript(String script) {
        this.webView.loadUrl("javascript:" + script);
    }

    public boolean isConnected() {
        try {
            ConnectivityManager cm = (ConnectivityManager)this.getActivity().getSystemService("connectivity");
            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            boolean isConnected = activeNetwork != null && activeNetwork.isConnectedOrConnecting();
            LogUtils.d(TAG, "isConn : " + isConnected);
            return isConnected;
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
            LogUtils.e(TAG, "error : " + ex.getMessage());
            return false;
        }
    }

    public void showDialog() {
        try {
            AlertDialog.Builder dialog = new AlertDialog.Builder((Context)this.activity);
            dialog.setTitle((CharSequence)"M\u1ea5t k\u1ebft n\u1ed1i");
            dialog.setPositiveButton((CharSequence)"Th\u1eed l\u1ea1i", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (MobGameDialogStartWebFragment.this.isConnected()) {
                        switch (MobGameDialogStartWebFragment.this.selectButton) {
                            case 1: {
                                MobGameDialogStartWebFragment.this.webView.goBack();
                                break;
                            }
                            case 2: {
                                MobGameDialogStartWebFragment.this.webView.goForward();
                                break;
                            }
                            case 3: {
                                MobGameDialogStartWebFragment.this.webView.reload();
                                break;
                            }
                            case 4: {
                                MobGameDialogStartWebFragment.this.webView.reload();
                                MobGameDialogStartWebFragment.this.dialogView.setVisibility(0);
                                break;
                            }
                            case 5: {
                                MobGameDialogStartWebFragment.this.webView.reload();
                                MobGameDialogStartWebFragment.this.dialogView.setVisibility(0);
                                break;
                            }
                        }
                        dialog.dismiss();
                    } else {
                        MobGameDialogStartWebFragment.this.showDialog();
                    }
                }
            });
            dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    if (MobGameDialogStartWebFragment.this.selectButton == 4) {
                        MobGameDialogStartWebFragment.this.dismiss();
                    }
                }
            });
            dialog.setMessage((CharSequence)this.getString(R.string.error_network));
            dialog.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setKeyboardListener() {
        try {
            final View activityRootView = ((ViewGroup)this.activity.findViewById(0x1020002)).getChildAt(0);
            activityRootView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){
                private final Rect r = new Rect();

                public void onGlobalLayout() {
                    boolean isShown;
                    int estimatedKeyboardHeight = (int)TypedValue.applyDimension((int)1, (float)MobGameDialogStartWebFragment.this.EstimatedKeyboardDP, (DisplayMetrics)activityRootView.getResources().getDisplayMetrics());
                    activityRootView.getWindowVisibleDisplayFrame(this.r);
                    MobGameDialogStartWebFragment.this.heightDiff = activityRootView.getRootView().getHeight() - (this.r.bottom - this.r.top);
                    Resources res = MobGameDialogStartWebFragment.this.activity.getResources();
                    int heightDiffPixel = (int)TypedValue.applyDimension((int)1, (float)MobGameDialogStartWebFragment.this.heightDiff, (DisplayMetrics)res.getDisplayMetrics());
                    boolean bl = isShown = MobGameDialogStartWebFragment.this.heightDiff >= estimatedKeyboardHeight;
                    if (isShown == MobGameDialogStartWebFragment.this.wasOpened) {
                        Log.d((String)"Keyboard state", (String)"Ignoring global layout change...");
                        return;
                    }
                    MobGameDialogStartWebFragment.this.wasOpened = isShown;
                    if (isShown) {
                        if (MobGameDialogStartWebFragment.this.webView != null) {
                            MobGameDialogStartWebFragment.this.webView.getSettings().setJavaScriptEnabled(true);
                            if (Build.VERSION.SDK_INT >= 19) {
                                String script = "getHeightKeyBoard(" + MobGameDialogStartWebFragment.this.orientation + ")";
                                MobGameDialogStartWebFragment.this.webView.evaluateJavascript(script, (ValueCallback)new ValueCallback<String>(){

                                    public void onReceiveValue(String value) {
                                    }
                                });
                            }
                        }
                    } else {
                        MobGameDialogStartWebFragment.this.webView.getSettings().setJavaScriptEnabled(true);
                        if (Build.VERSION.SDK_INT >= 19) {
                            Log.d((String)TAG, (String)"closeKeyBoard()");
                            String script = "closeKeyBoard()";
                            MobGameDialogStartWebFragment.this.webView.evaluateJavascript(script, (ValueCallback)new ValueCallback<String>(){

                                public void onReceiveValue(String value) {
                                }
                            });
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface EventListener {
        public void onProgressChanged(WebView var1, int var2);

        public void onPageStarted(WebView var1, String var2, Bitmap var3);

        public void onPageFinished(WebView var1, String var2);

        public void onScrollChanged(WebView var1, int var2, int var3, int var4, int var5);

        public void onSizeChanged(WebView var1, int var2, int var3, int var4, int var5);
    }
}

