/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.api;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.AsyncTask;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.game.sdk.comon.config.AuthenConfigs;
import com.game.sdk.comon.config.GameConfigs;
import com.game.sdk.comon.utils.LogUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;

public class UploadListBitmapTask
extends AsyncTask<Void, Void, Void> {
    private String TAG = "UploadBitmapTask";
    private String url;
    private ArrayList<Bitmap> listBitmap;
    private Callback callback;
    private Activity activity;

    public UploadListBitmapTask(Activity activity, String url, ArrayList<Bitmap> listBitmap) {
        this.url = url;
        this.listBitmap = listBitmap;
        this.activity = activity;
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Void doInBackground(Void ... params) {
        HttpURLConnection conn = null;
        OutputStream outputStream = null;
        String boundary = "*****";
        String lineEnd = "\r\n";
        String twoHyphens = "--";
        long timestamp = System.currentTimeMillis() / 1000L;
        String fileName = "IMG_" + timestamp + ".JPG";
        try {
            URL serverUrl = new URL(this.url);
            String result = "";
            for (int i = 0; i < this.listBitmap.size(); ++i) {
                result = "";
                conn = (HttpURLConnection)serverUrl.openConnection();
                conn.setDoInput(true);
                conn.setDoOutput(true);
                conn.setUseCaches(false);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Connection", "Keep-Alive");
                conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);
                conn.setRequestProperty("mobgame-token", AuthenConfigs.getInstance().getAccessToken());
                conn.setRequestProperty("mobgame-appkey", GameConfigs.getInstance().getAppKey());
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                this.listBitmap.get(i).compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
                byte[] byteArray = stream.toByteArray();
                outputStream = conn.getOutputStream();
                outputStream.write((twoHyphens + boundary + lineEnd).getBytes());
                outputStream.write(("Content-Disposition: form-data; filename=\"" + fileName + "\"" + lineEnd).getBytes());
                outputStream.write(lineEnd.getBytes());
                outputStream.write(byteArray);
                outputStream.write(lineEnd.getBytes());
                outputStream.write((twoHyphens + boundary + twoHyphens + lineEnd).getBytes());
                InputStream is = conn.getInputStream();
                byte[] buffer = new byte[1024];
                while (is.read(buffer) >= 0) {
                    result = result + new String(buffer, "UTF-8");
                }
                result = result.replaceAll("\u0000.*", "");
            }
            if (this.activity != null && result != null) {
                Intent intent = new Intent("UploadBitmap");
                intent.putExtra("result", result);
                LocalBroadcastManager.getInstance((Context)this.activity.getApplicationContext()).sendBroadcast(intent);
            }
            LogUtils.d(this.TAG, "doInBackground: result " + result);
            if (this.callback != null) {
                this.callback.onSuccess(conn.getResponseCode(), result);
                LogUtils.d(this.TAG, "doInBackground: getResponseCode: " + conn.getResponseCode());
                LogUtils.d(this.TAG, "doInBackground: getResponseMessage: " + conn.getResponseMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.callback != null) {
                this.callback.onFailure(e);
            }
        }
        finally {
            block19: {
                try {
                    if (outputStream != null) {
                        outputStream.flush();
                        outputStream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (this.callback == null) break block19;
                    this.callback.onFailure(e);
                }
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    public static interface Callback {
        public void onSuccess(int var1, String var2);

        public void onFailure(Throwable var1);
    }
}

