package com.game.sdk.ui.login;

import android.app.Dialog;
import android.app.DialogFragment;
import android.app.FragmentManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.graphics.Typeface;
import android.net.ConnectivityManager;
import android.os.Bundle;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.material.textfield.TextInputEditText;
import androidx.core.content.ContextCompat;
import androidx.cardview.widget.CardView;
import android.text.Editable;
import android.text.Html;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.inputmethod.EditorInfo;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.request.RequestOptions;
import com.facebook.FacebookException;
import com.facebook.login.LoginResult;
import com.game.sdk.comon.api.ApiUtils;
import com.game.sdk.comon.api.ErrorCode;
import com.game.sdk.comon.api.RetrofitClient;
import com.game.sdk.comon.config.AuthenConfigs;
import com.game.sdk.comon.config.GameConfigs;
import com.game.sdk.comon.constants.Constants;
import com.game.sdk.comon.game.BaseDialogFragment;
import com.game.sdk.comon.game.GameSdk;
import com.game.sdk.comon.listener.IAuthentFBListener;
import com.game.sdk.comon.listener.IAuthentGoogleListener;
import com.game.sdk.comon.listener.ILoginListener;
import com.game.sdk.comon.login.FacebookManager;
import com.game.sdk.comon.login.GoogleManager;
import com.game.sdk.comon.object.AuthenConfigObj;
import com.game.sdk.comon.object.BaseObj;
import com.game.sdk.comon.object.UserObj;
import com.game.sdk.comon.object.err.AuthenConfigErrObj;
import com.game.sdk.comon.object.err.LoginEmailErrObj;
import com.game.sdk.comon.object.err.LoginFacebookErrObj;
import com.game.sdk.comon.object.err.LoginGGErrObj;
import com.game.sdk.comon.object.err.LoginPlayNowErrObj;
import com.game.sdk.comon.object.err.SdkConfigErrObj;
import com.game.sdk.comon.object.response.AuthenConfigResponseObj;
import com.game.sdk.comon.object.response.LoginByRegisterObj;
import com.game.sdk.comon.object.response.LoginEmailResponseObj;
import com.game.sdk.comon.object.response.LoginFacebookResponseObj;
import com.game.sdk.comon.object.response.LoginGoogleResponseObj;
import com.game.sdk.comon.object.response.LoginPlayNowResponseObj;
import com.game.sdk.comon.object.response.SdkConfigResponseObj;
import com.game.sdk.comon.presenter.BaseView;
import com.game.sdk.comon.tracking.TrackingUtil;
import com.game.sdk.comon.utils.DeviceUtils;
import com.game.sdk.comon.utils.DialogUtils;
import com.game.sdk.comon.utils.LogUtils;
import com.game.sdk.comon.utils.NetworkUtils;
import com.game.sdk.comon.utils.StringUtils;
import com.game.sdk.ui.login.term.TermDialogFragment;
import com.game.sdk.ui.register.RegistryFragmentV2;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.mobgame.MobGameSDK;
import com.mobgame.R;
import com.game.sdk.comon.utils.KeyboardHeightObserver;
import com.game.sdk.comon.utils.KeyboardHeightProvider;

import static com.google.android.gms.auth.api.signin.GoogleSignInStatusCodes.SIGN_IN_CURRENTLY_IN_PROGRESS;


public class AccountFragment extends BaseDialogFragment implements View.OnClickListener,
        BaseView, IAuthentFBListener, IAuthentGoogleListener, KeyboardHeightObserver {

    LinearLayout btnFaceBook, btnPlayNow, btnGoogle;
    TextInputEditText edtLoginPassword, edtLoginAccount;
    ImageButton btnClose;
    TextView btnLogin, tvTerm, tvPlayTimeNoti, tvRegister;
    ImageView iv18Plus;
    ILoginPresenter loginPresenter;
    LinearLayout termContent, leftContent, rightContent, contentIv18;
    ILoginListener listener;
    TextView tvErrUser, tvErrPass, tvForgotPass, tvHeaderLoginSocial;
    Handler mHandler;
    Runnable mRunable;
    Constants.RTF_STATUS status;
    LinearLayout layoutKeyboardSpace;
    private KeyboardHeightProvider keyboardProvider;
    int errEmailCount;
    CardView contentPanel;

    public static AccountFragment newInstance(ILoginListener listener) {
        AccountFragment frag = new AccountFragment();
        frag.setListener(listener);
        Bundle bulde = new Bundle();
        frag.setArguments(bulde);
        return frag;
    }

    @Override
    public void onStart() {
        super.onStart();
        Dialog d = getDialog();
        if (d != null) {
            int width = ViewGroup.LayoutParams.MATCH_PARENT;
            int height = ViewGroup.LayoutParams.MATCH_PARENT;
            d.getWindow().setLayout(width, height);
        }
    }

    @Override
    protected int getLayoutResource() {
        return R.layout.fragment_account_container;
    }


    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initView(view);
    }

    @Override
    public void onResume() {
        super.onResume();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(ConnectivityManager.CONNECTIVITY_ACTION);
        mActivity.registerReceiver(networkChangeReceiver, intentFilter);
        getDialog().getWindow().clearFlags(WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE);
        loginPresenter.getAuthenConfig();
        keyboardProvider.setKeyboardHeightObserver(this);
    }

    @Override
    public void onDetach() {
        super.onDetach();
        keyboardProvider.close();
    }

    public void initView(View v) {
        mHandler = new Handler();
        loginPresenter = new LoginPresenterImpl(this);
        iv18Plus = (ImageView) v.findViewById(R.id.iv18Plus);
        layoutKeyboardSpace = (LinearLayout) v.findViewById(R.id.layout_keyboard_space);
        edtLoginAccount = (TextInputEditText) v.findViewById(R.id.edtLoginAccount);
        edtLoginPassword = (TextInputEditText) v.findViewById(R.id.edtLoginPassword);
        tvTerm = (TextView) v.findViewById(R.id.tvTerm);
        tvPlayTimeNoti = (TextView) v.findViewById(R.id.tvPlayTimeNoti);
        rightContent = (LinearLayout) v.findViewById(R.id.rightContent);
        leftContent = (LinearLayout) v.findViewById(R.id.leftContent);
        termContent = (LinearLayout) v.findViewById(R.id.termContent);
        contentIv18 = (LinearLayout) v.findViewById(R.id.contentIv18);
        btnFaceBook = (LinearLayout) v.findViewById(R.id.btnFacebook);
        btnGoogle = (LinearLayout) v.findViewById(R.id.btnGoogle);
        btnLogin = (TextView) v.findViewById(R.id.btnLogin);
        tvRegister = (TextView) v.findViewById(R.id.tvRegister);
        btnPlayNow = (LinearLayout) v.findViewById(R.id.btnPlayNow);
        btnClose = (ImageButton) v.findViewById(R.id.btnClose);
        tvErrUser = (TextView) v.findViewById(R.id.tvErrUser);
        tvErrPass = (TextView) v.findViewById(R.id.tvErrPass);
        tvForgotPass = (TextView) v.findViewById(R.id.tvForgotPass);
        tvHeaderLoginSocial = (TextView) v.findViewById(R.id.tvHeaderLoginSocial);
        contentPanel = (CardView) v.findViewById(R.id.contentPanel);

        tvTerm.setText(Html.fromHtml(getString(R.string.lbl_term)));
        edtLoginAccount.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                edtLoginAccount.setBackground(mActivity.getResources().getDrawable(R.drawable.slt_input_text_login_land));
                tvErrUser.setVisibility(View.GONE);
            }
        });
        edtLoginPassword.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                edtLoginPassword.setBackground(mActivity.getResources().getDrawable(R.drawable.slt_input_text_login_land));
                tvErrPass.setVisibility(View.GONE);
            }
        });
        edtLoginPassword.setOnEditorActionListener(new TextView.OnEditorActionListener() {
            @Override
            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                boolean handled = false;
                if (actionId == EditorInfo.IME_ACTION_SEND) {
                    DeviceUtils.hideKeyboardFrom(mActivity, v);
                    onLoginEmail();
                    handled = true;
                }
                return handled;
            }
        });

        btnFaceBook.setOnClickListener(this);
        btnPlayNow.setOnClickListener(this);
        btnLogin.setOnClickListener(this);
        btnClose.setOnClickListener(this);
        btnGoogle.setOnClickListener(this);
        tvTerm.setOnClickListener(this);
        tvRegister.setOnClickListener(this);
        tvForgotPass.setOnClickListener(this);
        errEmailCount = 0;
        keyboardProvider = new KeyboardHeightProvider(mActivity);
        keyboardProvider.start();

    }

    DialogFragment newFragment;
    ILoginListener registerListener = new ILoginListener() {
        @Override
        public void onLoginSuccess() {

        }

        @Override
        public void onRegisterSuccess(String param) {
            newFragment.dismiss();
            newFragment = null;
            //init data for login success
            try {
                LoginByRegisterObj obj = LoginByRegisterObj.parse(param);
                obj.getData().setLoginType(Constants.LOGIN_TYPE.EMAIL);
                obj.getData().setLoginOrRegister(obj.getIsRegister());
                (AccountFragment.this).onLoginSuccess(obj.getData(), obj.getAccessToken());

                //Get SDK configs , must call
                loginPresenter.getSdkConfig();
                if (listener != null)
                    listener.onRegisterSuccess(param);
            } catch (Exception e) {
                DialogUtils.showErrorDialog(mActivity, getString(R.string.err_422));
            }
        }
    };

    public void showRegisterDialog() {
        newFragment = (DialogFragment) mActivity.getFragmentManager().findFragmentByTag(RegistryFragmentV2.class.getSimpleName());
        if (newFragment == null)
            newFragment = RegistryFragmentV2.newInstance(registerListener);
        newFragment.setCancelable(true);
        if (newFragment.getDialog() != null && newFragment.getDialog().isShowing())
            return;
        newFragment.show(mActivity.getFragmentManager(), RegistryFragmentV2.class.getSimpleName());
    }

    public void showTermDialog() {
        DialogFragment newFragment = (DialogFragment) mActivity.getFragmentManager().findFragmentByTag(TermDialogFragment.class.getSimpleName());
        if (newFragment == null)
            newFragment = TermDialogFragment.newInstance(ApiUtils.getUrlTerm(mActivity));
        newFragment.setCancelable(true);
        if (newFragment.getDialog() != null && newFragment.getDialog().isShowing())
            return;
        newFragment.show(mActivity.getFragmentManager(), TermDialogFragment.class.getSimpleName());

    }

    /**
     * Login Email
     */
    private void onLoginEmail() {
        if (!NetworkUtils.checkNetwork(mActivity)) {
            DialogUtils.showErrorDialog(mActivity, mActivity.getString(R.string.error_network));
            return;
        }
        if (GameConfigs.getInstance().isLogin())
            return;

        if (errEmailCount >= 5) {
            DialogUtils.showErrorInputDialog(mActivity, mActivity.getString(R.string.err_input_more_than_5), new DialogUtils.DlgCloseListener() {
                @Override
                public void onClose() {
                    errEmailCount = 0;
                    onLoginPlayNow();
                }
            }, new DialogUtils.DlgCloseListener() {
                @Override
                public void onClose() {
                    errEmailCount = 0;
                }
            });
            return;
        }

        TrackingUtil.getInstance().trackClickLoginEmailButton();

        String user = edtLoginAccount.getText().toString();
        String pass = edtLoginPassword.getText().toString();
        String checkUser = StringUtils.validateUser(mActivity, user);
        if (!checkUser.isEmpty()) {
            TrackingUtil.getInstance().trackLoginEmailInputError(1, checkUser);
            tvErrUser.setVisibility(View.VISIBLE);
            tvErrUser.setText(checkUser);
            edtLoginAccount.setBackground(mActivity.getResources().getDrawable(R.drawable.slt_input_text_login_err));
            edtLoginAccount.requestFocus();
            errEmailCount += 1;
            return;
        }
        String checkPass = StringUtils.validatePassword(mActivity, pass);
        if (!checkPass.isEmpty()) {
            TrackingUtil.getInstance().trackLoginEmailInputError(2, checkPass);
            tvErrPass.setVisibility(View.VISIBLE);
            tvErrPass.setText(checkPass);
            edtLoginPassword.setBackground(mActivity.getResources().getDrawable(R.drawable.slt_input_text_login_err));
            edtLoginPassword.requestFocus();
            errEmailCount += 1;
            return;
        }

        TrackingUtil.getInstance().trackLoginEmailCallApi();
        loginPresenter.loginEmail(user, pass);
    }

    private void onLoginPlayNow() {
        if (!NetworkUtils.checkNetwork(mActivity)) {
            DialogUtils.showErrorDialog(mActivity, mActivity.getString(R.string.error_network));
            return;
        }
        if (GameConfigs.getInstance().isLogin())
            return;
        TrackingUtil.getInstance().trackLoginPlayNowCallApi();
        loginPresenter.loginPlayNow();
    }


    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case GoogleManager.RC_SIGN_IN:
                GoogleManager.getInstance(mActivity).onAuthGoogleResult(data, resultCode);
                break;
            case Constants.REQUEST_CODE_FACEBOOK_LOGIN:
                FacebookManager.getInstance(mActivity).onAuthResult(requestCode, resultCode, data);
                break;
            default:
                break;
        }
    }


    @Override
    public void onClick(View v) {
        if (mHandler != null && mRunable != null)
            mHandler.removeCallbacks(mRunable);
        mRunable = new Runnable() {
            @Override
            public void run() {
                try {
                    DeviceUtils.hideKeyboardFrom(mActivity, v);
                    if (v.getId() == R.id.btnFacebook) {
                        if (status == Constants.RTF_STATUS.AUTHENING)
                            return;
                        status = Constants.RTF_STATUS.AUTHENING;
                        authenFacebook();
                    } else if (v.getId() == R.id.btnGoogle) {
                        if (status == Constants.RTF_STATUS.AUTHENING)
                            return;
                        status = Constants.RTF_STATUS.AUTHENING;
                        authenGooogle();
                    } else if (v.getId() == R.id.btnLogin) {
                        onLoginEmail();
                    } else if (v.getId() == R.id.btnClose) {
                        TrackingUtil.getInstance().trackLoginScreenClose(contentPanel, edtLoginAccount, btnLogin);
                        dismiss();
                    } else if (v.getId() == R.id.btnPlayNow) {
                        onLoginPlayNow();
                    } else if (v.getId() == R.id.tvTerm) {
                        showTermDialog();
                    } else if (v.getId() == R.id.tvRegister) {
                        TrackingUtil.getInstance().trackClickBtnRegister();
                        showRegisterDialog();
                    } else if (v.getId() == R.id.tvForgotPass) {
                        DialogUtils.showInfoDialog(mActivity, getString(R.string.notice), getString(R.string.info_forget_pass));
                        TrackingUtil.getInstance().trackForgotPassword();
                    }
                } catch (Exception e) {
                } finally {
                    mHandler = null;
                    mRunable = null;
                }
            }
        };
        if (mHandler == null)
            mHandler = new Handler();
        mHandler.postDelayed(mRunable, 150);


    }

    private void authenFacebook() {
        if (!NetworkUtils.checkNetwork(mActivity)) {
            DialogUtils.showErrorDialog(mActivity, mActivity.getString(R.string.error_network));
            return;
        }
        //Track event
        TrackingUtil.getInstance().trackClickLoginFacebookButton();
        //start auth
        if (isAdded())
            FacebookManager.getInstance(mActivity).startAuth(this, this);
    }

    private void authenGooogle() {
        if (!NetworkUtils.checkNetwork(mActivity)) {
            DialogUtils.showErrorDialog(mActivity, mActivity.getString(R.string.error_network));
            return;
        }
        //Track event
        TrackingUtil.getInstance().trackClickLoginGoogleButton();
        //start auth
        if (isAdded())
            GoogleManager.getInstance(mActivity).startAuthForResult(this, this);
    }

    @Override
    public void show(FragmentManager manager, String tag) {
        super.show(manager, tag);
        TrackingUtil.getInstance().trackLoginScreenOpen();
    }

    public void applyConfig(@NonNull AuthenConfigObj obj) {
        AuthenConfigObj.LoginConfig cf = obj.getLoginConfig();
        if (cf == null)
            return;
        if (cf.getLogin_google() == 0 & cf.getLogin_facebook() == 0 && cf.getPlay_now() == 0 && cf.getLogin_email() == 0) {
            getView().setVisibility(View.GONE);
            onLoginPlayNow();
        }
        if (cf.getLogin_email() == 0) {
            leftContent.setVisibility(View.GONE);
            tvHeaderLoginSocial.setText(getString(R.string.lbl_login_to_your_account));
            tvHeaderLoginSocial.setTypeface(Typeface.defaultFromStyle(Typeface.BOLD));
        }
        tvRegister.setVisibility((obj != null && obj.getRegisterConfig() == 1) ? View.VISIBLE : View.GONE);
        if (cf.getLogin_google() == 0 & cf.getLogin_facebook() == 0 && cf.getPlay_now() == 0) {
            rightContent.setVisibility(View.GONE);
        } else {
            int orientation = getResources().getConfiguration().orientation;
            if (orientation == Configuration.ORIENTATION_LANDSCAPE) {
                termContent.setBackgroundColor(ContextCompat.getColor(mActivity, R.color.bg_null));
            } else {
                termContent.setBackgroundColor(ContextCompat.getColor(mActivity, R.color.bg_login_social));
            }
        }
        btnFaceBook.setVisibility(cf.getLogin_facebook() == 0 ? View.GONE : View.VISIBLE);
        btnGoogle.setVisibility(cf.getLogin_google() == 0 ? View.GONE : View.VISIBLE);
        btnPlayNow.setVisibility(cf.getPlay_now() == 0 ? View.GONE : View.VISIBLE);

        if (obj.getLogoOlder() == null || (obj.getLogoOlder().getUrl() == null && obj.getLogoOlder().getText() == null))
            contentIv18.setVisibility(View.GONE);

        if (obj.getLogoOlder() != null && obj.getLogoOlder().getUrl() != null) {
            RequestOptions options = new RequestOptions()
                    .centerInside()
                    .placeholder(R.drawable.logotuoi)
                    .error(R.drawable.logotuoi)
                    .priority(Priority.HIGH);
            Glide.with(mActivity)
                    .load(obj.getLogoOlder().getUrl())
                    .apply(options)
                    .into(iv18Plus);
        } else {
            iv18Plus.setVisibility(View.INVISIBLE);
        }
        if (obj.getLogoOlder() != null && obj.getLogoOlder().getText() != null) {
            tvPlayTimeNoti.setText(obj.getLogoOlder().getText());
        }

    }


    @Override
    public void showProgress(String mess) {
        showPregressDialog(true, mess);
    }

    @Override
    public void hideProgress() {
        showPregressDialog(false, "");
    }

    @Override
    public void success(Object x) {
        if (x instanceof AuthenConfigResponseObj) {
            AuthenConfigObj obj = ((AuthenConfigResponseObj) x).getData();
            AuthenConfigs.getInstance().setAuthenConfigObj(obj);
            applyConfig(obj);
            TrackingUtil.getInstance().trackCallAuthenConfigSuccess();
        } else if (x instanceof LoginPlayNowResponseObj) {
            TrackingUtil.getInstance().trackLoginPlayNowCallApiSuccess();
            //init data for login success\
            LoginPlayNowResponseObj obj = (LoginPlayNowResponseObj) x;
            obj.getData().setLoginType(Constants.LOGIN_TYPE.PLAYNOW);
            obj.getData().setLoginOrRegister(obj.getIsRegister());
            onLoginSuccess(obj.getData(), obj.getAccessToken());

            //Get SDK configs , must call
            loginPresenter.getSdkConfig();

        } else if (x instanceof LoginEmailResponseObj) {
            TrackingUtil.getInstance().trackLoginEmailCallApiSuccess();
            //init data for login success
            LoginEmailResponseObj obj = (LoginEmailResponseObj) x;
            obj.getData().setLoginType(Constants.LOGIN_TYPE.EMAIL);
            obj.getData().setLoginOrRegister(obj.getIsRegister());
            onLoginSuccess(obj.getData(), obj.getAccessToken());

            //Get SDK configs , must call
            loginPresenter.getSdkConfig();

        } else if (x instanceof LoginFacebookResponseObj) {
            TrackingUtil.getInstance().trackLoginFacebookCallApiSuccess();
            //init data for login success
            LoginFacebookResponseObj obj = (LoginFacebookResponseObj) x;
            obj.getData().setLoginType(Constants.LOGIN_TYPE.FACEBOOK);
            obj.getData().setLoginOrRegister(obj.getIsRegister());
            onLoginSuccess(obj.getData(), obj.getAccessToken());

            //Get SDK configs , must call
            loginPresenter.getSdkConfig();

        } else if (x instanceof LoginGoogleResponseObj) {
            TrackingUtil.getInstance().trackLoginGoogleCallApiSuccess();
            //init data for login success
            LoginGoogleResponseObj obj = (LoginGoogleResponseObj) x;
            obj.getData().setLoginType(Constants.LOGIN_TYPE.GOOGLE);
            obj.getData().setLoginOrRegister(obj.getIsRegister());
            onLoginSuccess(obj.getData(), obj.getAccessToken());

            //Get SDK configs , must call
            loginPresenter.getSdkConfig();

        } else if (x instanceof SdkConfigResponseObj) {
            TrackingUtil.getInstance().trackGetSdkConfigSuccess();
            SdkConfigResponseObj obj = (SdkConfigResponseObj) x;
            GameConfigs.getInstance().setSdkConfig(obj.getData());
            LogUtils.d("LifeCycleActivity", "get game info success");
            if (obj != null && obj.getData() != null && obj.getData().getMaintenance() != null && !TextUtils.isEmpty(obj.getData().getMaintenance().getUrl())) {
                TrackingUtil.getInstance().trackMaintainScreenOpened();
                MobGameSDK.getInstance().getQueuePopups().add(MobGameSDK.POPUP_LINK);
                MobGameSDK.getInstance().showPopup();
            } else {
                GameSdk.getInstance().onLoginSuccess(mActivity, "login");
                if (listener != null)
                    listener.onLoginSuccess();
            }
            dismiss();
        }

    }


    public void onLoginSuccess(UserObj obj, String token) {
        GameConfigs.getInstance().setUser(obj);
        AuthenConfigs.getInstance().setAccessToken(token);
        RetrofitClient.clearInstant();
        TrackingUtil.getInstance().trackLoginSuccess(GameConfigs.getInstance().getUser().getId(), GameConfigs.getInstance().getUser().getLoginOrRegister(), GameConfigs.getInstance().getUser().getLoginType());
    }


    @Override
    public void error(Object o) {
        BaseObj apiErrorObj = (BaseObj) o;
        if (apiErrorObj.getStatus() == ErrorCode.NO_INTERNET) {
            DialogUtils.showErrorDialog(mActivity, mActivity.getString(R.string.error_network));
            return;
        }
        if (o instanceof LoginPlayNowErrObj) {
            LoginPlayNowErrObj obj = (LoginPlayNowErrObj) o;
            TrackingUtil.getInstance().trackLoginPlayNowCallApiFail(obj.getStatus(), obj.getMessage());
            DialogUtils.showErrorDialog(mActivity, obj.getMessage());
        } else if (o instanceof LoginEmailErrObj) {
            LoginEmailErrObj obj = (LoginEmailErrObj) o;
            TrackingUtil.getInstance().trackLoginEmailCallApiFail(obj.getStatus(), obj.getMessage());
            DialogUtils.showErrorDialog(mActivity, obj.getMessage());

        } else if (o instanceof LoginFacebookErrObj) {
            LoginFacebookErrObj obj = (LoginFacebookErrObj) o;
            TrackingUtil.getInstance().trackLoginFacebookCallApiFail(obj.getStatus(), obj.getMessage());
            DialogUtils.showErrorDialog(mActivity, obj.getMessage());
        } else if (o instanceof LoginGGErrObj) {
            LoginGGErrObj obj = (LoginGGErrObj) o;
            TrackingUtil.getInstance().trackLoginGoogleCallApiFail(obj.getStatus(), obj.getMessage());
            DialogUtils.showErrorDialog(mActivity, obj.getMessage());
        } else if (o instanceof AuthenConfigErrObj) {
            AuthenConfigObj obj = new AuthenConfigObj();
            AuthenConfigObj.LoginConfig loginConfig = new AuthenConfigObj.LoginConfig();
            obj.setRegisterConfig(1);
            loginConfig.setLogin_apple(1);
            loginConfig.setLogin_email(1);
            loginConfig.setLogin_facebook(0);
            loginConfig.setPlay_now(1);
            loginConfig.setLogin_google(0);
            obj.setLoginConfig(loginConfig);
            applyConfig(obj);
            TrackingUtil.getInstance().trackCallAuthenConfigFailed();
        } else if (o instanceof SdkConfigErrObj) {
            SdkConfigErrObj obj = (SdkConfigErrObj) o;
            TrackingUtil.getInstance().trackGetSdkConfigFailed(obj.getStatus());
            if (obj.getStatus() == Constants.USER_ERR_CODE.INVALID_TOKEN) {
                DialogUtils.showExpireDialog(mActivity);
            } else
                DialogUtils.showRetryDialog(mActivity, obj.getMessage(), new DialogUtils.Listener() {
                    @Override
                    public void onRetry() {
                        loginPresenter.getSdkConfig();
                    }
                });
        }
    }


    //----------------------------------------------Facebook-----------------------------------------------
    @Override
    public void onAuthFBSuccess(LoginResult loginResult) {
        status = Constants.RTF_STATUS.DONE;
        LogUtils.d("mobgame_token", "facebook token : " + loginResult.getAccessToken().getToken());
        TrackingUtil.getInstance().trackLoginFacebookCallApi();
        if (GameConfigs.getInstance().isLogin())
            return;
        loginPresenter.loginFtFacebook(loginResult.getAccessToken().getToken());
    }

    @Override
    public void onAuthFBFailed(FacebookException error) {
        status = Constants.RTF_STATUS.DONE;
        DialogUtils.showErrorDialog(mActivity, "Auth FB failed : " + error.getMessage());
        if (error != null && error.getMessage() != null)
            TrackingUtil.getInstance().trackLoginFacebookSdkErr(error.getMessage());
    }

    @Override
    public void onAuthFBCancel() {
        status = Constants.RTF_STATUS.DONE;
        LogUtils.d("Login Facebook", " Auth FB cancel");
        TrackingUtil.getInstance().trackCancelLoginFacebook();
    }

    //-----------------------------------------Google--------------------------------------------------

    @Override
    public void onAuthGGSuccess(GoogleSignInAccount account, String mToken) {
        status = Constants.RTF_STATUS.DONE;
        LogUtils.d("mobgame_token", "google token : " + mToken);
        if (GameConfigs.getInstance().isLogin())
            return;
        TrackingUtil.getInstance().trackLoginGoogleCallApi();
        loginPresenter.loginFtGoogle(mToken);
    }

    @Override
    public void onAuthGGFailed(int code, String mess) {
        if (code == SIGN_IN_CURRENTLY_IN_PROGRESS)
            GoogleManager.getInstance(mActivity).startAuthForResult(this, this);
        else {
            status = Constants.RTF_STATUS.DONE;
            DialogUtils.showErrorDialog(mActivity, "Auth GG failed : " + mess);
        }
    }

    @Override
    public void onAuthGGCancel() {
        status = Constants.RTF_STATUS.DONE;
        LogUtils.d("Login Google", " Auth GG cancel");
        TrackingUtil.getInstance().trackCancelLoginGoogle();
    }

    public void setListener(ILoginListener listener) {
        this.listener = listener;
    }


    private BroadcastReceiver networkChangeReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            if (AuthenConfigs.getInstance().getAuthenConfigObj() == null)
                loginPresenter.getAuthenConfig();
        }
    };


    @Override
    public void onKeyboardHeightChanged(int height, int orientation) {
        changeKeyboardHeight(height);
    }

    private void changeKeyboardHeight(int height) {
        try {
            if (height > 100) {
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, height);
                layoutKeyboardSpace.setLayoutParams(params);
                layoutKeyboardSpace.setVisibility(View.VISIBLE);
                return;
            }

            layoutKeyboardSpace.setVisibility(View.GONE);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        keyboardProvider.setKeyboardHeightObserver(null);
        mActivity.unregisterReceiver(networkChangeReceiver);
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        //No call for super(). Bug on API Level > 11.
    }

}
