package com.game.sdk.ui.register;

import android.graphics.Bitmap;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.view.View;
import android.webkit.WebView;

import com.game.sdk.comon.api.ApiUtils;
import com.game.sdk.comon.game.BaseDialogWebFragment;
import com.game.sdk.comon.game.GameSdk;
import com.game.sdk.comon.js.JsBase;
import com.game.sdk.comon.js.JsRegister;
import com.game.sdk.comon.listener.ILoginListener;
import com.game.sdk.comon.listener.IWebViewClientListener;
import com.game.sdk.comon.tracking.TrackingUtil;

public class RegistryFragmentV2 extends BaseDialogWebFragment implements IWebViewClientListener {

    ILoginListener registerListener;

    public static RegistryFragmentV2 newInstance(ILoginListener registerListener) {
        RegistryFragmentV2 frag = new RegistryFragmentV2();
        Bundle args = new Bundle();
        String url = ApiUtils.getUrlWvRegister(GameSdk.getInstance().getApplication());
        args.putString(URL_WEBVIEW, url);
        frag.setArguments(args);
        frag.setRegisterListener(registerListener);
        return frag;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
    }

    @Override
    protected JsBase getJsHandler() {
        return new JsRegister(new JsRegister.Listener() {
            @Override
            public void onCloseWindow() {
                dismiss();
            }

            @Override
            public void onOpenWindow() {

            }

            @Override
            public void onBackToWindowns() {
                goBack();
            }

            @Override
            public void onRegisterSuccess(String param) {
                if (registerListener != null)
                    registerListener.onRegisterSuccess(param);
            }


        });
    }

    @Override
    protected IWebViewClientListener getWebListener() {
        return this;
    }

    public void setRegisterListener(ILoginListener registerListener) {
        this.registerListener = registerListener;
    }

    @Override
    public void shouldOverrideUrlLoading(WebView view, String url) {

    }

    @Override
    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        if (url.contains("checkScreen=register")) {
            TrackingUtil.getInstance().trackRegisterSubmitForm();
        }
    }

    @Override
    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {

    }

    @Override
    public void onPageFinished(WebView view, String url) {
        if (url.equals(ApiUtils.getUrlWvRegister(mActivity))) {
            TrackingUtil.getInstance().trackRegisterLoadSuccess();
        }
    }
}
