package com.game.sdk.ui.ads;


import com.game.sdk.comon.api.ApiUtils;
import com.game.sdk.comon.api.MyCallback;
import com.game.sdk.comon.api.request.AdsRequest;
import com.game.sdk.comon.api.request.PaymentRequest;
import com.game.sdk.comon.game.GameSdk;
import com.game.sdk.comon.object.BaseObj;
import com.game.sdk.comon.object.err.RetryPaymentErrObj;
import com.game.sdk.comon.object.err.SaveAiiErrObj;
import com.game.sdk.comon.object.err.VerifyPurchaseErrObj;
import com.game.sdk.comon.object.request.VerifyPurchaseRequestObj;
import com.game.sdk.comon.object.response.RetryPaymentResponseObj;
import com.game.sdk.comon.object.response.SaveAIIResponseObj;
import com.game.sdk.comon.object.response.VerifyPurchaseResponseObj;
import com.game.sdk.comon.presenter.InteractorCallback;
import com.game.sdk.comon.utils.LogUtils;
import com.game.sdk.comon.utils.Utils;
import com.game.sdk.ui.payment.IPaymentInteractor;

import retrofit2.Call;
import retrofit2.Response;

public class AdsInteractorImpl implements IAdsInteractor {
    private static final String TAG = AdsInteractorImpl.class.getName();

    private InteractorCallback mCallback;

    Call<SaveAIIResponseObj> mSaveAiiRequest;

    public AdsInteractorImpl(InteractorCallback mCallback) {
        this.mCallback = mCallback;
    }


    @Override
    public void saveAii(String appInstantId) {
        AdsRequest request = ApiUtils.getAdsRequest();
        mSaveAiiRequest = request.saveAii(appInstantId);
        mSaveAiiRequest.enqueue(callback);
    }

    @Override
    public void cancelRequest(String... tags) {
        if (mSaveAiiRequest != null)
            mSaveAiiRequest.cancel();

    }


    private MyCallback<SaveAIIResponseObj> callback = new MyCallback<SaveAIIResponseObj>() {
        @Override
        public void onSuccess(Call<SaveAIIResponseObj> call, Response<SaveAIIResponseObj> response) {
            if (response.isSuccessful()) {
                mCallback.success(response.body());
            }
        }

        @Override
        public void onError(Call<SaveAIIResponseObj> call, Object object) {
            BaseObj obj = (BaseObj) object;
            SaveAiiErrObj err = new SaveAiiErrObj();
            err.setMessage(obj.getMessage());
            err.setStatus(obj.getStatus());
            mCallback.error(err);
        }
    };


}
