/*
 * Decompiled with CFR 0.152.
 */
package com.game.sdk.comon.api;

import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import com.game.sdk.comon.config.AuthenConfigs;
import com.game.sdk.comon.config.GameConfigs;
import com.game.sdk.comon.game.GameSdk;
import com.game.sdk.comon.sharePref.PrefManager;
import com.game.sdk.comon.utils.DeviceUtils;
import com.game.sdk.comon.utils.ToastUtils;
import com.game.sdk.comon.utils.Utils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class RetrofitClient {
    private static final String TAG = RetrofitClient.class.getSimpleName();
    private static Retrofit retrofit = null;
    private static final int CONNECT_TIMEOUT = 15000;
    private static String baseUrl;

    private RetrofitClient() {
    }

    public static void clearInstant() {
        retrofit = null;
    }

    public static Retrofit getInstance() {
        if (retrofit == null) {
            Application context = GameSdk.getInstance().getApplication();
            baseUrl = PrefManager.getString((Context)context, "APP_UR", "https://core.sdkmain.com/");
            if (!baseUrl.endsWith("/")) {
                baseUrl = "https://core.sdkmain.com/";
            }
            if (!baseUrl.startsWith("http:") && !baseUrl.startsWith("https:")) {
                baseUrl = "https://core.sdkmain.com/";
            }
            Dispatcher dispatcher = new Dispatcher();
            dispatcher.setMaxRequests(1);
            Interceptor interceptorRequest = new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Request original = chain.request();
                    Request.Builder builder = original.newBuilder();
                    builder.header("Accept", "application/json");
                    String token = AuthenConfigs.getInstance().getAccessToken();
                    String appKey = GameConfigs.getInstance().getAppKey();
                    String appVer = Utils.getGameVersion((Context)GameSdk.getInstance().getApplication());
                    String sdkVer = Utils.getSDKVersion((Context)GameSdk.getInstance().getApplication());
                    if (token != null && !TextUtils.isEmpty((CharSequence)token)) {
                        builder.addHeader("Authorization", "Bearer " + token);
                    }
                    if (appKey != null && !TextUtils.isEmpty((CharSequence)appKey)) {
                        builder.addHeader("X-Request", appKey);
                    }
                    if (appVer != null && !TextUtils.isEmpty((CharSequence)appVer)) {
                        builder.addHeader("app-Version", appVer);
                    }
                    if (sdkVer != null && !TextUtils.isEmpty((CharSequence)sdkVer)) {
                        builder.addHeader("sdk-Version", sdkVer);
                    }
                    HttpUrl originalHttpUrl = original.url();
                    HttpUrl.Builder httpBuilder = originalHttpUrl.newBuilder();
                    HttpUrl url = httpBuilder.build();
                    Request request = builder.method(original.method(), original.body()).url(url).build();
                    return chain.proceed(request);
                }
            };
            OkHttpClient okClient = new OkHttpClient.Builder().addInterceptor(interceptorRequest).connectTimeout(15000L, TimeUnit.MILLISECONDS).readTimeout(15000L, TimeUnit.MILLISECONDS).writeTimeout(15000L, TimeUnit.MILLISECONDS).dispatcher(dispatcher).build();
            try {
                Gson gson = new GsonBuilder().setLenient().create();
                retrofit = new Retrofit.Builder().client(RetrofitClient.getUnsafeOkHttpClient().build()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).baseUrl(baseUrl).client(okClient).build();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                ToastUtils.showShortToast((Context)GameSdk.getInstance().getApplication(), "Url is Wrong");
            }
        }
        return retrofit;
    }

    public static Retrofit getInteractIntance(String baseUrl) {
        if (!baseUrl.startsWith("http:") && !baseUrl.startsWith("https:")) {
            return null;
        }
        Retrofit retrofit = null;
        Application context = GameSdk.getInstance().getApplication();
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(1);
        Interceptor interceptorRequest = new Interceptor((Context)context){
            final /* synthetic */ Context val$context;
            {
                this.val$context = context;
            }

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request original = chain.request();
                Request.Builder builder = original.newBuilder();
                builder.header("Accept", "application/json");
                String fcmApiKey = GameConfigs.getInstance().getFcmApiKey();
                String appKey = GameConfigs.getInstance().getAppKey();
                String appVer = Utils.getGameVersion((Context)GameSdk.getInstance().getApplication());
                String sdkVer = Utils.getSDKVersion((Context)GameSdk.getInstance().getApplication());
                String sdl_locale = PrefManager.getString((Context)GameSdk.getInstance().getApplication(), "APP_LANG", "en");
                String deviceOs = DeviceUtils.getOSInfo();
                String deviceName = DeviceUtils.getDevice();
                builder.addHeader("X-Authorization", fcmApiKey == null ? "" : fcmApiKey);
                builder.addHeader("sdk-locale", DeviceUtils.getLanguage());
                builder.addHeader("X-Request", appKey == null ? "" : appKey);
                builder.addHeader("app-Version", appVer == null ? "" : appVer);
                builder.addHeader("sdk-Version", sdkVer == null ? "" : sdkVer);
                builder.addHeader("device-Os", deviceOs == null ? "" : deviceOs);
                builder.addHeader("advertising-id", DeviceUtils.getAdvertisingID(this.val$context));
                builder.addHeader("device-Name", deviceName == null ? "" : deviceName);
                builder.addHeader("sdk-locale", sdl_locale);
                HttpUrl originalHttpUrl = original.url();
                HttpUrl.Builder httpBuilder = originalHttpUrl.newBuilder();
                HttpUrl url = httpBuilder.build();
                Request request = builder.method(original.method(), original.body()).url(url).build();
                return chain.proceed(request);
            }
        };
        OkHttpClient okClient = new OkHttpClient.Builder().addInterceptor(interceptorRequest).connectTimeout(15000L, TimeUnit.MILLISECONDS).readTimeout(15000L, TimeUnit.MILLISECONDS).writeTimeout(15000L, TimeUnit.MILLISECONDS).dispatcher(dispatcher).build();
        try {
            Gson gson = new GsonBuilder().setLenient().create();
            retrofit = new Retrofit.Builder().client(RetrofitClient.getUnsafeOkHttpClient().build()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).baseUrl(baseUrl).client(okClient).build();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            ToastUtils.showShortToast((Context)GameSdk.getInstance().getApplication(), "Url is Wrong");
        }
        return retrofit;
    }

    public static Retrofit getPaymentIntance(String baseUrl) {
        if (!baseUrl.startsWith("http:") && !baseUrl.startsWith("https:")) {
            return null;
        }
        Retrofit retrofit = null;
        Application context = GameSdk.getInstance().getApplication();
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(1);
        Interceptor interceptorRequest = new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request original = chain.request();
                Request.Builder builder = original.newBuilder();
                builder.header("Accept", "application/json");
                String accesstoken = AuthenConfigs.getInstance().getAccessToken();
                builder.addHeader("access_token", accesstoken == null ? "" : accesstoken);
                builder.addHeader("Authorization", accesstoken == null ? "" : accesstoken);
                HttpUrl originalHttpUrl = original.url();
                HttpUrl.Builder httpBuilder = originalHttpUrl.newBuilder();
                HttpUrl url = httpBuilder.build();
                Request request = builder.method(original.method(), original.body()).url(url).build();
                return chain.proceed(request);
            }
        };
        OkHttpClient okClient = new OkHttpClient.Builder().addInterceptor(interceptorRequest).connectTimeout(15000L, TimeUnit.MILLISECONDS).readTimeout(15000L, TimeUnit.MILLISECONDS).writeTimeout(15000L, TimeUnit.MILLISECONDS).dispatcher(dispatcher).build();
        try {
            Gson gson = new GsonBuilder().setLenient().create();
            retrofit = new Retrofit.Builder().client(RetrofitClient.getUnsafeOkHttpClient().build()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).baseUrl(baseUrl).client(okClient).build();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            ToastUtils.showShortToast((Context)GameSdk.getInstance().getApplication(), "Url is Wrong");
        }
        return retrofit;
    }

    public static OkHttpClient.Builder getUnsafeOkHttpClient() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]);
            builder.hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            return builder;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

