package com.game.sdk.comon.tracking;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;

import androidx.annotation.NonNull;

import com.facebook.AccessToken;
import com.game.sdk.comon.constants.Constants;
import com.game.sdk.comon.sharePref.PrefManager;
import com.game.sdk.comon.utils.LogUtils;
import com.game.sdk.comon.utils.StringUtils;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.material.snackbar.Snackbar;
import com.google.firebase.analytics.FirebaseAnalytics;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FacebookAuthProvider;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.GoogleAuthProvider;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Firebase {
    public static final String TAG = Firebase.class.getSimpleName();
    private static Firebase firebase;
    private Context context;
    private FirebaseAnalytics mFirebaseAnalytics;
    private FirebaseAuth mAuth;

    public static Firebase newInstance(Application context) {
        return new Firebase(context);
    }

    public static Firebase getInstance(Context context) {
        if (firebase == null)
            firebase = new Firebase(context);
        return firebase;
    }

    private Firebase(Context context) {
        this.context = context;
        if (mFirebaseAnalytics == null) {
            mFirebaseAnalytics = FirebaseAnalytics.getInstance(context);
        }
        mAuth = FirebaseAuth.getInstance();
    }

    public void firebaseEventTrack(String labelEvent, HashMap<String, Object> params) {
        Bundle bundle = new Bundle();

        if (params != null) {
            Set mapSet = (Set) params.entrySet();
            Iterator mapIterator = mapSet.iterator();
            while (mapIterator.hasNext()) {
                Map.Entry mapEntry = (Map.Entry) mapIterator.next();
                String key = (String) (mapEntry.getKey() + "");
                String value = (String) (mapEntry.getValue() + "");
                LogUtils.d(TAG, "key : " + key + " , value:" + value);
                bundle.putString(key, value);
            }

            mFirebaseAnalytics.logEvent(labelEvent, bundle);
        } else {
            mFirebaseAnalytics.logEvent(labelEvent, null);
        }

    }

    public void firebaseAuthWithGoogle(Activity ac, String idToken) {
        try {
            AuthCredential credential = GoogleAuthProvider.getCredential(idToken, null);
            mAuth.signInWithCredential(credential)
                    .addOnCompleteListener(ac, new OnCompleteListener<AuthResult>() {
                        @Override
                        public void onComplete(@NonNull Task<AuthResult> task) {
                            if (task.isSuccessful()) {
                                // Sign in success, update UI with the signed-in user's information
                                FirebaseUser user = mAuth.getCurrentUser();
                                Log.d(TAG, "signInWithCredential: UID : " + user.getUid());
                                user.getIdToken(true)
                                        .addOnCompleteListener(new OnCompleteListener<GetTokenResult>() {
                                            public void onComplete(@NonNull Task<GetTokenResult> task) {
                                                if (task.isSuccessful()) {
                                                    String idToken = task.getResult().getToken();
                                                    // Send token to your backend via HTTPS
                                                    Log.d(TAG, "signInWithCredential:success : " + idToken);
                                                } else {
                                                    Log.w(TAG, "signInWithCredential:failure", task.getException());
                                                }
                                            }
                                        });
                            } else {
                                // If sign in fails, display a message to the user.
                                Log.w(TAG, "signInWithCredential:failure", task.getException());
                            }

                            // ...
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public void firebaseAuthWithFacebook(Activity ac, AccessToken token) {
        AuthCredential credential = FacebookAuthProvider.getCredential(token.getToken());
        mAuth.signInWithCredential(credential)
                .addOnCompleteListener(ac, new OnCompleteListener<AuthResult>() {
                    @Override
                    public void onComplete(@NonNull Task<AuthResult> task) {
                        if (task.isSuccessful()) {
                            // Sign in success, update UI with the signed-in user's information
                            FirebaseUser user = mAuth.getCurrentUser();

                            Log.d(TAG, "signInWithCredential: UID : " + user.getUid());
                            user.getIdToken(true)
                                    .addOnCompleteListener(new OnCompleteListener<GetTokenResult>() {
                                        public void onComplete(@NonNull Task<GetTokenResult> task) {
                                            if (task.isSuccessful()) {
                                                String idToken = task.getResult().getToken();
                                                // Send token to your backend via HTTPS
                                                Log.d(TAG, "signInWithCredential:success : " + idToken);
                                            } else {
                                                Log.w(TAG, "signInWithCredential:failure", task.getException());
                                            }
                                        }
                                    });
                        } else {
                            // If sign in fails, display a message to the user.
                            Log.w(TAG, "signInWithCredential:failure", task.getException());
                        }

                        // ...
                    }
                });
    }

    public void signinFirebase(Activity ac) {
        String token = PrefManager.getString(ac, Constants.FIREBASE_TOKEN, "");
        if (StringUtils.isEmpty(token))
            firebaseSignInAnonymously(ac);
        else {
            Log.d(TAG, "automatic sign in anonymously: uid: " + mAuth.getCurrentUser().getUid());
            mAuth.getCurrentUser().getIdToken(true)
                    .addOnCompleteListener(new OnCompleteListener<GetTokenResult>() {
                        public void onComplete(@NonNull Task<GetTokenResult> task) {
                            if (task.isSuccessful()) {
                                String idToken = task.getResult().getToken();
                                // Send token to your backend via HTTPS
                                Log.d(TAG, "automatic sign in anonymously:success : " + idToken);
                                PrefManager.saveString(ac, Constants.FIREBASE_TOKEN, idToken);
                            } else {
                                Log.w(TAG, "automatic sign in anonymously: failure", task.getException());
                            }
                        }
                    });
        }

    }


    public void firebaseSignInAnonymously(Activity ac) {
        mAuth.signInAnonymously()
                .addOnCompleteListener(ac, new OnCompleteListener<AuthResult>() {
                    @Override
                    public void onComplete(@NonNull Task<AuthResult> task) {
                        if (task.isSuccessful()) {
                            // Sign in success, update UI with the signed-in user's information

                            FirebaseUser user = mAuth.getCurrentUser();

                            Log.d(TAG, "sign in anonymously: UID : " + user.getUid());
                            mAuth.getAccessToken(true).addOnCompleteListener(new OnCompleteListener<GetTokenResult>() {
                                public void onComplete(@NonNull Task<GetTokenResult> task) {
                                    if (task.isSuccessful()) {
                                        String idToken = task.getResult().getToken();
                                        // Send token to your backend via HTTPS
                                        Log.d(TAG, "get FireBase Authen :success : " + idToken);
                                    } else {
                                        Log.w(TAG, "get FireBase Authen:failure", task.getException());
                                    }
                                }
                            });
                            user.getIdToken(true)
                                    .addOnCompleteListener(new OnCompleteListener<GetTokenResult>() {
                                        public void onComplete(@NonNull Task<GetTokenResult> task) {
                                            if (task.isSuccessful()) {
                                                String idToken = task.getResult().getToken();
                                                // Send token to your backend via HTTPS
                                                Log.d(TAG, "sign in anonymously:success : " + idToken);
                                                PrefManager.saveString(ac, Constants.FIREBASE_TOKEN, idToken);
                                            } else {
                                                Log.w(TAG, "sign in anonymously: failure", task.getException());
                                            }
                                        }
                                    });

                        } else {
                            // If sign in fails, display a message to the user.
                            Log.w(TAG, "signInWithCredential:failure", task.getException());
                        }

                        // ...
                    }
                });
    }


}
