package com.game.sdk.comon.api.request;

import com.game.sdk.comon.constants.ConstantApi;
import com.game.sdk.comon.object.request.VerifyPurchaseRequestObj;
import com.game.sdk.comon.object.response.LoginPlayNowResponseObj;
import com.game.sdk.comon.object.response.RetryPaymentResponseObj;
import com.game.sdk.comon.object.response.VerifyPurchaseResponseObj;

import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;

/**
 * Created by dungnv
 */
public interface PaymentRequest {

    @Headers({"Content-Type: application/json", "Accept:application/json"})
    @POST(ConstantApi.URL_VERIFY_PURCHASE)
    Call<VerifyPurchaseResponseObj> verifyPurchase(@Path("order_no") String order_no,
                                                   @Body VerifyPurchaseRequestObj body);

    @FormUrlEncoded
    @Headers({"Accept:application/json"})
    @POST(ConstantApi.URL_RETRY_PURCHASE)
    Call<RetryPaymentResponseObj> retryPayment(@Field("app_key") String appKey,
                                               @Field("app_version") String app_version,
                                               @Field("user_id") String user_id,
                                               @Field("character_id") String character_id,
                                               @Field("area_id") String areaId,
                                               @Field("package_name") String packageName,
                                               @Field("purchase_token") String purchaseToken,
                                               @Field("product_id") String productId);

}
