/*
 * Decompiled with CFR 0.152.
 */
package com.game.sdk.comon.login;

import android.app.Activity;
import android.app.DialogFragment;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Handler;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.game.sdk.comon.listener.IAuthentGoogleListener;
import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GoogleAuthUtil;
import com.google.android.gms.auth.api.signin.GoogleSignIn;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInClient;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.tasks.Task;
import java.io.IOException;

public class GoogleManager {
    public static final int RC_SIGN_IN = 9700;
    private static GoogleManager googleManager;
    private Context context;
    GoogleSignInClient mGoogleSignInClient;
    IAuthentGoogleListener listener;
    private String SCOPE = "oauth2:https://www.googleapis.com/auth/userinfo.profile";
    Handler mHandler;
    Runnable runnable;

    public static GoogleManager getInstance(Context context) {
        if (googleManager == null) {
            googleManager = new GoogleManager(context);
        }
        return googleManager;
    }

    public GoogleManager(Context context) {
        this.context = context;
        GoogleSignInOptions gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN).requestEmail().build();
        this.mGoogleSignInClient = GoogleSignIn.getClient((Context)context, (GoogleSignInOptions)gso);
        this.mHandler = new Handler();
    }

    public void startAuthForResult(Activity activity, @NonNull IAuthentGoogleListener listener) {
        Intent signInIntent = this.mGoogleSignInClient.getSignInIntent();
        activity.startActivityForResult(signInIntent, 9700);
    }

    public void startAuthForResult(Fragment fragment, @NonNull IAuthentGoogleListener listener) {
        Intent signInIntent = this.mGoogleSignInClient.getSignInIntent();
        fragment.startActivityForResult(signInIntent, 9700);
    }

    public void startAuthForResult(final DialogFragment dialogFragment, @NonNull IAuthentGoogleListener listener) {
        this.listener = listener;
        if (this.mHandler != null && this.runnable != null) {
            this.mHandler.removeCallbacks(this.runnable);
        }
        this.runnable = new Runnable(){

            @Override
            public void run() {
                GoogleManager.this.logout();
                Intent signInIntent = GoogleManager.this.mGoogleSignInClient.getSignInIntent();
                dialogFragment.startActivityForResult(signInIntent, 9700);
            }
        };
        this.mHandler.postDelayed(this.runnable, 300L);
    }

    public void logout() {
        this.mGoogleSignInClient.signOut();
    }

    public void onAuthGoogleResult(Intent data, int resultCode) {
        if (resultCode == 0 && this.listener != null) {
            this.listener.onAuthGGCancel();
            return;
        }
        try {
            Task signinTask = GoogleSignIn.getSignedInAccountFromIntent((Intent)data);
            GoogleSignInAccount account = (GoogleSignInAccount)signinTask.getResult(ApiException.class);
            if (account != null) {
                String str = account.getIdToken();
                if (this.listener != null) {
                    new GetToken(account, this.SCOPE).execute(new Void[0]);
                }
            } else if (this.listener != null) {
                this.listener.onAuthGGFailed(-1, "Google Signin Error");
            }
        }
        catch (ApiException e) {
            this.listener.onAuthGGFailed(e.getStatusCode(), e.getMessage());
        }
    }

    public String getToken(String email, String scope) throws IOException, GoogleAuthException {
        return GoogleAuthUtil.getToken((Context)this.context, (String)email, (String)scope);
    }

    class GetToken
    extends AsyncTask<Void, Void, String> {
        String mScope;
        GoogleSignInAccount account;

        public GetToken(GoogleSignInAccount account, String scope) {
            this.account = account;
            this.mScope = scope;
        }

        protected String doInBackground(Void ... params) {
            try {
                return GoogleManager.this.getToken(this.account.getEmail(), this.mScope);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (GoogleAuthException e) {
                e.printStackTrace();
            }
            return "";
        }

        protected void onPostExecute(String aVoid) {
            super.onPostExecute((Object)aVoid);
            try {
                if (!TextUtils.isEmpty((CharSequence)aVoid) && GoogleManager.this.listener != null) {
                    GoogleManager.this.listener.onAuthGGSuccess(this.account, aVoid);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

