package com.game.sdk.comon.js;

import android.app.Activity;
import android.content.Intent;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import android.util.Log;
import android.webkit.JavascriptInterface;

import com.game.sdk.comon.cmd.CmdPaymentV3;
import com.game.sdk.comon.js.command.CmdDashboard;
import com.game.sdk.comon.js.command.CmdLogin;
import com.game.sdk.comon.utils.ToastUtils;
import com.mobgame.gui.MobGameWebFragment;
import com.mobgame.gui.dialog.MobGameDialogStartWebFragment;
import com.mobgame.gui.dialog.MobGameDialogWebviewFragment;
import com.mobgame.gui.dialog.MobGameHaveBackButtonFragment;
import com.mobgame.utils.Constants;

public class JsHandler {

    private static String TAG = JsHandler.class.getSimpleName();

    private Activity activity;
    private MobGameWebFragment webFragment;
    private MobGameHaveBackButtonFragment webDialogHaveBackButton;
    private MobGameDialogWebviewFragment dialogWebviewFragment;
    private MobGameDialogStartWebFragment dialogStartWebFragment;

    //----------------------SDK 5.0.0

    private enum switchCommandJS {
        //SDK 5.0 ----------------------------------------------------------------------------------
        loginSuccess,
        actionConnectFb,
        updateSuccess,
        openFanPage,
        openGroup,
        openContact,
        openBrowser,
        makePhoneCall,
        uploadImageToServer,
        getImageFromDevice,
        deleteImageLocal,
        deleteAllImageLocal,
        copyToClipboard,
        openLink,
        inviteFbSuccess,
        closeWindow,
        openWindow,


        //------------------------------------------------------------------------------------------
        mobOpenFanPage,
        mobOpenGroup,
        mobOpenContact,
        mobPaymentStartIAP,
        mobPaymentStartPayPal,
        mobPaymentSuccess,
        mobOpenBrowser,
        mobOpenModal,
        mobSendEmail,
        mobSendSMS,
        mobMakePhoneCall,
        mobCopyToClipboard,
        loadImageUpload,
        mobGetIssue,
        deleteImageData,
        mobGetError,
        mobCloseVC,
        mobCloseWindow,
        mobChooseFriend,
        mobDisplayGC,
        mobOpenLink,
        mobTrackData,
        track,
        calendar,
        closeWebViewPopup,
        closePopupStart
    }

    public JsHandler(Activity activity) {
        this.activity = activity;
    }

    public JsHandler(Activity activity, MobGameDialogWebviewFragment dialogWebviewFragment) {
        this.activity = activity;
        this.dialogWebviewFragment = dialogWebviewFragment;
    }

    public JsHandler(Activity activity, MobGameDialogStartWebFragment dialogStartWebFragment) {
        this.activity = activity;
        this.dialogStartWebFragment = dialogStartWebFragment;
    }

    public JsHandler(Activity activity, MobGameWebFragment webFragment) {
        this.activity = activity;
        this.webFragment = webFragment;
    }


    public JsHandler(Activity activity, MobGameHaveBackButtonFragment webDialogHaveBackButton) {
        this.activity = activity;
        this.webDialogHaveBackButton = webDialogHaveBackButton;
    }


    @JavascriptInterface
    public void mobAppSDKexecute(String command, String params) {
        try {
            Log.i(TAG, "mobAppSDKexecute: command = " + command + "; params = " + params);

            switch (switchCommandJS.valueOf(command)) {

                /**********  PAYMENT  **********/
                case mobPaymentSuccess:
                    CmdPaymentV3.getInstance().mobPaymentSuccess(activity, params);
                    break;
                // END PAYMENT

                /**********  DASHBOARD  **********/
                case mobOpenContact:
                    CmdDashboard.getInstance().mobOpenContact(activity, params);
                    break;
                case openContact:
                    CmdDashboard.getInstance().mobOpenContact(activity, params);
                    break;
                case mobSendEmail:
                    CmdDashboard.getInstance().mobSendEmail(activity, params);
                    break;
                case mobSendSMS:
                    CmdDashboard.getInstance().mobSendSMS(activity, params);
                    break;
                case mobOpenBrowser:
                    CmdDashboard.getInstance().mobOpenBrowser(activity, params);
                    break;
                case openBrowser:
                    CmdDashboard.getInstance().mobOpenBrowser(activity, params);
                    break;
                case mobOpenFanPage:
                    CmdDashboard.getInstance().mobOpenFBFanpage(activity, params);
                    break;
                case openFanPage:
                    CmdDashboard.getInstance().mobOpenFBFanpage(activity, params);
                    break;
                case mobOpenGroup:
                    CmdDashboard.getInstance().mobOpenFBGroup(activity, params);
                    break;
                case openGroup:
                    CmdDashboard.getInstance().mobOpenFBGroup(activity, params);
                    break;
                case mobOpenModal:
                    CmdDashboard.getInstance().mobOpenModal(activity, params);
                    break;
                case mobMakePhoneCall:
                    CmdDashboard.getInstance().mobMakePhoneCall(activity, params);
                    break;
                case makePhoneCall:
                    CmdDashboard.getInstance().mobMakePhoneCall(activity, params);
                    break;
                case mobCopyToClipboard:
                    CmdDashboard.getInstance().mobCopyToClipboard(activity, params);
                    break;
                case copyToClipboard:
                    CmdDashboard.getInstance().mobCopyToClipboard(activity, params);
                    break;
                case loadImageUpload:
                    CmdDashboard.getInstance().mobSelectImage2(activity, dialogWebviewFragment, params);
                    break;
                case getImageFromDevice:
                    CmdDashboard.getInstance().mobSelectImage2(activity, dialogWebviewFragment, params);
                    break;
                case mobGetIssue:
                    CmdDashboard.getInstance().mobGetIssue(activity, dialogWebviewFragment, params);
                    break;
                case uploadImageToServer:
                    CmdDashboard.getInstance().mobGetIssue(activity, dialogWebviewFragment, params);
                    break;
                case deleteImageData:
                    CmdDashboard.getInstance().deleteImageData(activity, webFragment, params);
                    break;
                case deleteImageLocal:
                    CmdDashboard.getInstance().deleteImageData(activity, webFragment, params);
                    break;
                case mobGetError:
                    CmdDashboard.getInstance().clearImageData(activity);
                    break;
                case deleteAllImageLocal:
                    CmdDashboard.getInstance().clearImageData(activity);
                    break;
                case mobCloseVC:
//                    dialogWebviewFragment.dismiss();
                    CmdDashboard.getInstance().mobRefreshBugForm(activity, params, dialogWebviewFragment);
                    break;
                case closeWindow:
//                    dialogWebviewFragment.dismiss();
                    CmdDashboard.getInstance().mobRefreshBugForm(activity, params, dialogWebviewFragment);
                    break;
                case mobCloseWindow:
                    break;
                case mobChooseFriend:
                    CmdDashboard.getInstance().mobChooseFriend(activity, params);
                    break;

                case inviteFbSuccess:
                    CmdDashboard.getInstance().mobChooseFriend(activity, params);
                    break;
                case mobOpenLink:
                    CmdDashboard.getInstance().mobOpenDialogWebView(activity, params);
                    break;
                case openLink:
                    CmdDashboard.getInstance().mobOpenDialogWebView(activity, params);
                    break;
                case mobTrackData:
                    // tracking GA
                    CmdDashboard.getInstance().trackingDetailWeb(activity, params);
                    break;
                case track:
                    CmdDashboard.getInstance().trackingFromWeb(activity, params);
                    break;
                // END DASHBOARD
                case calendar:
                    CmdDashboard.getInstance().setUpReminder(activity, params);
                    break;
                case closeWebViewPopup:
                    dialogWebviewFragment.dismiss();
                    break;
                case closePopupStart:
                    Intent intent = new Intent(Constants.INTENT_FILTER);
                    intent.putExtra("category", "float_button");
                    LocalBroadcastManager.getInstance(activity).sendBroadcast(intent);
                    dialogStartWebFragment.dismiss();
                    break;
                //-----------------------------------------SDK 5.0.0 ------------------------------
                case actionConnectFb:
                    CmdLogin.getInstance().mobUpgradeFacebook(activity, dialogWebviewFragment, dialogStartWebFragment, params);
                    break;
                case updateSuccess:
                    ToastUtils.showToDoToast(activity, " updateSuccess Cho cả connect fb và update profile");
                default:
                    break;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}