/*
 * Decompiled with CFR 0.152.
 */
package com.game.sdk.comon.tracking;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.util.Log;
import android.view.View;
import com.appsflyer.AppsFlyerConversionListener;
import com.appsflyer.AppsFlyerTrackingRequestListener;
import com.game.ads.AdsPlayFun;
import com.game.sdk.comon.config.GameConfigs;
import com.game.sdk.comon.game.GameSdk;
import com.game.sdk.comon.object.VerifyPurchaseObj;
import com.game.sdk.comon.sharePref.PrefManager;
import com.game.sdk.comon.tracking.AppsFyer;
import com.game.sdk.comon.tracking.Firebase;
import com.game.sdk.comon.utils.DeviceUtils;
import com.game.sdk.comon.utils.LogUtils;
import java.util.HashMap;
import java.util.Map;

public class TrackingUtil {
    public static String TAG = TrackingUtil.class.getName();
    private String appsflyerDevkey = "cfgYFoj97okaEbzqp8q5w5";
    private AppsFyer appsFyer;
    private Context context;
    private Firebase firebase;
    private long beginTime;
    private static TrackingUtil trackingUtil;
    AppsFlyerConversionListener conversionListener = new AppsFlyerConversionListener(){

        public void onConversionDataSuccess(Map<String, Object> conversionData) {
            for (String attrName : conversionData.keySet()) {
                if (!attrName.equals("is_first_launch") || !((Boolean)conversionData.get(attrName)).booleanValue()) continue;
                LogUtils.d(TAG, "Start track event first laucher");
                TrackingUtil.this.trackFirstLaunch();
            }
        }

        public void onConversionDataFail(String errorMessage) {
            LogUtils.d(TAG, "error getting conversion data: " + errorMessage);
        }

        public void onAppOpenAttribution(Map<String, String> attributionData) {
            for (String attrName : attributionData.keySet()) {
                LogUtils.d(TAG, "attribute: " + attrName + " = " + attributionData.get(attrName));
            }
        }

        public void onAttributionFailure(String errorMessage) {
            LogUtils.d(TAG, "error onAttributionFailure : " + errorMessage);
        }
    };

    public void init(Application application) {
        this.context = application;
        this.appsFyer = AppsFyer.newInstance(application, this.appsflyerDevkey, this.conversionListener);
        this.firebase = Firebase.newInstance(application);
    }

    public static TrackingUtil getInstance() {
        if (trackingUtil == null) {
            trackingUtil = new TrackingUtil();
        }
        return trackingUtil;
    }

    public void trackFirstLaunch() {
        this.beginTime = System.currentTimeMillis();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time_first_launcher", this.beginTime);
        this.trackEvent("ft_first_launched", map);
    }

    public void trackAppLaunch() {
        this.beginTime = System.currentTimeMillis();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time_app_launcher", String.valueOf(this.beginTime));
        this.trackEvent("ft_app_launched", map);
    }

    public void trackFromWeb(String label, String value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TYPE_LOGIN", value);
        this.trackEvent(label, map);
    }

    public void trackLogoutSuccess(int userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ft_user_id", String.valueOf(userId));
        this.trackEvent("ft_logout_success", map);
    }

    public void trackAppClose() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.trackEvent("ft_app_close", map);
    }

    public void trackPurchaseLog() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.trackEvent("ft_purchase_log", map);
    }

    public void trackPaymentScreenOpened() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String character_id = PrefManager.getString((Context)GameSdk.getInstance().getApplication(), "MOB_ROLE_ID", "");
        String area_id = PrefManager.getString((Context)GameSdk.getInstance().getApplication(), "MOB_AREA_ID", "");
        String user_id = "";
        try {
            user_id = user_id + GameConfigs.getInstance().getUser().getId();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        hashMap.put("ft_user_id", user_id);
        hashMap.put("ft_role_id", character_id);
        hashMap.put("ft_area_id", area_id);
        this.trackEvent("ft_payment_screen_opened", hashMap);
    }

    public void trackPaymentLoadScreenSuccess() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String character_id = PrefManager.getString((Context)GameSdk.getInstance().getApplication(), "MOB_ROLE_ID", "");
        String area_id = PrefManager.getString((Context)GameSdk.getInstance().getApplication(), "MOB_AREA_ID", "");
        String user_id = "";
        try {
            user_id = user_id + GameConfigs.getInstance().getUser().getId();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        hashMap.put("ft_user_id", user_id);
        hashMap.put("ft_role_id", character_id);
        hashMap.put("ft_area_id", area_id);
        this.trackEvent("ft_payment_screen_load_success", hashMap);
    }

    public void trackPaymentLoadScreenFail(String error_code, String error_message) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String character_id = PrefManager.getString((Context)GameSdk.getInstance().getApplication(), "MOB_ROLE_ID", "");
        String area_id = PrefManager.getString((Context)GameSdk.getInstance().getApplication(), "MOB_AREA_ID", "");
        String user_id = "";
        try {
            user_id = user_id + GameConfigs.getInstance().getUser().getId();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        hashMap.put("ft_user_id", user_id);
        hashMap.put("ft_role_id", character_id);
        hashMap.put("ft_area_id", area_id);
        hashMap.put("error_code", error_code);
        hashMap.put("error_message", error_message);
        this.trackEvent("ft_payment_screen_load_fail", hashMap);
    }

    public void trackPaymentBeforVerify(String order_no) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String character_id = PrefManager.getString((Context)GameSdk.getInstance().getApplication(), "MOB_ROLE_ID", "");
        String area_id = PrefManager.getString((Context)GameSdk.getInstance().getApplication(), "MOB_AREA_ID", "");
        String user_id = "";
        long currentTime = System.currentTimeMillis();
        try {
            user_id = user_id + GameConfigs.getInstance().getUser().getId();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        hashMap.put("ft_user_id", user_id);
        hashMap.put("ft_role_id", character_id);
        hashMap.put("ft_area_id", area_id);
        hashMap.put("order_no", order_no);
        hashMap.put("timestamp", String.valueOf(currentTime));
        PrefManager.saveLong((Context)GameSdk.getInstance().getApplication(), "ft_payment_before_verify", currentTime);
        this.trackEvent("ft_payment_before_verify", hashMap);
    }

    public void trackPaymentVerifySuccess(VerifyPurchaseObj obj) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            String character_id = PrefManager.getString((Context)GameSdk.getInstance().getApplication(), "MOB_ROLE_ID", "");
            String area_id = PrefManager.getString((Context)GameSdk.getInstance().getApplication(), "MOB_AREA_ID", "");
            String user_id = "";
            long currentTime = System.currentTimeMillis();
            long startCall = PrefManager.getLong((Context)GameSdk.getInstance().getApplication(), "ft_payment_before_verify", currentTime);
            long deta_call = currentTime - startCall;
            try {
                user_id = user_id + GameConfigs.getInstance().getUser().getId();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            hashMap.put("ft_user_id", user_id);
            hashMap.put("ft_role_id", character_id);
            hashMap.put("ft_area_id", area_id);
            hashMap.put("order_no", obj.getOrder_no());
            hashMap.put("timestamp", String.valueOf(currentTime));
            hashMap.put("delta_call", String.valueOf(deta_call));
            double price = 0.01 * (double)obj.getPlatform_price();
            hashMap.put("af_revenue", price);
            hashMap.put("af_content_type", "category_rev");
            hashMap.put("af_content_id", "123456");
            hashMap.put("af_currency", "USD");
            hashMap.put("af_order_id", obj.getOrder_no());
            this.trackEventAF("af_purchase", hashMap);
            HashMap<String, Object> hashMapFB = new HashMap<String, Object>();
            hashMapFB.put("ft_user_id", user_id);
            hashMapFB.put("ft_role_id", character_id);
            hashMapFB.put("ft_area_id", area_id);
            hashMapFB.put("order_no", obj.getOrder_no());
            hashMapFB.put("timestamp", String.valueOf(currentTime));
            hashMapFB.put("delta_call", String.valueOf(deta_call));
            hashMapFB.put("coupon", "SummerPromo");
            hashMapFB.put("currency", "USD");
            hashMapFB.put("value", price);
            hashMapFB.put("transaction_id", obj.getOrder_no());
            this.trackEventFireBase("purchase", hashMapFB);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackPaymentVerifyFail(String order_no, String type_error, String err_code, String err_mesage) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String character_id = PrefManager.getString((Context)GameSdk.getInstance().getApplication(), "MOB_ROLE_ID", "");
        String area_id = PrefManager.getString((Context)GameSdk.getInstance().getApplication(), "MOB_AREA_ID", "");
        String user_id = "";
        long currentTime = System.currentTimeMillis();
        long startCall = PrefManager.getLong((Context)GameSdk.getInstance().getApplication(), "ft_payment_before_verify", currentTime);
        long deta_call = currentTime - startCall;
        try {
            user_id = user_id + GameConfigs.getInstance().getUser().getId();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        hashMap.put("ft_user_id", user_id);
        hashMap.put("ft_role_id", character_id);
        hashMap.put("ft_area_id", area_id);
        hashMap.put("order_no", order_no);
        hashMap.put("type_error", type_error);
        hashMap.put("timestamp", String.valueOf(currentTime));
        hashMap.put("delta_call", String.valueOf(deta_call));
        hashMap.put("error_code", err_code);
        hashMap.put("error_message", err_mesage);
        this.trackEvent("ft_payment_verify_fail", hashMap);
    }

    public void trackStartExtractData(Activity activity) {
        Log.d((String)TAG, (String)"trackStartExtractData: ");
        AdsPlayFun.getInstance().showAds((Context)activity, "extract_data", "", DeviceUtils.getAdvertisingID((Context)activity) == null ? "" : DeviceUtils.getAdvertisingID((Context)activity), "");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        hashMap.put("delta", String.valueOf(delta));
        hashMap.put("timestamp", String.valueOf(currentTime));
        PrefManager.saveLong(this.context, "BEGIN_ACTION_TIME", currentTime);
        this.trackEvent("ft_extract_started", hashMap);
    }

    public void trackFinishExtractData() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        hashMap.put("timestamp", String.valueOf(currentTime));
        hashMap.put("delta", String.valueOf(delta));
        hashMap.put("delta_extract", String.valueOf(PrefManager.getLong(this.context, "BEGIN_ACTION_TIME", currentTime)));
        PrefManager.saveLong(this.context, "BEGIN_ACTION_TIME", 0L);
        this.trackEvent("ft_extract_finished", hashMap);
    }

    public void trackDownloadResourceStarted() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        map.put("delta", String.valueOf(delta));
        map.put("timestamp", String.valueOf(currentTime));
        PrefManager.saveLong(this.context, "BEGIN_ACTION_TIME", currentTime);
        this.trackEvent("ft_resource_started", map);
    }

    public void trackDownloadResourceFinished() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        map.put("timestamp", String.valueOf(currentTime));
        map.put("delta", String.valueOf(delta));
        map.put("delta_extract", String.valueOf(PrefManager.getLong(this.context, "BEGIN_ACTION_TIME", currentTime)));
        PrefManager.saveSetting((Context)GameSdk.getInstance().getApplication(), "ft_resource_finished", currentTime);
        this.trackEvent("ft_resource_finished", map);
    }

    public void trackExtractCDNFinished(Activity activity) {
        AdsPlayFun.getInstance().showAds((Context)activity, "extract_data", "", DeviceUtils.getAdvertisingID((Context)activity) == null ? "" : DeviceUtils.getAdvertisingID((Context)activity), "");
        HashMap<String, Object> map = new HashMap<String, Object>();
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        long delta_resource = currentTime - PrefManager.getLong((Context)GameSdk.getInstance().getApplication(), "ft_resource_finished", currentTime);
        map.put("timestamp", String.valueOf(currentTime));
        map.put("delta", String.valueOf(delta));
        map.put("delta_resource", String.valueOf(delta_resource));
        this.trackEvent("ft_extract_cdn_finished", map);
    }

    public void trackSession() {
        long endTime = System.currentTimeMillis();
        long deltaTime = endTime - this.beginTime;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("ft_start_time", String.valueOf(this.beginTime));
        hashMap.put("ft_end_time ", String.valueOf(endTime));
        hashMap.put("ft_length_second", String.valueOf(deltaTime));
        this.trackEvent("ft_session", hashMap);
    }

    public void trackLastSession(Context ct) {
        int minute = PrefManager.getInt(ct, "SESSION_OUT_TIME", 10);
        long milisecond = minute * 60 * 1000;
        long begin = PrefManager.getLong(ct, "LAST_SESSION_START", 0L);
        long endTime = PrefManager.getLong(ct, "LAST_SESSION_END", 0L);
        long deltaTime = PrefManager.getLong(ct, "LAST_SESSION_DETAl", 0L);
        if (begin == 0L || endTime == 0L) {
            return;
        }
        if (deltaTime < milisecond) {
            return;
        }
        if (this.beginTime - endTime < milisecond) {
            this.beginTime = begin;
            return;
        }
        LogUtils.d(TAG, "Begin: " + begin + " - End : " + endTime + " - Detal : " + deltaTime);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("ft_start_time", String.valueOf(begin));
        hashMap.put("ft_end_time ", String.valueOf(endTime));
        hashMap.put("ft_length_second", String.valueOf(deltaTime));
        this.trackEvent("ft_session", hashMap);
        this.clearSession(ct);
    }

    public void saveSession(Context ct) {
        long endTime = System.currentTimeMillis();
        long deltaTime = endTime - this.beginTime;
        PrefManager.saveSetting(ct, "LAST_SESSION_START", this.beginTime);
        PrefManager.saveSetting(ct, "LAST_SESSION_END", endTime);
        PrefManager.saveSetting(ct, "LAST_SESSION_DETAl", deltaTime);
    }

    public void clearSession(Context ct) {
        PrefManager.saveSetting(ct, "LAST_SESSION_START", 0);
        PrefManager.saveSetting(ct, "LAST_SESSION_END", 0);
        PrefManager.saveSetting(ct, "LAST_SESSION_DETAl", 0);
    }

    public void trackLoginSuccess(int userId, String type, String loginOrRegisterType) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        long start_open_login = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", currentTime);
        long deta_login = currentTime - start_open_login;
        hashMap.put("timestamp", String.valueOf(currentTime));
        hashMap.put("delta", String.valueOf(delta));
        hashMap.put("delta_login", String.valueOf(deta_login));
        hashMap.put("ft_user_id", String.valueOf(userId));
        hashMap.put("ft_type", type);
        hashMap.put("ft_login_or_register_type", loginOrRegisterType);
        this.trackEvent("af_login", hashMap);
    }

    public void trackClickBtnEnterGame(int serverId) {
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("delta", String.valueOf(delta));
        hashMap.put("timestamp", String.valueOf(currentTime));
        hashMap.put("ft_server_id", String.valueOf(serverId));
        this.trackEvent("ft_enter_game_btn_clicked", hashMap);
    }

    public void trackCharactorCreated(Activity activity, int user_id, String role_id, String area_id) {
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("delta", String.valueOf(delta));
        hashMap.put("timestamp", String.valueOf(currentTime));
        hashMap.put("ft_user_id", String.valueOf(user_id));
        hashMap.put("ft_role_id", role_id);
        hashMap.put("ft_area_id", area_id);
        this.trackEvent("ft_character_created", hashMap);
    }

    public void trackCharactorCreatedSuccess(int user_id, String role_id, String area_id) {
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("delta", String.valueOf(delta));
        hashMap.put("timestamp", String.valueOf(currentTime));
        hashMap.put("ft_user_id", String.valueOf(user_id));
        hashMap.put("ft_role_id", role_id);
        hashMap.put("ft_area_id", area_id);
        this.trackEvent("ft_character_created_call_api_success", hashMap);
    }

    public void trackCharactorCreatedFailed(int user_id, String role_id, String area_id) {
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.beginTime;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("delta", String.valueOf(delta));
        hashMap.put("timestamp", String.valueOf(currentTime));
        hashMap.put("ft_user_id", String.valueOf(user_id));
        hashMap.put("ft_role_id", role_id);
        hashMap.put("ft_area_id", area_id);
        this.trackEvent("ft_character_created_call_api_fail", hashMap);
    }

    public void trackTutorialCompletion(int user_id, String role_id, String area_id) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("ft_user_id", String.valueOf(user_id));
        hashMap.put("ft_role_id", role_id);
        hashMap.put("ft_area_id", area_id);
        this.trackEvent("af_tutorial_completion", hashMap);
    }

    public void trackLevelAchieved(Activity activity, int user_id, String role_id, String area_id, String af_level) {
        AdsPlayFun.getInstance().showAds((Context)activity, "level_up", af_level, DeviceUtils.getAdvertisingID((Context)activity) == null ? "" : DeviceUtils.getAdvertisingID((Context)activity), "");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("ft_user_id", String.valueOf(user_id));
        hashMap.put("ft_role_id", role_id);
        hashMap.put("ft_area_id", area_id);
        hashMap.put("af_level ", af_level);
        this.trackEvent("af_level_achieved", hashMap);
    }

    public void trackVipAchieved(int user_id, String role_id, String area_id, String ft_vip) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("ft_user_id", String.valueOf(user_id));
        hashMap.put("ft_role_id", role_id);
        hashMap.put("ft_area_id", area_id);
        hashMap.put("ft_vip", ft_vip);
        this.trackEvent("ft_vip_achieved", hashMap);
    }

    public void trackLoginScreenOpen() {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        PrefManager.saveLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        this.trackEvent("ft_login_screen_opened", hashMap);
    }

    public void trackClickLoginButton(String btnTitle) {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        hashMap.put("ft_button_title", btnTitle);
        this.trackEvent("ft_ls_login_btn_clicked", hashMap);
    }

    public void trackClickLoginEmailButton() {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        this.trackEvent("ft_ls_login_email_btn_clicked", hashMap);
    }

    public void trackLoginEmailInputError(int errCode, String errMessage) {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        hashMap.put("error_code", String.valueOf(errCode));
        hashMap.put("error_message", errMessage);
        this.trackEvent("ft_ls_login_email_input_error", hashMap);
    }

    public void trackLoginEmailCallApi() {
        long current = System.currentTimeMillis();
        PrefManager.saveLong(this.context, "START_TIME_CALL_API", current);
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        this.trackEvent("ft_ls_login_email_api_call", hashMap);
    }

    public void trackLoginEmailCallApiSuccess() {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        long startTimeCallApi = PrefManager.getLong(this.context, "START_TIME_CALL_API", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        hashMap.put("delta_call", String.valueOf(current - startTimeCallApi));
        this.trackEvent("ft_ls_login_email_api_call_success", hashMap);
    }

    public void trackLoginEmailCallApiFail(int errCode, String mess) {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        long startTimeCallApi = PrefManager.getLong(this.context, "START_TIME_CALL_API", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        hashMap.put("delta_call", String.valueOf(current - startTimeCallApi));
        hashMap.put("error_code", String.valueOf(errCode));
        hashMap.put("error_message", mess);
        this.trackEvent("ft_ls_login_email_api_call_fail", hashMap);
    }

    public void trackClickLoginFacebookButton() {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        this.trackEvent("ft_ls_login_facebook_btn_clicked", hashMap);
    }

    public void trackCancelLoginFacebook() {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        this.trackEvent("ft_ls_login_facebook_user_canceled", hashMap);
    }

    public void trackLoginFacebookSdkErr(String mess) {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        hashMap.put("error_message", mess);
        this.trackEvent("ft_ls_login_facebook_have_error", hashMap);
    }

    public void trackLoginFacebookCallApi() {
        long current = System.currentTimeMillis();
        PrefManager.saveLong(this.context, "START_TIME_CALL_API", current);
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        this.trackEvent("ft_ls_login_facebook_api_call", hashMap);
    }

    public void trackLoginFacebookCallApiSuccess() {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        long startTimeCallApi = PrefManager.getLong(this.context, "START_TIME_CALL_API", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        hashMap.put("delta_call", String.valueOf(current - startTimeCallApi));
        this.trackEvent("ft_ls_login_facebook_api_call_success", hashMap);
    }

    public void trackLoginFacebookCallApiFail(int errCode, String mess) {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        long startTimeCallApi = PrefManager.getLong(this.context, "START_TIME_CALL_API", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        hashMap.put("delta_call", String.valueOf(current - startTimeCallApi));
        hashMap.put("error_code", String.valueOf(errCode));
        hashMap.put("error_message", mess);
        this.trackEvent("ft_ls_login_facebook_api_call_fail", hashMap);
    }

    public void trackClickLoginGoogleButton() {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        this.trackEvent("ft_ls_login_google_btn_clicked", hashMap);
    }

    public void trackCancelLoginGoogle() {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        this.trackEvent("ft_ls_login_google_user_canceled", hashMap);
    }

    public void trackLoginGoogleSdkErr(int errCode, String mess) {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        hashMap.put("error_code", String.valueOf(errCode));
        hashMap.put("error_message", mess);
        this.trackEvent("ft_ls_login_google_have_error", hashMap);
    }

    public void trackLoginGoogleCallApi() {
        long current = System.currentTimeMillis();
        PrefManager.saveLong(this.context, "START_TIME_CALL_API", current);
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        this.trackEvent("ft_ls_login_google_api_call", hashMap);
    }

    public void trackLoginGoogleCallApiSuccess() {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        long startTimeCallApi = PrefManager.getLong(this.context, "START_TIME_CALL_API", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        hashMap.put("delta_call", String.valueOf(current - startTimeCallApi));
        this.trackEvent("ft_ls_login_google_api_call_success", hashMap);
    }

    public void trackLoginGoogleCallApiFail(int errCode, String mess) {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        long startTimeCallApi = PrefManager.getLong(this.context, "START_TIME_CALL_API", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        hashMap.put("delta_call", String.valueOf(current - startTimeCallApi));
        hashMap.put("error_code", String.valueOf(errCode));
        hashMap.put("error_message", mess);
        this.trackEvent("ft_ls_login_google_api_call_fail", hashMap);
    }

    public void trackLoginPlayNowCallApi() {
        long current = System.currentTimeMillis();
        PrefManager.saveLong(this.context, "START_TIME_CALL_API", current);
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        this.trackEvent("ft_ls_login_playnow_btn_clicked", hashMap);
    }

    public void trackLoginPlayNowCallApiSuccess() {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        long startTimeCallApi = PrefManager.getLong(this.context, "START_TIME_CALL_API", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        hashMap.put("delta_call", String.valueOf(current - startTimeCallApi));
        this.trackEvent("ft_ls_login_playnow_api_call_success", hashMap);
    }

    public void trackLoginPlayNowCallApiFail(int errCode, String mess) {
        long current = System.currentTimeMillis();
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        long startTimeCallApi = PrefManager.getLong(this.context, "START_TIME_CALL_API", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        hashMap.put("delta_call", String.valueOf(current - startTimeCallApi));
        hashMap.put("error_code", String.valueOf(errCode));
        hashMap.put("error_message", mess);
        this.trackEvent("ft_ls_login_playnow_api_call_fail", hashMap);
    }

    public void trackGetSdkConfigSuccess() {
        long current = System.currentTimeMillis();
        long start_time = PrefManager.getLong((Context)GameSdk.getInstance().getApplication(), "ft_ls_game_config_call_api_success", System.currentTimeMillis());
        long deltaTime = current - start_time;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta_call", String.valueOf(deltaTime));
        this.trackEvent("ft_ls_game_config_call_api_success", hashMap);
    }

    public void trackGetSdkConfigFailed(int code) {
        long current = System.currentTimeMillis();
        long start_time = PrefManager.getLong((Context)GameSdk.getInstance().getApplication(), "ft_ls_game_config_call_api_success", System.currentTimeMillis());
        long deltaTime = current - start_time;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta_call", String.valueOf(code));
        this.trackEvent("ft_ls_game_config_call_api_fail", hashMap);
    }

    public void trackClickBtnRegister() {
        long current = System.currentTimeMillis();
        PrefManager.saveLong(this.context, "START_TIME_CALL_API", current);
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        this.trackEvent("ft_ls_register_btn_clicked", hashMap);
    }

    public void trackRegisterLoadSuccess() {
        long current = System.currentTimeMillis();
        PrefManager.saveLong(this.context, "START_TIME_CALL_API", current);
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        this.trackEvent("ft_ls_register_form_load_success", hashMap);
    }

    public void trackRegisterSubmitForm() {
        long current = System.currentTimeMillis();
        PrefManager.saveLong(this.context, "START_TIME_CALL_API", current);
        long deltaTime = current - this.beginTime;
        long startTime = PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(current - startTime));
        this.trackEvent("ft_ls_register_form_submited", hashMap);
    }

    public void trackLoginScreenClose(View form, View text, View button) {
        long current = System.currentTimeMillis();
        PrefManager.saveLong(this.context, "START_TIME_CALL_API", current);
        long deltaTime = current - this.beginTime;
        long delta_login = current - PrefManager.getLong(this.context, "BEGIN_ACTION_LOGIN_TIME", current);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        hashMap.put("delta", String.valueOf(deltaTime));
        hashMap.put("delta_login", String.valueOf(delta_login));
        hashMap.put("d_form", form.getX() + "-" + form.getY() + "-" + form.getWidth() + "-" + form.getHeight());
        hashMap.put("d_text", text.getX() + "-" + text.getY() + "-" + text.getWidth() + "-" + text.getHeight());
        hashMap.put("d_button", button.getX() + "-" + button.getY() + "-" + button.getWidth() + "-" + button.getHeight());
        this.trackEvent("ft_ls_close_btn_clicked", hashMap);
    }

    public void trackCallAuthenConfigSuccess() {
        long current = System.currentTimeMillis();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        this.trackEvent("ft_ls_get_authen_api_call_success", hashMap);
    }

    public void trackMaintainScreenOpened() {
        long current = System.currentTimeMillis();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        this.trackEvent("ft_maintain_screen_opened", hashMap);
    }

    public void trackCallAuthenConfigFailed() {
        long current = System.currentTimeMillis();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        this.trackEvent("ft_ls_get_authen_api_call_fail", hashMap);
    }

    public void trackForgotPassword() {
        long current = System.currentTimeMillis();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", String.valueOf(current));
        long deltaTime = current - this.beginTime;
        hashMap.put("delta", String.valueOf(deltaTime));
        this.trackEvent("ft_ls_forgot_password_btn_clicked", hashMap);
    }

    public void trackClickOverlayPermission() {
        this.trackEvent("ft_overlay_click_permission", null);
    }

    public void trackStartPermisison() {
        this.trackEvent("ft_start_permisison", null);
    }

    public void trackEndPermisison() {
        this.trackEvent("ft_end_permission", null);
    }

    public String getAppsflyerDevkey() {
        return this.appsflyerDevkey;
    }

    public void trackEvent(final String eventName, HashMap<String, Object> map) {
        LogUtils.d(TAG, eventName);
        this.appsFyer.trackEventWithCountFailed(eventName, map, new AppsFlyerTrackingRequestListener(){

            public void onTrackingRequestSuccess() {
                LogUtils.d(TAG + "_send", eventName + " sended");
            }

            public void onTrackingRequestFailure(String s) {
                LogUtils.e(TAG + "_send", eventName + " send failed");
            }
        });
        this.firebase.firebaseEventTrack(eventName, map);
    }

    private void trackEventAF(final String eventName, HashMap<String, Object> map) {
        LogUtils.d(TAG, eventName);
        this.appsFyer.trackEventWithCountFailed(eventName, map, new AppsFlyerTrackingRequestListener(){

            public void onTrackingRequestSuccess() {
                LogUtils.d(TAG + "_send", eventName + " sended");
            }

            public void onTrackingRequestFailure(String s) {
                LogUtils.e(TAG + "_send", eventName + " send failed");
            }
        });
    }

    private void trackEventFireBase(String eventName, HashMap<String, Object> map) {
        LogUtils.d(TAG, eventName);
        this.firebase.firebaseEventTrack(eventName, map);
    }
}

