/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.utils.iab;

import android.text.TextUtils;
import com.game.sdk.comon.utils.LogUtils;
import com.mobgame.utils.iab.Base64;
import com.mobgame.utils.iab.Base64DecoderException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

public class Security {
    private static final String TAG = "IABUtil/Security";
    private static final String KEY_FACTORY_ALGORITHM = "RSA";
    private static final String SIGNATURE_ALGORITHM = "SHA1withRSA";

    public static boolean verifyPurchaseOld(String base64PublicKey, String signedData, String signature) {
        if (TextUtils.isEmpty((CharSequence)signedData) || TextUtils.isEmpty((CharSequence)base64PublicKey) || TextUtils.isEmpty((CharSequence)signature)) {
            LogUtils.e(TAG, "Purchase verification failed: missing data.");
            return false;
        }
        PublicKey key = Security.generatePublicKey(base64PublicKey);
        return Security.verify(key, signedData, signature);
    }

    public static PublicKey generatePublicKey(String encodedPublicKey) {
        try {
            byte[] decodedKey = Base64.decode(encodedPublicKey);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_FACTORY_ALGORITHM);
            return keyFactory.generatePublic(new X509EncodedKeySpec(decodedKey));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeySpecException e) {
            LogUtils.e(TAG, "Invalid key specification.");
            throw new IllegalArgumentException(e);
        }
        catch (Base64DecoderException e) {
            LogUtils.e(TAG, "Base64 decoding failed.");
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean verify(PublicKey publicKey, String signedData, String signature) {
        try {
            Signature sig = Signature.getInstance(SIGNATURE_ALGORITHM);
            sig.initVerify(publicKey);
            sig.update(signedData.getBytes());
            if (!sig.verify(Base64.decode(signature))) {
                LogUtils.e(TAG, "Signature verification failed.");
                return false;
            }
            return true;
        }
        catch (NoSuchAlgorithmException e) {
            LogUtils.e(TAG, "NoSuchAlgorithmException.");
        }
        catch (InvalidKeyException e) {
            LogUtils.e(TAG, "Invalid key specification.");
        }
        catch (SignatureException e) {
            LogUtils.e(TAG, "Signature exception.");
        }
        catch (Base64DecoderException e) {
            LogUtils.e(TAG, "Base64 decoding failed.");
        }
        return false;
    }
}

