/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gcm;

import android.app.AlarmManager;
import android.app.IntentService;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.PowerManager;
import android.os.SystemClock;
import android.util.Log;
import com.google.android.gcm.GCMRegistrar;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public abstract class GCMBaseIntentService
extends IntentService {
    public static final String TAG = "GCMBaseIntentService";
    private static final String WAKELOCK_KEY = "GCM_LIB";
    private static PowerManager.WakeLock sWakeLock;
    private static final Object LOCK;
    private final String[] mSenderIds;
    private static int sCounter;
    private static final Random sRandom;
    private static final int MAX_BACKOFF_MS;
    private static final String TOKEN;
    private static final String EXTRA_TOKEN = "token";

    protected GCMBaseIntentService() {
        this(GCMBaseIntentService.getName("DynamicSenderIds"), (String[])null);
    }

    protected GCMBaseIntentService(String ... senderIds) {
        this(GCMBaseIntentService.getName(senderIds), senderIds);
    }

    private GCMBaseIntentService(String name, String[] senderIds) {
        super(name);
        this.mSenderIds = senderIds;
    }

    private static String getName(String senderId) {
        String name = "GCMIntentService-" + senderId + "-" + ++sCounter;
        Log.v((String)TAG, (String)("Intent service name: " + name));
        return name;
    }

    private static String getName(String[] senderIds) {
        String flatSenderIds = GCMRegistrar.getFlatSenderIds(senderIds);
        return GCMBaseIntentService.getName(flatSenderIds);
    }

    protected String[] getSenderIds(Context context) {
        if (this.mSenderIds == null) {
            throw new IllegalStateException("sender id not set on constructor");
        }
        return this.mSenderIds;
    }

    protected abstract void onMessage(Context var1, Intent var2);

    protected void onDeletedMessages(Context context, int total) {
    }

    protected boolean onRecoverableError(Context context, String errorId) {
        return true;
    }

    protected abstract void onError(Context var1, String var2);

    protected abstract void onRegistered(Context var1, String var2);

    protected abstract void onUnregistered(Context var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onHandleIntent(Intent intent) {
        try {
            Context context = this.getApplicationContext();
            String action = intent.getAction();
            if (action.equals("com.google.android.c2dm.intent.REGISTRATION")) {
                GCMRegistrar.setRetryBroadcastReceiver(context);
                this.handleRegistration(context, intent);
            } else if (action.equals("com.google.android.c2dm.intent.RECEIVE")) {
                String messageType = intent.getStringExtra("message_type");
                if (messageType != null) {
                    if (messageType.equals("deleted_messages")) {
                        String sTotal = intent.getStringExtra("total_deleted");
                        if (sTotal != null) {
                            try {
                                int total = Integer.parseInt(sTotal);
                                Log.v((String)TAG, (String)("Received deleted messages notification: " + total));
                                this.onDeletedMessages(context, total);
                            }
                            catch (NumberFormatException e) {
                                Log.e((String)TAG, (String)("GCM returned invalid number of deleted messages: " + sTotal));
                            }
                        }
                    } else {
                        Log.e((String)TAG, (String)("Received unknown special message: " + messageType));
                    }
                } else {
                    this.onMessage(context, intent);
                }
            } else if (action.equals("com.google.android.gcm.intent.RETRY")) {
                String token = intent.getStringExtra(EXTRA_TOKEN);
                if (!TOKEN.equals(token)) {
                    Log.e((String)TAG, (String)("Received invalid token: " + token));
                    return;
                }
                if (GCMRegistrar.isRegistered(context)) {
                    GCMRegistrar.internalUnregister(context);
                } else {
                    String[] senderIds = this.getSenderIds(context);
                    GCMRegistrar.internalRegister(context, senderIds);
                }
            }
        }
        finally {
            Object object = LOCK;
            synchronized (object) {
                if (sWakeLock != null) {
                    sWakeLock.release();
                } else {
                    Log.e((String)TAG, (String)"Wakelock reference is null");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runIntentInService(Context context, Intent intent, String className) {
        Object object = LOCK;
        synchronized (object) {
            if (sWakeLock == null) {
                PowerManager pm = (PowerManager)context.getSystemService("power");
                sWakeLock = pm.newWakeLock(1, WAKELOCK_KEY);
            }
        }
        sWakeLock.acquire();
        intent.setClassName(context, className);
        context.startService(intent);
    }

    private void handleRegistration(Context context, Intent intent) {
        GCMRegistrar.cancelAppPendingIntent();
        String registrationId = intent.getStringExtra("registration_id");
        String error = intent.getStringExtra("error");
        String unregistered = intent.getStringExtra("unregistered");
        Log.d((String)TAG, (String)("handleRegistration: registrationId = " + registrationId + ", error = " + error + ", unregistered = " + unregistered));
        if (registrationId != null) {
            GCMRegistrar.resetBackoff(context);
            GCMRegistrar.setRegistrationId(context, registrationId);
            this.onRegistered(context, registrationId);
            return;
        }
        if (unregistered != null) {
            GCMRegistrar.resetBackoff(context);
            String oldRegistrationId = GCMRegistrar.clearRegistrationId(context);
            this.onUnregistered(context, oldRegistrationId);
            return;
        }
        Log.d((String)TAG, (String)("Registration error: " + error));
        if ("SERVICE_NOT_AVAILABLE".equals(error)) {
            boolean retry = this.onRecoverableError(context, error);
            if (retry) {
                int backoffTimeMs = GCMRegistrar.getBackoff(context);
                int nextAttempt = backoffTimeMs / 2 + sRandom.nextInt(backoffTimeMs);
                Log.d((String)TAG, (String)("Scheduling registration retry, backoff = " + nextAttempt + " (" + backoffTimeMs + ")"));
                Intent retryIntent = new Intent("com.google.android.gcm.intent.RETRY");
                retryIntent.putExtra(EXTRA_TOKEN, TOKEN);
                PendingIntent retryPendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)retryIntent, (int)0);
                AlarmManager am = (AlarmManager)context.getSystemService("alarm");
                am.set(3, SystemClock.elapsedRealtime() + (long)nextAttempt, retryPendingIntent);
                if (backoffTimeMs < MAX_BACKOFF_MS) {
                    GCMRegistrar.setBackoff(context, backoffTimeMs * 2);
                }
            } else {
                Log.d((String)TAG, (String)"Not retrying failed operation");
            }
        } else {
            this.onError(context, error);
        }
    }

    static {
        LOCK = GCMBaseIntentService.class;
        sCounter = 0;
        sRandom = new Random();
        MAX_BACKOFF_MS = (int)TimeUnit.SECONDS.toMillis(3600L);
        TOKEN = Long.toBinaryString(sRandom.nextLong());
    }
}

