package com.game.sdk.ui.payment;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.webkit.WebView;

import com.game.sdk.comon.config.GameConfigs;
import com.game.sdk.comon.game.BaseDialogWebFragment;
import com.game.sdk.comon.js.JsBase;
import com.game.sdk.comon.js.JsPayment;
import com.game.sdk.comon.listener.IWebViewClientListener;
import com.game.sdk.comon.object.BaseObj;
import com.game.sdk.comon.object.ListPurchaseHistoryObj;
import com.game.sdk.comon.object.ProductObj;
import com.game.sdk.comon.object.PurchaseHistoryObj;
import com.game.sdk.comon.object.err.VerifyPurchaseErrObj;
import com.game.sdk.comon.object.request.VerifyPurchaseRequestObj;
import com.game.sdk.comon.object.response.VerifyPurchaseResponseObj;
import com.game.sdk.comon.presenter.BaseView;
import com.game.sdk.comon.sharePref.PrefManager;
import com.game.sdk.comon.tracking.TrackingUtil;
import com.game.sdk.comon.utils.DeviceUtils;
import com.game.sdk.comon.utils.DialogUtils;
import com.game.sdk.comon.utils.LogUtils;
import com.game.sdk.comon.utils.PurchaseUtils;
import com.game.sdk.comon.utils.Utils;
import com.mobgame.R;
import com.mobgame.js.CmdPayment;
import com.mobgame.utils.iab.Purchase;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;

public class PaymentFragment extends BaseDialogWebFragment {
    public static String TAG = PaymentFragment.class.getSimpleName();
    IPaymentPresenter iPaymentPresenter;
    String account_id;
    int curent;
    PurchaseHistoryObj currentPurchase;
    PaymentGGSuccess paymentGGSuccess;
    boolean sendHistory;
    ArrayList<IPaymentPresenter> listPresenter;

    public static PaymentFragment newInstance(String url, PaymentGGSuccess paymentGGSuccess) {
        PaymentFragment frag = new PaymentFragment();
        Bundle args = new Bundle();
        args.putString(URL_WEBVIEW, url);
        LogUtils.d(TAG, url);
        frag.setArguments(args);
        frag.setPaymentGGSuccess(paymentGGSuccess);
        return frag;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            TrackingUtil.getInstance().trackPaymentScreenOpened();
            account_id = GameConfigs.getInstance().getUser().getAccount().getAccountId();
            listPresenter = new ArrayList<>();
        } catch (Exception e) {
            e.printStackTrace();
        }
        curent = -1;
        sendHistory = false;

    }

    @Override
    public void onResume() {
        super.onResume();
        if (sendHistory) {
            sendHistory = true;
//            checkPurchaseHistory();
        }
    }

    public void sendHistory(PurchaseHistoryObj obj) {
        IPaymentPresenter presenter = new PaymentPresenterImpl(new BaseView() {
            @Override
            public void showProgress(String message) {

            }

            @Override
            public void hideProgress() {

            }

            @Override
            public void success(Object x) {
                if (x instanceof VerifyPurchaseResponseObj) {
                    VerifyPurchaseResponseObj responseObj = (VerifyPurchaseResponseObj) x;
                    int status = responseObj.getData().getStatus();
                    if (status == 3 || status == 2 || status == 17)
                        TrackingUtil.getInstance().trackPaymentVerifySuccess(responseObj.getData());
                    else
                        TrackingUtil.getInstance().trackPaymentVerifyFail(obj.getOrder_no(), "code", String.valueOf(status), responseObj.getData().getDescription());
                    obj.setAccount_id(account_id);
                    PurchaseUtils.removeSuccessPurchase(obj, mActivity);
                    curent -= 1;
                    checkPurchaseHistory();
                    LogUtils.e(TAG, "Verify Success - " + obj.getOrder_no());
                }
            }

            @Override
            public void error(Object o) {
                if (o instanceof VerifyPurchaseErrObj) {
                    VerifyPurchaseErrObj err = (VerifyPurchaseErrObj) o;
                    LogUtils.e(TAG, "Verify failed - " + obj.getOrder_no() + " :" + err.getMessage());
                    checkPurchaseHistory();
                }
                if (o instanceof BaseObj) {
                    BaseObj err = (BaseObj) o;
                    TrackingUtil.getInstance().trackPaymentVerifyFail(obj.getOrder_no(), "http", String.valueOf(err.getStatus()), err.getMessage());
                }

            }
        });
        TrackingUtil.getInstance().trackPaymentBeforVerify(obj.getOrder_no());
        listPresenter.add(presenter);
        onVerifyPurchase(presenter, obj.getReceipt(), obj.getOrder_no());
    }

    public void checkPurchaseHistory() {
        curent += 1;
        ListPurchaseHistoryObj listPurchaseHistoryObj = PrefManager.getHistoryPurchase(mActivity, account_id);
        if (listPurchaseHistoryObj.getData() == null || listPurchaseHistoryObj.getData().size() == 0 || listPurchaseHistoryObj.getData().size() <= curent && curent >= 0)
            return;
        PurchaseHistoryObj obj = listPurchaseHistoryObj.getData().get(curent);
        sendHistory(obj);
    }


    public void onVerifyPurchase(IPaymentPresenter presenter, VerifyPurchaseRequestObj.Receipt receipt, String order_no) {
        VerifyPurchaseRequestObj obj = new VerifyPurchaseRequestObj();
        obj.setOrder_no(order_no);
        obj.setMethod("2");
        obj.setReceipt(receipt);
        obj.setApp_version(Utils.getGameVersion(mActivity));
        obj.setSdk_version(Utils.getSDKVersion(mActivity));
        obj.setDevice_name(DeviceUtils.getDevice());
        obj.setDevice_os(DeviceUtils.getOSInfo());
        obj.setResolution(DeviceUtils.getResolution(mActivity));
        obj.setNetwork(Utils.getNetwork(mActivity));
        obj.setAdvertising_id(DeviceUtils.getAdvertisingID(mActivity));
        obj.setAppsflyer_id(DeviceUtils.getAppsflyerUID(mActivity));
        obj.setLocale(GameConfigs.getInstance().getLang());
        if (presenter != null)
            presenter.verifyPurchase(obj);
    }

    @Override
    protected JsBase getJsHandler() {
        return new JsPayment(new JsPayment.Listener() {
            @Override
            public void onPaymentStartIAP(String params) {
                ProductObj obj = new ProductObj(params);

                if (TextUtils.isEmpty(obj.getOrder_no())) {
                    DialogUtils.showErrorDialog(mActivity, mActivity.getString(R.string.err_and_try_again_late));
                    return;
                }

                CmdPayment.getInstance().mobPaymentStartIAP(mActivity, params, new Listener() {

                    @Override
                    public void onProcessIAB(Purchase purchase) {
                        currentPurchase = new PurchaseHistoryObj();
                        String charactor_id = PrefManager.getString(mActivity, com.game.sdk.comon.constants.Constants.ROLE_ID, "");
                        String area_id = PrefManager.getString(mActivity, com.game.sdk.comon.constants.Constants.AREA_ID, "");
                        currentPurchase.setArea_id(area_id);
                        currentPurchase.setCharactor_id(charactor_id);
                        currentPurchase.setOrder_no(obj.getOrder_no());

                        try {
                            JSONObject joReceipt = new JSONObject(purchase.getOriginalJson());
                            VerifyPurchaseRequestObj.Receipt rec = new VerifyPurchaseRequestObj.Receipt();
                            rec.setData(joReceipt.toString());
                            rec.setItemType("inapp");
                            rec.setSignature(purchase.getSignature());
                            currentPurchase.setReceipt(rec);
                        } catch (JSONException e) {
                            LogUtils.e("Err Purchase", e.getMessage());
                        }
                        currentPurchase.setIs_send(false);
                        currentPurchase.setAccount_id(account_id);
                        LogUtils.d("RECEIPT 1", purchase.getOriginalJson());
                        for (IPaymentPresenter p : listPresenter) {
                            if (p != null)
                                p.cancelRequest();
                        }
                        PrefManager.saveUsePurchaseHistory(mActivity, account_id, currentPurchase);
                        if (paymentGGSuccess != null) {
                            dismiss();
                            paymentGGSuccess.onPaymentGGSuccess(currentPurchase);
                        }

                    }
                });

            }

            @Override
            public void onCloseWindow() {
                dismiss();
            }

            @Override
            public void onOpenWindow() {

            }

            @Override
            public void onBackToWindowns() {
                goBack();
            }
        });
    }

    @Override
    protected IWebViewClientListener getWebListener() {
        return new IWebViewClientListener() {
            @Override
            public void shouldOverrideUrlLoading(WebView view, String url) {

            }

            @Override
            public void onPageStarted(WebView view, String url, Bitmap favicon) {

            }

            @Override
            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                TrackingUtil.getInstance().trackPaymentLoadScreenFail(String.valueOf(errorCode), description);
            }

            @Override
            public void onPageFinished(WebView view, String url) {
                TrackingUtil.getInstance().trackPaymentLoadScreenSuccess();
            }
        };
    }


    public interface Listener {
        void onProcessIAB(Purchase purchase);
    }

    public interface PaymentGGSuccess {
        void onPaymentGGSuccess(PurchaseHistoryObj obj);
    }


    public void setPaymentGGSuccess(PaymentGGSuccess paymentGGSuccess) {
        this.paymentGGSuccess = paymentGGSuccess;
    }
}