package com.game.sdk.comon.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.Snackbar;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import com.game.sdk.comon.view.CustomToast;
import com.mobgame.R;
import com.mobgame.utils.Res;

public class ToastUtils {
    static CustomToast toast;
    private static View helloView;

    public static void showLongToast(Context context, String mess) {
        Toast.makeText(context, mess, Toast.LENGTH_LONG).show();
    }

    public static void showShortToast(Context context, String mess) {
        Toast.makeText(context, mess, Toast.LENGTH_SHORT).show();
    }


    public static void showHelloToast(Context context, String message) {
        if (toast != null)
            toast.cancel();
        toast = new CustomToast(context, CustomToast.TOAST_TYPE.HELLO, message);
        toast.setGravity(Gravity.TOP | Gravity.FILL_HORIZONTAL, 0, 0);
        toast.setDuration(Toast.LENGTH_SHORT);
        toast.show();
    }

    public static void showErrToast(Context context, String message) {
        if (toast != null)
            toast.cancel();
        toast = new CustomToast(context, CustomToast.TOAST_TYPE.ERR, message);
        toast.setGravity(Gravity.BOTTOM | Gravity.FILL_HORIZONTAL, 0, 0);
        toast.setDuration(Toast.LENGTH_SHORT);
        toast.show();
    }

    public static void showWarmToast(Context context, String message) {
        if (toast != null)
            toast.cancel();
        toast = new CustomToast(context, CustomToast.TOAST_TYPE.WARNING, message);
        toast.setGravity(Gravity.BOTTOM | Gravity.FILL_HORIZONTAL, 0, 0);
        toast.setDuration(Toast.LENGTH_SHORT);
        toast.show();
    }

    public static void showBottomInfoToast(Context context, String message) {
        if (toast != null)
            toast.cancel();
        toast = new CustomToast(context, CustomToast.TOAST_TYPE.INFO, message);
        toast.setGravity(Gravity.BOTTOM | Gravity.FILL_HORIZONTAL, 0, 0);
        toast.setDuration(Toast.LENGTH_SHORT);
        toast.show();
    }

    public static void showToDoToast(Context context, String message) {
        if (toast != null)
            toast.cancel();
        toast = new CustomToast(context, CustomToast.TOAST_TYPE.TODO, message);
        toast.setGravity(Gravity.BOTTOM | Gravity.FILL_HORIZONTAL, 0, 0);
        toast.setDuration(Toast.LENGTH_SHORT);
        toast.show();
    }


//    public static void showSnackbar(Activity ct, String message) {
//        View v = ct.findViewById(android.R.id.content);
//        if (v != null) {
//            Snackbar snackbar = Snackbar.make(v, message, Snackbar.LENGTH_LONG);
//            View sbView = snackbar.getView();
//            sbView.setBackgroundColor(ContextCompat.getColor(ct, R.color.md_blue_grey_800));
//            TextView textView = (TextView) sbView.findViewById(android.support.design.R.id.snackbar_text);
//            textView.setGravity(Gravity.CENTER);
//            textView.setTextColor(Color.WHITE);
//            snackbar.show();
//        }
//    }
//
//    /**
//     * @param ct
//     * @param v       CoordinatorLayout must re rotate 180 in view
//     * @param message
//     */
//    public static void showSnackbarFromTop(@NonNull Context ct, @NonNull CoordinatorLayout v, String message) {
//        Snackbar snackbar = Snackbar.make(v, message, Snackbar.LENGTH_LONG);
//        View sbView = snackbar.getView();
//        ((Snackbar.SnackbarLayout) sbView).setRotation(180);
//        TextView textView = (TextView) sbView.findViewById(android.support.design.R.id.snackbar_text);
//        textView.setGravity(Gravity.CENTER);
//        textView.setTextColor(Color.WHITE);
//        snackbar.show();
//    }


    public static void showHello(final Activity activity, long duration, String mess) {
        if (activity == null)
            return;
        ViewGroup rootView = (ViewGroup) activity.findViewById(android.R.id.content);
        if (helloView != null) {
            rootView.removeView(helloView);
            if (handler != null && runnableHideHello != null)
                handler.removeCallbacks(runnableHideHello);
        }
        try {
            if (activity == null)
                return;

            activity.runOnUiThread(new Runnable() {

                @SuppressLint("InflateParams")
                @Override
                public void run() {
                    try {
                        LayoutInflater inflater = LayoutInflater.from(activity);
                        helloView = inflater.inflate(R.layout.toast_notify, null);
                        TextView tvMessage = helloView.findViewById(R.id.tvDescription);
                        ImageView ivToast = helloView.findViewById(R.id.ivToast);
                        tvMessage.setText(mess);
                        rootView.addView(helloView);
                        helloView.startAnimation(AnimationUtils.loadAnimation(activity, R.anim.top_in));
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (runnableHideHello == null)
                runnableHideHello = new Runnable() {

                    @Override
                    public void run() {
                        hideHello(activity, true);
                    }
                };
            if (handler == null)
                handler = new Handler();
            handler.postDelayed(runnableHideHello, duration + 500);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Runnable runnableHideHello;
    public static Handler handler;

    public static void hideHello(@NonNull Activity activity, boolean isAnimated) {
        if (activity == null)
            return;
        if (isAnimated) {
            try {
                activity.runOnUiThread(new Runnable() {
                    public void run() {
                        Animation animation = AnimationUtils.loadAnimation(
                                activity, R.anim.top_out);
                        animation.setAnimationListener(new Animation.AnimationListener() {
                            @Override
                            public void onAnimationStart(Animation animation) {
                            }

                            @Override
                            public void onAnimationRepeat(Animation animation) {
                            }

                            @Override
                            public void onAnimationEnd(Animation animation) {
                                ViewGroup rootView = (ViewGroup) activity
                                        .findViewById(android.R.id.content);
                                rootView.removeView(helloView);
                                helloView = null;
                            }
                        });
                        helloView.startAnimation(animation);
                    }
                });
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                ViewGroup rootView = (ViewGroup) activity.findViewById(android.R.id.content);
                rootView.removeView(helloView);
                helloView = null;
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

}
