package com.game.sdk.comon.config;

import android.app.Activity;
import android.text.TextUtils;

import com.game.sdk.comon.constants.Constants;
import com.game.sdk.comon.game.GameSdk;
import com.game.sdk.comon.login.FacebookManager;
import com.game.sdk.comon.object.SdkConfigObj;
import com.game.sdk.comon.object.UserObj;
import com.game.sdk.comon.sharePref.PrefManager;
import com.game.sdk.comon.utils.DeviceUtils;
import com.mobgame.MobGameSDK;
import com.mobgame.model.CharacterInfo;
import com.mobgame.utils.Preference;

public class GameConfigs {

    private static GameConfigs gameConfigs;
    private String appKey;
    private SdkConfigObj sdkConfig;
    private CharacterInfo characterInfo;
    private boolean show_qc;
    //    private String FCM_APP_API_KEY = "e83661bc7c7f639e5f0334471c8188deb8d5542a";
    private String FCM_APP_API_KEY = "d5f66e393eaab40f72e6b7d3ca5f32f275db5bd5";


    UserObj user;

    public static GameConfigs getInstance() {
        if (gameConfigs == null)
            gameConfigs = new GameConfigs();
        return gameConfigs;
    }

    private GameConfigs() {
    }

    public static void clearInstance() {
        getInstance().setUser(null);
        getInstance().clearCharacterInfo();
        getInstance().setSdkConfig(null);
    }


    public String getAppKey() {
        if (appKey == null) {
            return PrefManager.getAppKey(GameSdk.getInstance().getApplication());
        }
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
        PrefManager.saveAppKey(GameSdk.getInstance().getApplication(), appKey);
    }

    public UserObj getUser() {
        if (user == null) {
            return PrefManager.getUser(GameSdk.getInstance().getApplication());
        }
        return user;
    }

    public void setUser(UserObj user) {
        this.user = user;
        PrefManager.saveUser(GameSdk.getInstance().getApplication(), user);
    }


    public SdkConfigObj getSdkConfig() {
        return sdkConfig;
    }

    public void setSdkConfig(SdkConfigObj sdkConfig) {
        if (sdkConfig == null) {
            this.sdkConfig = null;
            return;
        }
        this.sdkConfig = sdkConfig;
        if (sdkConfig.getEx() != null && sdkConfig.getEx().isShowLogo()) {
            MobGameSDK.getInstance().requestOverlayPermission(MobGameSDK.activity);
        }
        GameConfigs.getInstance().setShow_qc(true);
        GameConfigs.getInstance().initAds(sdkConfig.getAds());
        PrefManager.saveBoolean(GameSdk.getInstance().getApplication(),
                com.mobgame.utils.Constants.SHARED_PREF_DB_ENABLED,
                true);
        PrefManager.saveSetting(GameSdk.getInstance().getApplication(), Constants.SESSION_OUT_TIME, sdkConfig.getSessionOutTime());
    }

    public CharacterInfo getCharacterInfo() {
        if (characterInfo == null) {
            characterInfo = new CharacterInfo();
        }
        return characterInfo;
    }

    public void setCharacterInfo(CharacterInfo characterInfo) {
        this.characterInfo = characterInfo;
    }

    public void clearCharacterInfo() {
        this.characterInfo = null;
    }

    public boolean isLogin() {
        return !TextUtils.isEmpty(PrefManager.getAccessToken(GameSdk.getInstance().getApplication()));
    }

    public void initFacebook(String facebookAppId) {
        FacebookManager.getInstance(GameSdk.getInstance().getApplication()).init(facebookAppId);

    }

    public void initAds(SdkConfigObj.Ads config) {
        Activity a = MobGameSDK.activity;
        Preference.save(a, Constants.FUNTAP_ADS_KEY, config.getApiKey());
    }

    public boolean getShow_qc() {
        return show_qc;
    }

    public void setShow_qc(boolean show_qc) {
        this.show_qc = show_qc;
    }

    public SdkConfigObj.Pop getMobPopup() {
        if (sdkConfig == null || sdkConfig.getPop() == null) {
            return new SdkConfigObj.Pop();
        }
        return sdkConfig.getPop();
    }

    public String getLang() {
        return DeviceUtils.getLanguage();
    }

    public SdkConfigObj.GoogleIAB getGgIABConfig() {
        return sdkConfig == null ? null : new SdkConfigObj.GoogleIAB();
    }


    public String getFcmApiKey() {
        return FCM_APP_API_KEY;
    }
}
